<?php

use App\Mail\MyTestEmail;
use App\Models\Admin\User;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Mail\NewUserWelcomeMail;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Password;
// use App\Http\Controllers\Admin\Svcs\SvcsController;
use Illuminate\Auth\Events\PasswordReset;
use App\Http\Controllers\Admin\CmsController;
use App\Http\Controllers\Admin\FaqController;
use App\Http\Controllers\Admin\AirlineController;
use App\Http\Controllers\Admin\AirportController;
use App\Http\Controllers\Admin\CouponsController;
use App\Http\Controllers\Admin\DriversController;
use App\Http\Controllers\Admin\FeatureController;
use App\Http\Controllers\Admin\ReportsController;
use App\Http\Controllers\Admin\ServicesController;
use App\Http\Controllers\Admin\VehiclesController;
use App\Http\Controllers\Admin\AdminHomeController;
use App\Http\Controllers\Admin\AdminUserController;
use App\Http\Controllers\Admin\DatabasesController;
use App\Http\Controllers\Email\EmailSentController;
use App\Http\Controllers\Admin\AccountingController;
use App\Http\Controllers\Admin\FareQuotesController;
use App\Http\Controllers\Admin\HomeSliderController;
use App\Http\Controllers\Admin\Sites\SitesController;
use App\Http\Controllers\Admin\VehicleMakeController;
use App\Http\Controllers\Admin\VehiclePartController;
use App\Http\Controllers\Frontend\FrontendController;
use App\Http\Controllers\Admin\Phones\PhoneController;
use App\Http\Controllers\Admin\AdvertisementController;
use App\Http\Controllers\Admin\Cities\CitiesController;
use App\Http\Controllers\Admin\States\StatesController;
use App\Http\Controllers\Admin\Auth\AdminAuthController;
use App\Http\Controllers\Admin\DriverCategoryController;
use App\Http\Controllers\Admin\Country\CountryController;
use App\Http\Controllers\Admin\PayType\PayTypeController;
use App\Http\Controllers\External\ExternalLinkController;
use App\Http\Controllers\Admin\EmployeeCategoryController;
use App\Http\Controllers\Admin\ZipCodes\ZipCodeController;
use App\Http\Controllers\Admin\Airports\AirportsController;
use App\Http\Controllers\Admin\Employees\EmployeeController;
use App\Http\Controllers\Admin\Customers\CustomersController;
use App\Http\Controllers\Admin\Reports\Sales\SalesController;
use App\Http\Controllers\Admin\Reports\DriverReportController;
use App\Http\Controllers\Admin\UserGroup\UserGroupsController;
use App\Http\Controllers\Admin\ExpensesHead\ExpensesHeadController;
use App\Http\Controllers\Admin\OtherCharges\OtherChargesController;
use App\Http\Controllers\Admin\Reservations\ReservationsController;
use App\Http\Controllers\Admin\DiscountRules\DiscountRulesController;
use App\Http\Controllers\Admin\EmailTemplates\EmailTemplateController;
use App\Http\Controllers\Admin\DirectAccounts\DirectAccountsController;
use App\Http\Controllers\Admin\Reports\Expense\ExpenseReportController;
use App\Http\Controllers\Admin\TravellerTypes\TravellerTypesController;
use App\Http\Controllers\Admin\Reports\Customer\CustomerReportController;
use App\Http\Controllers\Admin\Reports\DriverHours\DriverHoursController;
use App\Http\Controllers\Admin\ScheduleServices\ScheduleServicesController;
use App\Http\Controllers\Admin\Reports\ProfitLoss\ProfitLossReportController;
use App\Http\Controllers\Admin\FlightDestinations\FlightDestinationController;
use App\Http\Controllers\Admin\Reports\DriverExpense\DriverExpenseReportController;
use App\Http\Controllers\Admin\TimelyAdditionalCharges\TimelyAdditionalChargesController;

// use App\Http\Controllers\Admin\PtoPSettings\PtopSettingsController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/view-email', function () {
//     return view('emails.send_email');
// });

// Route::get('/email-test-v2',[EmailSentController::class,'testEmail']);



Route::get('/terms-and-conditions', function () {
    return view('frontend.terms-conditions.terms_conditions');
});
Route::get('/truck-booking', function () {
    return view('frontend.reservations.truck-booking');
});

Route::get('/faqs', function () {
    return view('frontend.faqs.faqs');
});
Route::get('/contact-us', function () {
    return view('frontend.contact-us.contact');
});



Route::group(['prefix' => 'if'],function(){
    Route::get('/make/reservation',[ReservationsController::class,'iframeReservation']);
    Route::get('/make/schedule-service',[ScheduleServicesController::class,'iframeScheduleReservation']);
    Route::get('/make/fare-quote',[ReservationsController::class,'iframeFareQuoteView']);
    Route::get('/find/reservation',[ReservationsController::class,'iframeFindReservationView']);
    Route::get('/customer',[ReservationsController::class,'iframeCustomerView'])->name('iframe.customer.login');
    Route::get('/customer/dashboard', [CustomersController::class, 'iFrameCustomerDashboard']);
    Route::get('/customer/profile', [CustomersController::class, 'iFrameCustomerProfile']);
    Route::get('/customer-forget', [AdminAuthController::class, 'iFrameCustomerForgetPage'])->name('iframe-forget');
});
// Route::get('/reservations', function () {
//     return view('frontend.reservations.reservations');
// });

// Route::get('/reservations/{user?}', function ($user = null) {
//     return view('frontend.reservations.reservations', compact('user'));
// });

Route::get('/reservations/{user?}/{userType?}', [ReservationsController::class, 'reservationIndex']);
Route::get('/fare-quote/{user?}/{userType?}', [ReservationsController::class, 'fareQuoteView']);
Route::get('/schedule-service/{user?}/{userType?}', [ScheduleServicesController::class, 'scheduleReservationView']);

Route::get('/get/customer/info/{customerId}/{customerType}', [CustomersController::class, 'getCustomerInfo']);

// Route::get('/sendmail', function (Request $request) {
//     // $ip = $request->ip();
//     Mail::raw('Hi user, a new login into your account from the IP Address: ', function ($message) {
//         $message->from('info@globaltransportationservice.com');
//         $message->to('mriftikhar@gmail.com', 'Hello, Iftikhar');
//     });
// });

Route::get('/google/auth', [EmailSentController::class,'redirectToGoogle'])->name('google.auth');
Route::get('/google/auth/callback', [EmailSentController::class, 'handleGoogleCallback'])->name('google.auth.callback');

// Route::get('/phpinfo', function () {
//     return phpinfo();
// });

// Specially for reservation system
Route::group(['prefix' => 'v2'], function () {
    Route::get('/get/service-types', [ServicesController::class, 'getAllServices']);
    Route::get('/get/airports', [AirportsController::class, 'getAll']);
    Route::get('/get/airlines', [AirlineController::class, 'getAll']);
    Route::get('/get/flight-destinations', [FlightDestinationController::class, 'getAll']);
    Route::get('/get/traveller-types', [TravellerTypesController::class, 'getAll']);
    Route::post('/get/city/service/vehicles', [ServicesController::class, 'getCityServiceVehicles']);
    Route::post('/get/reservation/vehicle-fares', [ServicesController::class, 'getReservationVehicleFares']);
    Route::post('/get/reservation/vehicle-fare-by-ride', [ServicesController::class, 'calculatePricingV2']);
    Route::get('/get/direct-accounts', [DirectAccountsController::class, 'getDirectAccounts']);
    Route::post('/get/verify-direct-account', [DirectAccountsController::class, 'verifyDirectAccounts']);
    Route::post('/verify/coupon', [CouponsController::class, 'validateCoupon']);
    Route::post('/verify/reservation-time-limit', [ServicesController::class, 'verifyReservationTimeLimit']);

    Route::post('/save/reservation', [ReservationsController::class, 'saveReservation']);
    Route::get('/pay_type/get/data', [PayTypeController::class, 'getData']);
    Route::get('/sites/get/data', [SitesController::class, 'getData']);

    Route::get('/schedule-service/departure/locations/list', [ScheduleServicesController::class, 'scheduleServiceList']);

    Route::get('/other_charges/remove/{id}', [OtherChargesController::class, 'removeCharges']);
    // Route::get('/timely_charges/remove/{id}', [TimelyAdditionalChargesController::class, 'removeCharges']);

    Route::get('/vehicles/remove/{id}', [VehiclesController::class, 'removeVehicle']);
    Route::get('/drivers/vehicles', [DriversController::class, 'getDriverVehicle']);


});

//for schedule Fare Calculation
Route::post('/schedule/calculate-fare',[ScheduleServicesController::class,'calculateFare']);
Route::post('/search/schedule/services',[ScheduleServicesController::class,'getSearchedScheduleServices']);
Route::get('get/city/states',[ScheduleServicesController::class,'getCitiesStates']);
//end

Route::get('/get/vehciles-drivers/list', [ReservationsController::class, 'getAllReservationInfo']);
Route::get('/get/all/sites', [ReservationsController::class, 'getAllSites']);



Route::get('/cities/get/services/{cityId}', [FareQuotesController::class, 'getServices']);
Route::post('/city/services/data', [FareQuotesController::class, 'getCityServices']);
Route::post('/city/schedule/services/data', [FareQuotesController::class, 'getCityScheduleServices']);
Route::get('schedule-services/get/client-side/data', [ScheduleServicesController::class, 'getClientSideData']);
Route::get('schedule-services/get/client-side/schedule/data/{rideType}', [ScheduleServicesController::class, 'getScheduleClientSideData']);
Route::get('/get/fare-quotes/data', [FareQuotesController::class, 'getFareQuotesData']);
Route::get('/get/all-airports/data', [ReservationsController::class, 'getAllAirportData']);
Route::get('/get/selected-service/data', [FareQuotesController::class, 'getSelectedServiceData']);
Route::post('/fare-quotes/get/distance', [FareQuotesController::class, 'getDistance']);
Route::get('/get/zip_codes/{cityId}', [FareQuotesController::class, 'getZipCodesData']);
Route::get('/get/zip-code/services/{zipCode}', [FareQuotesController::class, 'getZipCodesServicesData']);
Route::get('/services/get/additional/services', [CitiesController::class, 'getAdditionalServices']);

Route::post('/save/reservations/with-user', [ReservationsController::class, 'saveReservationWithUser']);
Route::post('/save/reservations/with-guest-user', [ReservationsController::class, 'saveReservationWithGuestUser']);
Route::post('/check/coupon/validation', [ReservationsController::class, 'checkCouponValidation']);
Route::post('/get/registered/customer', [ReservationsController::class, 'getRegisteredCustomer']);
Route::get('/get/payment-info/data', [ReservationsController::class, 'getData']);

Route::get('/', [FrontendController::class, 'index'])->name('index');

Route::post('/airport-shuttle/create/reservation', [FrontendController::class, 'createReservations']);

Route::get('/get/reservation/data', [FrontendController::class, 'getReservationData']);

Route::post('/update/complete/reservations', [ReservationsController::class, 'updateReservation']);
Route::post('/update/schedule/reservations', [ReservationsController::class, 'updateScheduleReservation']);

Route::post('/customer/find/reservation', [ReservationsController::class, 'findReservation']);
Route::get('/find-reservation', [ReservationsController::class, 'findReservationPage']);

Route::post('/check/cc/number', [ReservationsController::class, 'checkCCNumber']);



// ************************************************** Admin routes *********************************************
Route::get('/admin', [AdminAuthController::class, 'loginPage'])->name('admin-login-page');
Route::post('/admin/login', [AdminAuthController::class, 'login'])->name('admin-login');
Route::get('/admin/logout', [AdminAuthController::class, 'logout'])->name('admin-logout');


Route::group(['prefix' => 'admin', 'middleware' => 'auth'], function(){

    Route::post('/send-email-reservation', [EmailSentController::class, 'sendEmail']);
    // welcome
    Route::get('/welcome', [AdminHomeController::class, 'welcome'])->name('admin-welcome');
    // select company database
    Route::post('/select/company', [AdminHomeController::class, 'selectCompany']);

    Route::group(['prefix' => '/airport'], function () {

        // Airports
        Route::resource('airports', AirportsController::class);
        Route::post('/airports/export/data/{cityId}', [AirportsController::class, 'getExportedData']);
        Route::post('/airports/get/data', [AirportsController::class, 'getData']);
        Route::post('/airports/check/name', [AirportsController::class, 'checkInputField']);
        Route::get('/airports/get/form/data', [AirportsController::class, 'getFormData']);
        Route::post('/airports/update/is-active/{airportId}', [AirportsController::class, 'updateIsActive']);

        // airlines
        Route::resource('airlines', AirlineController::class);
        Route::get('/airline/get/data', [AirlineController::class, 'getAirlineData']);
        Route::post('/airline/update/is-active/{airlineId}', [AirlineController::class, 'updateIsActive']);
        Route::post('/airlines/export/data', [AirlineController::class, 'importData']);

        // flight destinations
        Route::resource('flight-destinations', FlightDestinationController::class);
        Route::post('/flight-destinations/get/data', [FlightDestinationController::class, 'getData']);
        Route::get('/flight-destinations/get/form/data', [FlightDestinationController::class, 'getFormData']);
        Route::post('/flight_destination/update/is-active/{stateId}', [FlightDestinationController::class, 'updateIsActive']);
});

    Route::group(['prefix' => '/driver'], function () {

       //drivers
       Route::resource('drivers', DriversController::class);
       Route::get('/get/driver/list', [DriversController::class, 'getDriversList']);
       Route::get('/countries/get/data/{countryId}', [CitiesController::class, 'getStatesData']);
       Route::put('/get/states', [DriversController::class, 'getStates']);
       Route::put('/get/cities', [DriversController::class, 'getCities']);
       Route::put('/check/email', [DriversController::class, 'checkEmail']);
       Route::put('/check/driverId/', [DriversController::class, 'checkDriverId'],);
       Route::post('/update/{driverId}', [DriversController::class, 'update']);
       Route::post('/update/is-active/{driverId}', [DriversController::class, 'updateIsActive']);
       Route::post('/update/duty/status/{driverId}', [DriversController::class, 'updateDutyStatus']);
       Route::get('/get/server/data', [DriversController::class, 'getServerData']);
       Route::get('/get/driver/activity/log/{driverId}', [DriversController::class, 'getDriverActivityLog']);
       Route::delete('/drivers/vehicle/delete/{vehicleId}', [DriversController::class, 'deleteVehicle']);
       Route::post('/drivers/vehicle/save', [DriversController::class, 'saveVehicle']);
       Route::post('/sendTextMessage', [DriversController::class, 'sendTextMessage']);
       Route::post('/sendCustomTextMessage', [DriversController::class, 'sendCustomTextMessage']);

       // driver categories
       Route::resource('driver-categories', DriverCategoryController::class);
       Route::post('/driver-category/update/is-active/{categoryId}', [DriverCategoryController::class, 'updateIsActive']);

        //blocked drivers
       Route::get('/blocked-drivers/index', [ReservationsController::class, 'blockedDriversIndex']);
       Route::get('/blocked-drivers/get/form/data', [ReservationsController::class, 'getFormData']);
       Route::post('/blocked-drivers/update/is-active/{airportId}', [ReservationsController::class, 'updateIsActive']);

       //Driver Hour Reports
       Route::get('/driver-report', [DriverHoursController::class, 'index']);
       Route::get('/driver-reservations', [DriverHoursController::class, 'getFilterData']);

       Route::get('/driver-expense-report', [DriverExpenseReportController::class, 'index']);
       Route::get('/get-filtered-driver-expense', [DriverExpenseReportController::class, 'getGroupedData']);

       Route::get('driver-summary',[DriverReportController::class,'index']);
       Route::get('driver-summary-detail',[DriverReportController::class,'getFilteredData']);

   });

    Route::group(['prefix' => '/reports'], function () {
        //Sales Reports
        Route::get('/sales', [SalesController::class, 'index']);
        Route::get('/get-filtered-reservations', [SalesController::class, 'getFilterData']);

        Route::get('/expense-report', [ExpenseReportController::class, 'index']);
        Route::get('/expense/get/data', [ExpenseReportController::class, 'getData']);
        Route::get('/expense-data', [ExpenseReportController::class, 'getExpenseData']);

        //Profit Loss
        Route::get('/profit-loss-reports', [ProfitLossReportController::class, 'index']);
        Route::get('/get-filtered-profit-loss', [ProfitLossReportController::class, 'getFilterData']);

        Route::get('/customer-email-report', [CustomerReportController::class, 'emailIndex']);
        Route::get('/get-filtered-email', [CustomerReportController::class, 'getFilterEmail']);

        //Customer Phone Report
        Route::get('/customer-phone-report', [CustomerReportController::class, 'phoneIndex']);
        Route::get('/get-filtered-phone', [CustomerReportController::class, 'getFilterPhone']);
    });

    //user profile
    Route::get('/user-profile', [AdminHomeController::class, 'userProfilePage']);
    Route::post('/user-profile/update', [AdminHomeController::class, 'userProfileUpdate']);

    //change password
    Route::get('/change-password', [AdminHomeController::class, 'changePasswordPage'])->name('change-password');
    Route::post('/check-password', [AdminHomeController::class, 'checkPassword']);
    Route::post('/update-password', [AdminHomeController::class, 'updatePassword']);

    //admin users
    Route::get('/user/admin_users', [AdminHomeController::class, 'adminUsers']);

    // Route::put('/admin-user', [AdminUserController::class, 'store']);
    // Route::get('/admin-user/{userId}', [AdminUserController::class, 'edit']);
    // Route::put('/admin-user/update/{userId}', [AdminUserController::class, 'update']);
    // //user email check
    // Route::put('/user/check/email', [AdminUserController::class, 'checkEmail']);
    // Route::put('/user/update/is-active/{userId}', [AdminUserController::class, 'updateIsActiveForAdminUser']);

    // Reservations
    Route::resource('reservations', ReservationsController::class);
    Route::get('/get/reservation-data', [ReservationsController::class, 'getReservationData']);


    Route::post('/get/reservations', [ReservationsController::class, 'searchReservations']);
    // Route::get('/get/all/reservation/info_data', [ReservationsController::class, 'getAllReservationInfo']);
    Route::get('/get/activity/log/{reservationId}', [ReservationsController::class, 'getActivityLog']);


    Route::post('/save/reservations/with-user', [ReservationsController::class, 'saveReservationWithUser']);
    Route::post('/save/reservations/with-guest-user', [ReservationsController::class, 'saveReservationWithGuestUser']);
    Route::post('/customer/notes', [ReservationsController::class, 'saveCustomerNotes']);
    Route::post('/customer/block/{id}', [CustomersController::class, 'updateCustomerIsActive']);
    Route::post('/cancel/reservation/status', [ReservationsController::class, 'cancelReservationStatus']);
    Route::post('/edit/flight/{reservationId}', [ReservationsController::class, 'editFlightInformation']);
    Route::post('/edit/flight/date/{reservationId}', [ReservationsController::class, 'editFlightDateTimeInformation']);
    Route::get('/get/flight/information', [ReservationsController::class, 'getEditFlightInformation']);
    Route::post('/update/driver/info', [ReservationsController::class, 'updateDriverInfo']);
    Route::post('/update/driver/status', [ReservationsController::class, 'updateDriverStatus']);
    Route::post('/give/discount', [ReservationsController::class, 'giveDiscount']);
    Route::post('/reset/reservation', [ReservationsController::class, 'resetReservation']);
    Route::post('/undo/reservation', [ReservationsController::class, 'undoReservation']);
    Route::post('/undo/last/reservation', [ReservationsController::class, 'undoLastReservation']);
    // Route::post('/send-email', [ReservationsController::class, 'loginRequest']);
    Route::get('/update/reservation/status/{reservationId}/{reservationStatus?}', [ReservationsController::class, 'updateReservationStatus']);
    Route::get('/update/cc_status/{customerId}/{customerType}', [ReservationsController::class, 'updateCCStatus']);

    Route::post('/update/customer/information', [ReservationsController::class, 'updateCustomer']);
    Route::post('/customer/block-driver', [ReservationsController::class, 'blockDriver']);

    Route::get('/customers/list',[CustomersController::class,'index']);
    Route::resource('customers', CustomersController::class)->except('index');
    Route::get('customers/import/customers',[CustomersController::class,'importCustomerPage']);
    Route::post('customers/import/data',[CustomersController::class,'importCustomers']);
    Route::get('customers/export/customers',[CustomersController::class,'exportCustomerPage']);
    Route::get('customers/export/customers/data/{type}',[CustomersController::class,'exportCustomers']);

    Route::group(['prefix' => '/management'], function () {

        // countries
        Route::resource('countries', CountryController::class);
        Route::post('/country/check/name', [CountryController::class, 'checkName']);
        Route::get('/country/add/state', [CountryController::class, 'store']);
        Route::get('/countries/get/form/data', [CountryController::class, 'getFormData']);
        Route::post('/country/update/is-active/{countryId}', [CountryController::class, 'updateIsActive']);

        //employees
        Route::resource('employees', EmployeeController::class);

        //email Templates
        Route::resource('email-templates', EmailTemplateController::class);
        Route::get('email-templates/get/data', [EmailTemplateController::class, 'getData']);

        //employees
        Route::resource('expenses_head', ExpensesHeadController::class);
        Route::get('/expenses_head/get/server/data', [ExpensesHeadController::class, 'getServerData']);
        Route::post('/expenses_head/update/is-active/{expenseId}', [ExpensesHeadController::class, 'updateIsActive']);
        Route::post('/expenses_head/update/is-report-active/{expenseId}', [ExpensesHeadController::class, 'updateIsReportActive']);

        //customers controller
        Route::get('/get/all/customers', [CustomersController::class, 'getCustomersData']);

        Route::get('/get/all/customers/badges', [CustomersController::class, 'getBadgesData']);
        Route::get('get/admin/authentication', [CustomersController::class, 'getAdminAuthentication']);
        Route::get('/get/customer/password/{customerId}', [CustomersController::class, 'getCustomerPassword']);
        Route::post('/get/searched/customers', [CustomersController::class, 'getSearchedCustomers']);
        Route::post('/admin/update/customer/password', [CustomersController::class, 'adminUpdateCustomerPassword']);
        Route::post('/get/date-range/customers', [CustomersController::class, 'getDateRangeCustomers']);
        Route::post('/customer/reservations', [CustomersController::class, 'getCustomerReservations']);
        Route::post('/get/customer/notes', [CustomersController::class, 'getCustomerNotes']);
        Route::post('/crud/create', [CustomersController::class, 'createCrud']);
        Route::post('/customers/update/is-active/{customerId}', [CustomersController::class, 'updateCustomerIsActive']);
        Route::post('/guest-customers/update/is-active/{guestCustomerId}', [CustomersController::class, 'updateGuestCustomerIsActive']);

        Route::put('/employee/check/email', [EmployeeController::class, 'checkEmail'],);
        Route::post('/employee/update/{employeeId}', [EmployeeController::class, 'update'],);
        Route::post('/employee/update/is-active/{employeeId}', [EmployeeController::class, 'updateIsActive']);



        // coupons
        Route::resource('coupons', CouponsController::class);
        Route::post('/coupon/update/is-active/{couponId}', [CouponsController::class, 'updateIsActive']);
        Route::get('/vehicle_type/get/all_vehicle_type/{cityId}', [CouponsController::class, 'getVehicles']);
        Route::get('/vehicle_type/get/vehicle_type/{cityId}', [CouponsController::class, 'getData']);
        Route::get('/get/services', [CouponsController::class, 'getServicesData']);
        // Route::get('/vehicles/get/all_vehicles/{cityId}', [CouponsController::class, 'getCities']);



         //services
        Route::resource('services', ServicesController::class);
        Route::post('/service/update/is-active/{serviceId}', [ServicesController::class, 'updateIsActive']);
        Route::post('/cities/add/services', [ServicesController::class, 'addVehicleServices']);
        Route::post('/cities/update/services/{id}', [ServicesController::class, 'updateVehicleServices']);
        Route::post('/city/millage/services/{cityId}', [ServicesController::class, 'editServices']);
        Route::get('/get/all/services', [ServicesController::class, 'getAllServices']);
        Route::post('/get/city/services/settings/data', [ServicesController::class, 'getCityServicesSettings']);

        Route::get('price/calculate', [ServicesController::class, 'priceCalculator']);

        // Direct Accounts
        Route::resource('direct_accounts', DirectAccountsController::class);
        Route::get('/direct_accounts/get/server/data', [DirectAccountsController::class, 'getServerData']);
        Route::post('/direct_accounts/update/is-active/{accountId}', [DirectAccountsController::class, 'updateIsActive']);

        //User Groups
        Route::resource('user_groups', UserGroupsController::class);
        Route::get('/user_groups/get/server/data', [UserGroupsController::class, 'getServerData']);
        Route::get('/user_group/get/form/data', [UserGroupsController::class, 'getFormData']);
        Route::post('/user_groups/update/is-active/{id}', [UserGroupsController::class, 'updateIsActive']);
        Route::post('/user_groups/permissions/{groupId}', [UserGroupsController::class, 'updateUserPermissions']);
        Route::post('/user_groups/permissions', [UserGroupsController::class, 'saveUserPermissions']);

        // cms
        Route::resource('cms', CmsController::class);
        Route::post('/cms/update/{cmsId}', [CmsController::class, 'update']);
        Route::post('/cms/update/is-active/{cmsId}', [CmsController::class, 'updateIsActive']);

        // States
        Route::resource('states', StatesController::class);
        Route::get('/states/get/data/{countryId}', [StatesController::class, 'getData']);
        Route::post('/states/export/data/{countryId}', [StatesController::class, 'getExportedData']);
        Route::post('/states/check/name', [StatesController::class, 'checkInputField']);
        Route::post('/states/update/is-active/{stateId}', [StatesController::class, 'updateIsActive']);
        Route::post('/state_reserved/update/is-active/{stateId}', [StatesController::class, 'updateIsReserved']);

        // Cities
        Route::resource('cities', CitiesController::class);
        Route::post('/cities/export/data/{stateId}', [CitiesController::class, 'getExportedData']);
        Route::post('/cities/apply/settings/other/cities', [CitiesController::class, 'applySettingsCities']);
        Route::get('/cities/get/data/{stateId}', [CitiesController::class, 'getData']);
        Route::get('/countries/get/data/{countryId}', [CitiesController::class, 'getStatesData']);
        Route::post('/cities/check/name', [CitiesController::class, 'checkName']);
        Route::get('/get/form/data', [CitiesController::class, 'getFormData']);
        Route::post('/cities/update/is-active/{stateId}', [CitiesController::class, 'updateIsActive']);
        Route::post('/city_reserved/update/is-reserved/{stateId}', [CitiesController::class, 'updateIsReserved']);
        Route::post('/services/get/service/data', [CitiesController::class, 'getServiceData']);
        Route::post('/services/get/additional/service/data', [CitiesController::class, 'getAdditionalServiceData']);

        // Phones
        Route::resource('phones', PhoneController::class);
        Route::post('/phones/get/data', [PhoneController::class, 'getData']);
        Route::get('/phones/list', [PhoneController::class, 'getData']);
        Route::post('/phones/update/is-active/{stateId}', [PhoneController::class, 'updateIsActive']);

        // Zip Codes
        Route::resource('zip_codes', ZipCodeController::class);
        Route::post('/zip_codes/export/data/{cityId}', [ZipCodeController::class, 'getExportedData']);
        Route::get('/cities/get/all_cities/{stateId}', [ZipCodeController::class, 'getCities']);
        Route::get('/zip_codes/get/data/{cityId}', [ZipCodeController::class, 'getZipCodes']);
        Route::get('/zip_codes/get/zip_codes/{cityId}', [ZipCodeController::class, 'getData']);
        Route::post('/zip_codes/check/name', [ZipCodeController::class, 'checkInputField']);
        Route::get('/zip_codes/get/form/data', [ZipCodeController::class, 'getFormData']);
        Route::post('/zip_codes/update/is-active/{zipCodeId}', [ZipCodeController::class, 'updateIsActive']);
        Route::post('/zip_code_reserved/update/is-active/{zipCodeId}', [ZipCodeController::class, 'updateIsReserved']);

           //schedule services
        Route::resource('schedule-services', ScheduleServicesController::class);
        Route::get('schedule-services/get/data', [ScheduleServicesController::class, 'getData']);
        Route::get('schedule-services/city/{cityId}', [ScheduleServicesController::class, 'getCityData']);
        Route::get('schedule-services/get/form/data', [ScheduleServicesController::class, 'getFormData']);
        Route::post('/schedule-services/update/is-active/{countryId}', [ScheduleServicesController::class, 'updateIsActive']);

        //sites
        Route::resource('sites', SitesController::class);
        Route::get('/sites/get/data', [SitesController::class, 'getData']);
        Route::post('/sites/update/is-active/{siteId}', [SitesController::class, 'updateIsActive']);


    });

    Route::group(['prefix' => '/vehicle'], function () {
         // vehicle_makes
        Route::resource('vehicle_makes', VehicleMakeController::class);

        Route::post('/vehicle_make/update/{vehicleMakeId}', [VehicleMakeController::class, 'update']);
        Route::post('/vehicle_make/update/is-active/{vehicleMakeId}', [VehicleMakeController::class, 'updateIsActive']);
        // Route::get('/vehicle_types/get/form/data', [VehicleMakeController::class, 'getFormData']);
        Route::get('/get/vehicle/activity/log/{vehicleMakeId}', [VehicleMakeController::class, 'getVehicleActivityLog']);
        Route::post('/vehicle_make/import/data', [VehicleMakeController::class, 'importData']);

         // Vehicle Types
        Route::resource('vehicles', VehiclesController::class);
        Route::get('/list', [VehiclesController::class, 'getVehicleList']);
        Route::post('/update/is-active/{vehiclesId}', [VehiclesController::class, 'updateIsActive']);
        Route::post('/update/{vehiclesId}', [VehiclesController::class, 'update']);


        //vehicle parts
        Route::resource('vehicle_parts', VehiclePartController::class);
        Route::get('/vehicle_parts/get/server/data', [VehiclePartController::class, 'getServerData']);
        Route::post('/vehicle_parts/update/is-active/{id}', [VehiclePartController::class, 'updateIsActive']);

    });
    Route::group(['prefix' => '/setting'], function () {

        // //svcs
        // Route::resource('svcs', SvcsController::class);
        // Route::post('/svc/update/is-active/{svcId}', [SvcsController::class, 'updateIsActive']);
        // Route::get('/svcs/get/data', [SvcsController::class, 'getData']);

        //other-charges
        Route::resource('other_charges', OtherChargesController::class);
        Route::post('/other_charges/update/is-active/{otherChargesId}', [OtherChargesController::class, 'updateIsActive']);
        Route::get('/other_charges/get/data', [OtherChargesController::class, 'getData']);
        Route::get('/get/other_charges', [OtherChargesController::class, 'getFormData']);

        //timely-additional-charges
        Route::resource('timely_additional_charges', TimelyAdditionalChargesController::class);
        Route::get('/timely_additional_charges/get/data', [TimelyAdditionalChargesController::class, 'getData']);
        Route::post('/timely_additional_charges/update/is-active/{timelyAdditionalChargesId}', [TimelyAdditionalChargesController::class, 'updateIsActive']);


        //discount-rules
        Route::resource('discount_rules', DiscountRulesController::class);
        Route::post('/discount_rule/update/is-active/{discountRuleId}', [DiscountRulesController::class, 'updateIsActive']);
        Route::get('/discount_rule/get/data', [DiscountRulesController::class, 'getData']);

        // //ptop-setting
        // Route::resource('ptop_settings', PtopSettingsController::class);
        // Route::post('/ptop_setting/update/is-active/{ptopSettingId}', [PtopSettingsController::class, 'updateIsActive']);
        // Route::get('/ptop_setting/get/data', [PtopSettingsController::class, 'getData']);

        //pay-types
        Route::resource('pay_types', PayTypeController::class);
        Route::post('/pay_type/update/is-active/{payTypeId}', [PayTypeController::class, 'updateIsActive']);
        Route::get('/pay_type/get/data', [PayTypeController::class, 'getData']);

        Route::resource('traveller_types', TravellerTypesController::class);
        Route::get('/traveller_types/get/data', [TravellerTypesController::class, 'getData']);

    });

    // Dashboard
    Route::get('/dashboard', [AdminHomeController::class, 'dashboard'])->name('admin-dashboard');
    Route::get('/main', [AdminHomeController::class, 'afterLogin'])->name('after-login');
    Route::get('/get/all/modules', [AdminHomeController::class, 'getAllModules']);

    // Route::get('/dashboard', [DashboardController::class, 'index']);
    Route::get('dashboard/reservation/count/line/{dateRange}', [AdminHomeController::class, 'getReservationCountForLineChart']);
    Route::get('dashboard/reservation/amount/line', [AdminHomeController::class, 'getIncomeExpenseForLineChart']);
    Route::get('dashboard/profit/loss/{dateRange}', [AdminHomeController::class, 'getProfitLoss']);
    Route::get('dashboard/get/data', [AdminHomeController::class, 'getData']);
    Route::get('dashboard/get/card/data', [AdminHomeController::class, 'cardData']);

    // User
    // Route::resource('user', AdminUserController::class);
    // //user is-active status
    // Route::post('/user/update/is-active/{userId}', [AdminUserController::class, 'updateIsActive']);

    Route::get('/databases', [DatabasesController::class, 'index'])->name('admin-databases');

    Route::get('/fare-quotes', [FareQuotesController::class, 'index'])->name('admin-fare-quotes');
    Route::get('/fare-quotes-v1', [FareQuotesController::class, 'indexV1']);
    // Route::get('/cities/get/services/{cityId}', [FareQuotesController::class, 'getServices']);
    // Route::post('/city/services/data', [FareQuotesController::class, 'getCityServices']);
    // Route::get('/get/fare-quotes/data', [FareQuotesController::class, 'getFareQuotesData']);
    // Route::get('/get/selected-service/data', [FareQuotesController::class, 'getSelectedServiceData']);
    Route::post('/fare-quotes/get/distance', [FareQuotesController::class, 'getDistance']);
    // Route::get('/get/zip_codes/{cityId}', [FareQuotesController::class, 'getZipCodesData']);
    // Route::get('/get/zip-code/services/{zipCode}', [FareQuotesController::class, 'getZipCodesServicesData']);

    Route::resource('advertisement', AdvertisementController::class);

    Route::resource('reports', ReportsController::class);

    // faqs
    Route::resource('faqs', FaqController::class);

    // home sliders
    Route::resource('home-sliders', HomeSliderController::class);
    Route::post('/home-slider/update/{sliderId}', [HomeSliderController::class, 'update']);

    // features
    Route::resource('features', FeatureController::class);
    Route::post('/feature/update/{featureId}', [FeatureController::class, 'update']);

    // employee Category
    Route::resource('employee-categories', EmployeeCategoryController::class);
    Route::post('/employee_category/update/is-active/{categoryId}', [EmployeeCategoryController::class, 'updateIsActive']);

    Route::resource('accounting', AccountingController::class);
    Route::get('/accounting/get/all/accounts/{date}', [AccountingController::class, 'getAllAccountsByDate']);
    Route::get('/accounting/get/form/data', [AccountingController::class, 'getFormData']);

});

Route::get('/driver', [AdminAuthController::class, 'showDriverLoginForm'])->name('driver.login');
Route::post('/driver/login', [AdminAuthController::class, 'driverLogin'])->name('driver.login.submit');
Route::post('/driver/security/answer', [DriversController::class, 'checkDriverSecurityAnswer']);
Route::post('/driver/authentication', [DriversController::class, 'driverEmailAuthentication']);
Route::post('/driver/update/password', [DriversController::class, 'updatePassword']);

Route::get('/customer', [AdminAuthController::class, 'showCustomerLoginForm'])->name('customer.login');
Route::post('/customer/login', [AdminAuthController::class, 'customerLogin'])->name('customer.login.submit');
Route::get('/customer-forget', [AdminAuthController::class, 'customerForgetPage']);
Route::put('/customer/check/email', [CustomersController::class, 'checkCustomerEmail']);
Route::post('customer/store', [CustomersController::class, 'store']);
Route::get('/customer/edit/{id}/{customer_type}', [CustomersController::class, 'edit']);
Route::get('/get/security/question', [CustomersController::class, 'getSecurityQuestion']);
Route::post('/customer/security/answer', [CustomersController::class, 'checkCustomerSecurityAnswer']);
Route::post('/customer/authentication', [CustomersController::class, 'customerEmailAuthentication'])->middleware('guest')->name('customer-authenticate');
Route::post('/customer/update/password', [CustomersController::class, 'updatePassword']);
Route::put('/customer/update/{id}/{customer_type}', [CustomersController::class, 'update']);

Route::get('/reset-password/{token}', function ($token) {
    return view('customer.auth.reset-password', ['token' => $token]);
})->middleware('guest')->name('password.reset');

Route::post('/reset-password', [AdminAuthController::class, 'resetCustomerPassword'])->middleware('guest')->name('password.update');
// ************************************************** Driver routes *********************************************

Route::middleware('auth:driver', 'driver')->group(function () {
    Route::get('driver/dashboard', [DriversController::class, 'dashboard'])->name('driver.dashboard');
    Route::get('/get/all/reservation/info_data', [DriversController::class, 'getAllReservationInfo']);
    Route::post('/get/driver/reservations', [DriversController::class, 'getDriverReservations']);
    // Route::get('/get/driver/tomorrow/reservations', [DriversController::class, 'getTomorrowReservations']);
    // Route::post('/get/driver/date-range/reservations', [DriversController::class, 'getDateRangeReservations']);
    Route::get('/get/all/customers', [DriversController::class, 'getAllCustomers']);
    Route::post('/driver/update/reservation/status', [DriversController::class, 'updateReservationStatus']);

    Route::get('/vehicle_types/get/form/data', [DriversController::class, 'getVehicleMakeData']);
    Route::get('/vehicle_types/get/edit/form/data', [DriversController::class, 'getEditVehicleMakeData']);
    Route::get('/get/millage/value/{id}', [DriversController::class, 'getVehicleMillage']);
    Route::get('/get/date/vehicle_condition/{date}/{driverId}', [DriversController::class, 'getVehicleConditionByDate']);
    Route::get('/driver/vehicle/selected/data', [DriversController::class, 'getRequiredData']);
    Route::post('/driver/save/vehicle/select', [DriversController::class, 'saveDriverVehicle']);
    Route::post('/driver/update/vehicle/select/{id}/{date}', [DriversController::class, 'updateDriverVehicle']);
    Route::post('/driver/save/driver/expenses', [DriversController::class, 'saveDriverExpenses']);
     //change password
    Route::post('/driver/check-password', [DriversController::class, 'checkDriverPassword']);
    Route::post('/driver/update-password', [DriversController::class, 'updateDriverPassword']);

    Route::get('/driver/logout', [DriversController::class, 'logout']);
});

// ************************************************** Customer routes *********************************************
Route::middleware('auth:customer')->group(function () {
    Route::get('/customer/dashboard', [CustomersController::class, 'dashboard']);
    Route::get('/get/all/reservation/vehicle_info', [CustomersController::class, 'getAllReservationInfo']);
    //Route::get('/get/customer/reservations', [CustomersController::class, 'getCustomerAllReservations']);
    Route::post('/get/customer/reservations', [CustomersController::class, 'getCustomerAllReservations']);
    Route::get('/update/reservation/status/{reservationId}/{reservationStatus?}', [ReservationsController::class, 'updateReservationStatus']);
    Route::get('/get/flight/information', [ReservationsController::class, 'getEditFlightInformation']);
    Route::post('/get/customer/date-range/reservations', [CustomersController::class, 'getDateRangeReservations']);
    Route::post('/edit/flight/date/{reservationId}', [ReservationsController::class, 'editFlightDateTimeInformation']);
    Route::post('/edit/flight/{reservationId}', [ReservationsController::class, 'editFlightInformation']);
    Route::post('/cancel/reservation/status', [ReservationsController::class, 'cancelReservationStatus']);
    //change password
    Route::post('/customer/check-password', [CustomersController::class, 'checkCustomerPassword']);
    Route::post('/customer/update-password', [CustomersController::class, 'updateCustomerPassword']);

    Route::get('/customer/logout', [CustomersController::class, 'logout']);
});

Route::get('remove/services',[ScheduleServicesController::class,'removePrevious']);
Route::get('update/charges',[ScheduleServicesController::class,'updateCharges']);


Route::group(['prefix' => '/ext'] , function(){
    Route::get('/{token}/reservation',[ExternalLinkController::class,'makeReservation']);
    Route::get('/{token}/fare-quote',[ExternalLinkController::class,'fareQuote']);
    Route::get('/{token}/customer',[ExternalLinkController::class,'customerLogin'])->name('extCustomer');
    Route::get('/{token}/customer/dashboard',[ExternalLinkController::class,'customerDashboard']);
    Route::get('/{token}/schedule-service',[ExternalLinkController::class,'scheduleService']);
    Route::get('/{token}/find-reservation',[ExternalLinkController::class,'findReservation']);
    Route::get('/{token}/logout', [ExternalLinkController::class, 'logout']);
});
