<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\MigrationsController;
use App\Http\Controllers\Admin\CouponsController;
use App\Http\Controllers\admin\DriversController;
use App\Http\Controllers\Admin\ServicesController;
use App\Http\Controllers\Email\EmailSentController;
use App\Http\Controllers\Admin\FareQuotesController;
use App\Http\Controllers\Admin\Auth\AdminAuthController;
use App\Http\Controllers\Admin\Country\CountryController;
use App\Http\Controllers\Admin\Customers\CustomersController;
use App\Http\Controllers\Admin\Reservations\ReservationsController;
use App\Http\Controllers\Admin\DirectAccounts\DirectAccountsController;
use App\Http\Controllers\Admin\ScheduleServices\ScheduleServicesController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
// Route::post('run/admin/migrations', [MigrationsController::class, 'adminMigrations'])->name('run-admin-migrations');
Route::post('get/states', [DriversController::class, 'postRequest']);

Route::get('get/countries', [CountryController::class, 'store']);

Route::post('register/customer', [CustomersController::class, 'registerCustomer']);


//Websites APIs

Route::post('/register/customers', [CustomersController::class, 'apiStore']);

Route::post('/login', [CustomersController::class, 'apiLogin']);
Route::post('/city/services/data', [FareQuotesController::class, 'getCityServices']);


// Route::get('price/calculate', [ServicesController::class, 'priceCalculator']);
Route::get('/verify/domain',[ReservationsController::class,'verifyDomain']);
Route::post('/customer/login', [AdminAuthController::class, 'customerLogin']);
// ability same as (OR operator) is used if at least one ability is available and abilities same as (AND operator) is used if every ability fulfilled the condition
Route::middleware(['auth:api','scopes:reservation,customers'])->group(function(){
    Route::get('/customer',[AdminAuthController::class,'AuthenticatedCustomer']);
    Route::post('/get/customer/reservations', [CustomersController::class, 'getCustomerAllReservations']);
    Route::post('/customer/logout', [CustomersController::class, 'apiCustomerLogout']);
    Route::post('/cancel/reservation/status', [ReservationsController::class, 'cancelReservationStatus']);
    Route::put('/customer/update/{id}/{customer_type}', [CustomersController::class, 'update']);

});

Route::post('/customer/update/password', [CustomersController::class, 'updatePassword']);
Route::post('/customer/authentication', [CustomersController::class, 'customerEmailAuthentication'])->name('api-customer-authenticate');
Route::group(['prefix' => 'v2'],function(){
    Route::post('/verify/reservation-time-limit', [ServicesController::class, 'verifyReservationTimeLimit']);
    Route::post('/get/reservation/vehicle-fares', [ServicesController::class, 'getReservationVehicleFares']);
    Route::post('/verify/coupon', [CouponsController::class, 'validateCoupon']);
    Route::post('/get/verify-direct-account', [DirectAccountsController::class, 'verifyDirectAccounts']);
    Route::post('/save/reservation', [ReservationsController::class, 'saveReservation']);
    Route::post('/get/reservation/vehicle-fare-by-ride', [ServicesController::class, 'calculatePricingV2']);
});
Route::post('/fare-quotes/get/distance', [FareQuotesController::class, 'getDistance']);
Route::post('/schedule/calculate-fare',[ScheduleServicesController::class,'calculateFare']);
Route::post('/search/schedule/services',[ScheduleServicesController::class,'getSearchedScheduleServices']);
Route::post('/customer/find/reservation', [ReservationsController::class, 'findReservation']);
Route::put('/customer/check/email', [CustomersController::class, 'checkCustomerEmail']);
Route::post('customer/store', [CustomersController::class, 'store']);
