<?php

use Carbon\Carbon;
use App\Models\Module;
use GuzzleHttp\Client;
use App\Models\Admin\City;
use App\Models\Admin\Role;
use App\Models\Admin\Site;
use App\Models\Admin\User;
use App\Models\Admin\State;
use App\Models\Admin\Coupon;
use App\Models\Admin\Driver;
use App\Models\Admin\Airline;
use App\Models\Admin\Airport;
use App\Models\Admin\Country;
use App\Models\Admin\Vehicle;
use App\Models\Admin\ZipCode;
use App\Models\Admin\Customer;
use App\Models\Admin\UserGroup;
use App\Models\Admin\ActivityLog;
use App\Models\Admin\Reservation;
use App\Models\Admin\GuestCustomer;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\URL;
use App\Models\Admin\EmailTemplates;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;
use App\Mail\ReservationConfirmation;
use Google\Service\Monitoring\Custom;
use PHPUnit\Framework\Constraint\Count;
// use Stevebauman\Location\Facades\Location;

function AuthUserWithCompanyModules()
{
    // return User::with(['companies' => function ($q) {
    //     $q->where('company_id', session()->get('selectedCompanyId'))->with('modules', function ($q) {
    //         $q->where('user_company_module.user_id',  Auth::id())->orderBy('id');
    //     });
    // }])->where('users.id', Auth::id())->first();
    return User::with(['companies' => function ($q) {
        $q->where('company_id', session()->get('selectedCompanyId'))->with('modules', function ($q) {
            $q->where('user_company_module.user_id',  Auth::id())->orderBy('id');
        });
    }])->where('users.id', Auth::id())->first();
}

function getModulesWithChildModules()
{

    return Module::all();
}
function getUserPermissionModules()
{
    $user = Auth::user();
    $userPermission = UserGroup::where('id', $user->role_id)->select('assigned_modules')->get();

    // Assuming $userPermission is an array of module IDs
    $moduleIds = $userPermission[0]['assigned_modules']; // Access the first item in the result array

    // Retrieve modules based on the module IDs
    $modules = Module::whereIn('id', $moduleIds)->where('is_active',1)->get();

    return $modules;
}


function getAllCountries()
{
    return Country::all();
}

function getAllActiveCountries()
{
    return Country::where('is_active', 1)
    ->orderBy('name', 'asc')
    ->get();
}

function getAllStates()
{
    return State::all();
}

function getAllRoles()
{
    return Role::select('id','name')->get();
}

function getAdminUsers()
{
    return User::select('id','email','is_active')->with(['companies'])->where('parent_id', Auth::id())->get();
}

function getAllModules()
{
    return Module::select('id','name','parent_id')->get();
}

function getAllUsers()
{
    return User::select('id','email')->get();
}

// Dashboard Counts
function getAllDriversCount()
{
    return Driver::count();
}

function getAllAirportsCount()
{
    return Airport::count();
}

function getAllCountriesCount()
{
    return Country::count();
}

function getAllCitiesCount()
{
    return City::count();
}

function siteVerification($token)
{

    $sites_token = Site::where('token', $token)->first();

    return $sites_token ? true : false;

}

// function getTimeZone(){

//     $userIp=request()->ip();
//     if($userIp == '127.0.0.1'){
//     $timezone = Location::get('68.178.207.37')->timezone;
//     return $timezone;
//     }
//     else
//     {
//     $timezone = Location::get($userIp)->timezone;
//     return $timezone;
//     }
// }

function emailFlightTime($driverId,$customerId,$customerType,$previousReservation, $updatedReservation){

        $company_name = Site::whereId($previousReservation['site_id'])->pluck('site_name')->first();

        if($customerType == 'Registered' || $customerType == 'registered') {
            $customer=Customer::where('id',$customerId)
                ->select('email','first_name','last_name','phone_number','mobile_number')
                ->first();
            }
        else if($customerType == 'Guest' || $customerType == 'guest') {
                $customer=GuestCustomer::where('id',$customerId)
                ->select('email','first_name','last_name','phone_number','mobile_number')
                ->first();
            }
            $previousPickupDate = Carbon::parse($previousReservation['pick_up_date']);
            $previousPickupTime = Carbon::parse($previousReservation['pick_up_time']);

            $formattedPreviousPickup = $previousPickupTime->format('h:i A') . ' on ' . $previousPickupDate->format('d-M-Y');

            $updatePickupDate = Carbon::parse($updatedReservation['pick_up_date']);
            $updatedPickupTime = Carbon::parse($updatedReservation['pick_up_time']);

            $formattedUpdatedPickup = $updatedPickupTime->format('h:i A') . ' on ' . $updatePickupDate->format('d-M-Y');
            // dd($formattedPreviousPickup);
        $customer_data = [
            'reservation_number' => $previousReservation['id'],
            'previous_pickup' => $formattedPreviousPickup,
            'updated_pickup' => $formattedUpdatedPickup,
            'company_name' => $company_name,
        ];
        // dd($customer_data);
        $customer_template = EmailTemplates::where('service_type_id', 0)
            ->where('email_receiver_type', 'customer_edit_flight_time')
            ->pluck('template')
            ->first();

        foreach ($customer_data as $key => $value) {
            $customer_template = str_replace("{{ $key }}", $value, $customer_template);
        }

        $customer_message = $customer_template;
        // dd($customer_message);

        $customer_name = $customer->first_name . ' '. $customer->last_name;

        $driver_template = EmailTemplates::where('service_type_id', 0)
            ->where('email_receiver_type', 'driver_edit_flight_time')
            ->pluck('template')
            ->first();

            $driver_data = [
                'customer_name' => $customer_name,
                'phone_number' => $customer->phone_number,
                'mobile_number' => $customer->mobile_number,
                'previous_pickup' => $formattedPreviousPickup,
                'updated_pickup' => $formattedUpdatedPickup,
                'company_name' => $company_name,
                'reservation_number' => $previousReservation['id'],
            ];

        foreach ($driver_data as $key => $value) {
           $driver_template = str_replace("{{ $key }}", $value, $driver_template);
        }
        $driver_message = $driver_template;

        if ($driverId !== null) {
            $driverEmail = Driver::whereId($driverId)->where('is_active', 1)->pluck('email')->first();
            $emailDriverSent = sendReservationConfirmation($driverEmail, $driver_message, 'Change Pick Up Date Or Time !');

            logEmailActivity($driver_message,  $previousReservation, 'Driver Sent Email (Change Pick Up Date Or Time)', $emailDriverSent);
        }

        $emailCustomerSent = sendReservationConfirmation($customer->email, $customer_message, 'Change Pick Up Date Or Time !');

        logEmailActivity($customer_message, $previousReservation, 'Customer Sent Email (Change Pick Up Date Or Time)', $emailCustomerSent);

        return response()->json(['message' => 'Edit Flight Date Or Time Successfully'], 201);
}
function emailFlightInfo($driverId,$customerId,$customerType,$previousReservation, $updatedReservation){


        $company_name = Site::whereId($previousReservation['site_id'])->pluck('site_name')->first();

        if($customerType == 'Registered' || $customerType == 'registered') {
            $customer=Customer::where('id',$customerId)
                ->select('email','first_name','last_name','phone_number','mobile_number')
                ->first();
            }
        else if($customerType == 'Guest' || $customerType == 'guest') {
                $customer=GuestCustomer::where('id',$customerId)
                ->select('email','first_name','last_name','phone_number','mobile_number')
                ->first();
            }

        $customer_data = [
            'reservation_number' => $previousReservation['id'],
            'previous_airline' => $previousReservation['selected_airline'],
            'updated_airline' => $updatedReservation['selected_airline'],
            'previous_flight_number' => $previousReservation['flight_number'],
            'updated_flight_number' => $updatedReservation['flight_number'],
            'previous_flight_destination' => $previousReservation['selected_flight_destination'],
            'updated_flight_destination' => $updatedReservation['selected_flight_destination'],
            'company_name' => $company_name,
        ];

        $customer_template = EmailTemplates::where('service_type_id', 0)
            ->where('email_receiver_type', 'customer_edit_flight_info')
            ->pluck('template')
            ->first();

        foreach ($customer_data as $key => $value) {
            $customer_template = str_replace("{{ $key }}", $value, $customer_template);
        }

        $customer_message = $customer_template;
        // dd($customer_message);

        $customer_name = $customer->first_name . ' '. $customer->last_name;

        $driver_template = EmailTemplates::where('service_type_id', 0)
            ->where('email_receiver_type', 'driver_edit_flight_info')
            ->pluck('template')
            ->first();

            $driver_data = [
                'customer_name' => $customer_name,
                'phone_number' => $customer->phone_number,
                'mobile_number' => $customer->mobile_number,
                'reservation_number' => $previousReservation['id'],
                'previous_airline' => $previousReservation['selected_airline'],
                'updated_airline' => $updatedReservation['selected_airline'],
                'previous_flight_number' => $previousReservation['flight_number'],
                'updated_flight_number' => $updatedReservation['flight_number'],
                'previous_flight_destination' => $previousReservation['selected_flight_destination'],
                'updated_flight_destination' => $updatedReservation['selected_flight_destination'],
                'company_name' => $company_name,
            ];

        foreach ($driver_data as $key => $value) {
           $driver_template = str_replace("{{ $key }}", $value, $driver_template);
        }
        $driver_message = $driver_template;

        if ($driverId !== null) {
            $driverEmail = Driver::whereId($driverId)->where('is_active', 1)->pluck('email')->first();
            $emailDriverSent = sendReservationConfirmation($driverEmail, $driver_message, 'Change Flight Information !');

            logEmailActivity($driver_message,  $previousReservation, 'Driver Sent Email (Change Flight Information)', $emailDriverSent);
        }

        $emailCustomerSent = sendReservationConfirmation($customer->email, $customer_message, 'Change Flight Information !');

        logEmailActivity($customer_message, $previousReservation, 'Customer Sent Email (Change Flight Information)', $emailCustomerSent);



        return response()->json(['message' => 'Edit Flight Information Successfully'], 201);
}


function emailDriver($driverId, $reservation_details){

    // dd($reservation_details['customer']['email']);

    $driverEmail = Driver::whereId($driverId)->where('is_active', 1)->pluck('email')->first();
    $customerEmail = $reservation_details['customer']['email'];

    $driverDetails = Driver::select('id', 'first_name', 'last_name', 'cell_phone')->whereId($driverId)->where('is_active', 1)->first();

    $template = EmailTemplates::where('service_type_id', $reservation_details['service_type_id'])
        ->where('airport_ride', $reservation_details['airport_ride'])
        ->where('email_receiver_type', 'driver')
        ->pluck('template')
        ->first();

        if($reservation_details['service_type_id'] == 1){
            $template = EmailTemplates::where('service_type_id', $reservation_details['service_type_id'])
                ->where('email_receiver_type', 'driver')
                ->where('airport_ride', $reservation_details['airport_ride'])
                ->pluck('template')
                ->first();
        }
        else if($reservation_details['service_type_id'] == 2 || $reservation_details['service_type_id'] == 3) {
            $template = EmailTemplates::where('service_type_id', $reservation_details['service_type_id'])
                ->where('email_receiver_type', 'driver')
                ->pluck('template')
                ->first();
        }
        else if ($reservation_details['service_type_id'] == 4 && $reservation_details['airport_ride'] !== null) {
            $template = EmailTemplates::where('service_type_id', $reservation_details['service_type_id'])
            ->where('email_receiver_type', 'driver')
            ->where('airport_ride', $reservation_details['airport_ride'])
            ->pluck('template')
            ->first();
        }
        else if ($reservation_details['service_type_id'] == 4 && $reservation_details['airport_ride'] === null) {
            $template = EmailTemplates::where('service_type_id', $reservation_details['service_type_id'])
            ->where('email_receiver_type', 'driver')
            ->where('airport_ride', null)
            ->pluck('template')
            ->first();
        }

    // dd($template);

    $company_name = Site::whereId($reservation_details['site_id'])->pluck('site_name')->first();
    $vehicle_type = Vehicle::whereId($reservation_details['vehicle_type_id'])->pluck('vehicles_type')->first();
    $customer_name = $reservation_details['customer']['first_name'] . ' '. $reservation_details['customer']['last_name'];

    if ($reservation_details['service_type_id'] == '1') {
        $data = [
            'reservation_number' => $reservation_details['id'],
            'drop_off_location' => $reservation_details['drop_off_location']['address'],
            'pick_up_time' => $reservation_details['pick_up_time'],
            'selected_airline' => $reservation_details['selected_airline'],
            'flight_number' => $reservation_details['flight_number'],
            'selected_flight_destination' => $reservation_details['selected_flight_destination'],
            'pick_up_location' => $reservation_details['pick_up_location']['address'],
            'pick_up_date' => $reservation_details['pick_up_date'],
            'vehicle_type' => $vehicle_type,
            'customer_name' => $customer_name,
            'phone_number' => $reservation_details['customer']['phone_number'],
            'mobile_number' => $reservation_details['customer']['mobile_number'],
            'travellers' => $reservation_details['travellers'],
            'luggage_count' => $reservation_details['luggage'],
            'price' => $reservation_details['price'],
            'company_name' => $company_name,
        ];
    }
    else if ($reservation_details['service_type_id'] == 2 || $reservation_details['service_type_id'] == 3) {
        $data = [
            'reservation_number' => $reservation_details['id'],
            'drop_off_location' => $reservation_details['drop_off_location']['address'],
            'pick_up_time' => $reservation_details['pick_up_time'],
            'pick_up_location' => $reservation_details['pick_up_location']['address'],
            'pick_up_date' => $reservation_details['pick_up_date'],
            'vehicle_type' => $vehicle_type,
            'customer_name' => $customer_name,
            'phone_number' => $reservation_details['customer']['phone_number'],
            'mobile_number' => $reservation_details['customer']['mobile_number'],
            'travellers' => $reservation_details['travellers'],
            'luggage_count' => $reservation_details['luggage'],
            'price' => $reservation_details['price'],
            'company_name' => $company_name,
        ];
    }
    else if ($reservation_details['service_type_id'] == 4 && $reservation_details['airport_ride'] !== null) {
        $data = [
            'reservation_number' => $reservation_details['id'],
            'drop_off_location' => $reservation_details['drop_off_location']['address'],
            'pick_up_time' => $reservation_details['pick_up_time'],
            'selected_airline' => $reservation_details['selected_airline'],
            'flight_number' => $reservation_details['flight_number'],
            'selected_flight_destination' => $reservation_details['selected_flight_destination'],
            'pick_up_location' => $reservation_details['pick_up_location']['address'],
            'pick_up_date' => $reservation_details['pick_up_date'],
            'vehicle_type' => $vehicle_type,
            'customer_name' => $customer_name,
            'phone_number' => $reservation_details['customer']['phone_number'],
            'mobile_number' => $reservation_details['customer']['mobile_number'],
            'travellers' => $reservation_details['travellers'],
            'luggage_count' => $reservation_details['luggage'],
            'price' => $reservation_details['price'],
            'company_name' => $company_name,
        ];
    }
    else if ($reservation_details['service_type_id'] == 4 && $reservation_details['airport_ride'] == null) {
        $data = [
            'reservation_number' => $reservation_details['id'],
            'drop_off_location' => $reservation_details['drop_off_location']['address'],
            'pick_up_time' => $reservation_details['pick_up_time'],
            'pick_up_location' => $reservation_details['pick_up_location']['address'],
            'pick_up_date' => $reservation_details['pick_up_date'],
            'vehicle_type' => $vehicle_type,
            'customer_name' => $customer_name,
            'phone_number' => $reservation_details['customer']['phone_number'],
            'mobile_number' => $reservation_details['customer']['mobile_number'],
            'travellers' => $reservation_details['travellers'],
            'luggage_count' => $reservation_details['luggage'],
            'price' => $reservation_details['price'],
            'company_name' => $company_name,
        ];
    }

    $customer_data = [
        'reservation_number' => $reservation_details['id'],
        'driver_name' => $driverDetails['first_name'] . ' ' . $driverDetails['last_name'],
        'driver_contact' => $driverDetails['cell_phone'],
        'company_name' => $company_name,
    ];

    $customer_template = EmailTemplates::where('service_type_id', 0)
        ->where('email_receiver_type', 'customer')
        ->pluck('template')
        ->first();

    foreach ($data as $key => $value) {
        $template = str_replace("{{ $key }}", $value, $template);
    }

    foreach ($customer_data as $key => $value) {
        $customer_template = str_replace("{{ $key }}", $value, $customer_template);
    }

    $message = $template;

    $customer_message = $customer_template;


    // $subject = 'Driver Assigned !';

    // sendReservationConfirmation($driverEmail, $message, 'Customer Assigned !');

    // sendReservationConfirmation($customerEmail, $customer_message, 'Driver Assigned !');


    $emailDriverSent = sendReservationConfirmation($driverEmail, $message, 'Customer Assigned !');
    logEmailActivity($message,  $reservation_details, 'Driver Sent Email (Customer Assigned !)', $emailDriverSent);
    $emailCustomerSent = sendReservationConfirmation($customerEmail, $customer_message, 'Driver Assigned !');
    logEmailActivity($customer_message, $reservation_details, 'Customer Sent Email (Driver Assigned !)', $emailCustomerSent);

    return response()->json(['message' => 'Driver assigned successfully'], 201);

}

function logEmailActivity($message, $reservation, $activityDescription, $emailStatus) {
    // dd($message, $reservation, $activityDescription, $emailStatus);
    if($emailStatus){
        $currentRoute = URL::current();
        $ipAddress = request()->ip();
        $user=Auth::user();
        $customerId=$reservation['customer_id'];
        // dd($customerId);
        $containsDriver = strpos($currentRoute, 'driver') !== false && strpos($currentRoute, 'admin') === false;
        $containsCustomer = strpos($currentRoute, 'with-user') !== false;
        $roleId = determineRoleId($containsDriver, $containsCustomer, $user);
        $userId = $containsCustomer && $customerId !== null ? $customerId : ($user->id ?? null);
        // Remove newline characters from the message
        $message = str_replace(["\r", "\n"], '', $message);

        $jsonEncodedMessage = json_encode($message);
        // dd($userId,$roleId,$customerId,$reservation['id']);
        if (json_last_error() !== JSON_ERROR_NONE) {
            Log::error('JSON encoding error: ' . json_last_error_msg());
        } else {

            ActivityLog::create([
                'user_id' => $userId,
                'role_id' => $roleId,
                'ip_address' => $ipAddress,
                'customer_id' => $customerId,
                'item_id' => $reservation['id'],
                'table_name' => 'reservations',
                'activity' => 'email',
                'route' => $currentRoute,
                'activity_description' => $activityDescription,
                'activity_detail' => $jsonEncodedMessage,
            ]);
        }
    }

}

// Function to determine the role ID
function determineRoleId($containsDriver, $containsCustomer, $user) {
    if ($containsDriver) {
        return config('app.enums.DRIVER_ROLE_ID');
    } else if ($containsCustomer) {
        return null;
    } else {
        return $user ? $user->role_id : null;
    }
}
// function emailDriver($driverId, $reservation_details){

//     // dd($reservation_details['customer']['email']);

//     $driverEmail = Driver::whereId($driverId)->where('is_active', 1)->pluck('email')->first();
//     $customerEmail = $reservation_details['customer']['email'];

//     $driverDetails = Driver::select('id', 'first_name', 'last_name', 'cell_phone')->whereId($driverId)->where('is_active', 1)->first();

//     $template = EmailTemplates::where('service_type_id', $reservation_details['service_type_id'])
//         ->where('airport_ride', $reservation_details['airport_ride'])
//         ->where('email_receiver_type', 'driver')
//         ->pluck('template')
//         ->first();

//         if($reservation_details['service_type_id'] == 1){
//             $template = EmailTemplates::where('service_type_id', $reservation_details['service_type_id'])
//                 ->where('email_receiver_type', 'driver')
//                 ->where('airport_ride', $reservation_details['airport_ride'])
//                 ->pluck('template')
//                 ->first();
//         }
//         else if($reservation_details['service_type_id'] == 2 || $reservation_details['service_type_id'] == 3) {
//             $template = EmailTemplates::where('service_type_id', $reservation_details['service_type_id'])
//                 ->where('email_receiver_type', 'driver')
//                 ->pluck('template')
//                 ->first();
//         }
//         else if ($reservation_details['service_type_id'] == 4 && $reservation_details['airport_ride'] !== null) {
//             $template = EmailTemplates::where('service_type_id', $reservation_details['service_type_id'])
//             ->where('email_receiver_type', 'driver')
//             ->where('airport_ride', $reservation_details['airport_ride'])
//             ->pluck('template')
//             ->first();
//         }
//         else if ($reservation_details['service_type_id'] == 4 && $reservation_details['airport_ride'] === null) {
//             $template = EmailTemplates::where('service_type_id', $reservation_details['service_type_id'])
//             ->where('email_receiver_type', 'driver')
//             ->where('airport_ride', null)
//             ->pluck('template')
//             ->first();
//         }

//     // dd($template);

//     $company_name = Site::whereId($reservation_details['site_id'])->pluck('site_name')->first();
//     $vehicle_type = Vehicle::whereId($reservation_details['vehicle_type_id'])->pluck('vehicles_type')->first();
//     $customer_name = $reservation_details['customer']['first_name'] . ' '. $reservation_details['customer']['last_name'];

//     if ($reservation_details['service_type_id'] == '1') {
//         $data = [
//             'reservation_number' => $reservation_details['id'],
//             'drop_off_location' => $reservation_details['drop_off_location']['address'],
//             'pick_up_time' => $reservation_details['pick_up_time'],
//             'selected_airline' => $reservation_details['selected_airline'],
//             'flight_number' => $reservation_details['flight_number'],
//             'selected_flight_destination' => $reservation_details['selected_flight_destination'],
//             'pick_up_location' => $reservation_details['pick_up_location']['address'],
//             'pick_up_date' => $reservation_details['pick_up_date'],
//             'vehicle_type' => $vehicle_type,
//             'customer_name' => $customer_name,
//             'phone_number' => $reservation_details['customer']['phone_number'],
//             'mobile_number' => $reservation_details['customer']['mobile_number'],
//             'travellers' => $reservation_details['travellers'],
//             'luggage_count' => $reservation_details['luggage'],
//             'price' => $reservation_details['price'],
//             'company_name' => $company_name,
//         ];
//     }
//     else if ($reservation_details['service_type_id'] == 2 || $reservation_details['service_type_id'] == 3) {
//         $data = [
//             'reservation_number' => $reservation_details['id'],
//             'drop_off_location' => $reservation_details['drop_off_location']['address'],
//             'pick_up_time' => $reservation_details['pick_up_time'],
//             'pick_up_location' => $reservation_details['pick_up_location']['address'],
//             'pick_up_date' => $reservation_details['pick_up_date'],
//             'vehicle_type' => $vehicle_type,
//             'customer_name' => $customer_name,
//             'phone_number' => $reservation_details['customer']['phone_number'],
//             'mobile_number' => $reservation_details['customer']['mobile_number'],
//             'travellers' => $reservation_details['travellers'],
//             'luggage_count' => $reservation_details['luggage'],
//             'price' => $reservation_details['price'],
//             'company_name' => $company_name,
//         ];
//     }
//     else if ($reservation_details['service_type_id'] == 4 && $reservation_details['airport_ride'] !== null) {
//         $data = [
//             'reservation_number' => $reservation_details['id'],
//             'drop_off_location' => $reservation_details['drop_off_location']['address'],
//             'pick_up_time' => $reservation_details['pick_up_time'],
//             'selected_airline' => $reservation_details['selected_airline'],
//             'flight_number' => $reservation_details['flight_number'],
//             'selected_flight_destination' => $reservation_details['selected_flight_destination'],
//             'pick_up_location' => $reservation_details['pick_up_location']['address'],
//             'pick_up_date' => $reservation_details['pick_up_date'],
//             'vehicle_type' => $vehicle_type,
//             'customer_name' => $customer_name,
//             'phone_number' => $reservation_details['customer']['phone_number'],
//             'mobile_number' => $reservation_details['customer']['mobile_number'],
//             'travellers' => $reservation_details['travellers'],
//             'luggage_count' => $reservation_details['luggage'],
//             'price' => $reservation_details['price'],
//             'company_name' => $company_name,
//         ];
//     }
//     else if ($reservation_details['service_type_id'] == 4 && $reservation_details['airport_ride'] == null) {
//         $data = [
//             'reservation_number' => $reservation_details['id'],
//             'drop_off_location' => $reservation_details['drop_off_location']['address'],
//             'pick_up_time' => $reservation_details['pick_up_time'],
//             'pick_up_location' => $reservation_details['pick_up_location']['address'],
//             'pick_up_date' => $reservation_details['pick_up_date'],
//             'vehicle_type' => $vehicle_type,
//             'customer_name' => $customer_name,
//             'phone_number' => $reservation_details['customer']['phone_number'],
//             'mobile_number' => $reservation_details['customer']['mobile_number'],
//             'travellers' => $reservation_details['travellers'],
//             'luggage_count' => $reservation_details['luggage'],
//             'price' => $reservation_details['price'],
//             'company_name' => $company_name,
//         ];
//     }

//     $customer_data = [
//         'reservation_number' => $reservation_details['id'],
//         'driver_name' => $driverDetails['first_name'] . ' ' . $driverDetails['last_name'],
//         'driver_contact' => $driverDetails['cell_phone'],
//         'company_name' => $company_name,
//     ];

//     $customer_template = EmailTemplates::where('service_type_id', 0)
//         ->where('email_receiver_type', 'customer')
//         ->pluck('template')
//         ->first();

//     foreach ($data as $key => $value) {
//         $template = str_replace("{{ $key }}", $value, $template);
//     }

//     foreach ($customer_data as $key => $value) {
//         $customer_template = str_replace("{{ $key }}", $value, $customer_template);
//     }

//     $message = $template;

//     $customer_message = $customer_template;

//     $customer_template_id = EmailTemplates::where('service_type_id', 0)
//         ->where('email_receiver_type', 'customer')
//         ->pluck('id')
//         ->first();
//     $driver_template_id = EmailTemplates::where('service_type_id', $reservation_details['service_type_id'])
//     ->where('airport_ride', $reservation_details['airport_ride'])
//     ->where('email_receiver_type', 'driver')
//     ->pluck('id')
//     ->first();

//     if($reservation_details['service_type_id'] == 1){
//         $driver_template_id = EmailTemplates::where('service_type_id', $reservation_details['service_type_id'])
//             ->where('email_receiver_type', 'driver')
//             ->where('airport_ride', $reservation_details['airport_ride'])
//             ->pluck('id')
//             ->first();
//     }
//     else if($reservation_details['service_type_id'] == 2 || $reservation_details['service_type_id'] == 3) {
//         $driver_template_id = EmailTemplates::where('service_type_id', $reservation_details['service_type_id'])
//             ->where('email_receiver_type', 'driver')
//             ->pluck('id')
//             ->first();
//     }
//     else if ($reservation_details['service_type_id'] == 4 && $reservation_details['airport_ride'] !== null) {
//         $driver_template_id = EmailTemplates::where('service_type_id', $reservation_details['service_type_id'])
//         ->where('email_receiver_type', 'driver')
//         ->where('airport_ride', $reservation_details['airport_ride'])
//         ->pluck('id')
//         ->first();
//     }
//     else if ($reservation_details['service_type_id'] == 4 && $reservation_details['airport_ride'] === null) {
//         $driver_template_id = EmailTemplates::where('service_type_id', $reservation_details['service_type_id'])
//         ->where('email_receiver_type', 'driver')
//         ->where('airport_ride', null)
//         ->pluck('id')
//         ->first();
//     }
//     // dd($driver_template_id,$customer_template_id);

//     // $subject = 'Driver Assigned !';

//     // sendReservationConfirmation($driverEmail, $message, 'Customer Assigned !');

//     // sendReservationConfirmation($customerEmail, $customer_message, 'Driver Assigned !');
//     // Check if the email is sent successfully
//     try {
//         $driverEmailSent = sendReservationConfirmation($driverEmail, $message, 'Customer Assigned !');
//         if ($driverEmailSent) {
//             $reservation = Reservation::find($reservation_details['id']);
//             $reservation->is_email_sent = 1; // 1 indicates that the email has been sent successfully to the driver
//             $reservation->email_template_id = $driver_template_id; // Replace with the actual email template ID
//             $reservation->save();
//             return response()->json(['message' => 'Customer assigned successfully'], 201);
//         }
//         else {
//             return response()->json(['message' => 'Failed to send email'], 500);
//         }
//     } catch (\Exception $e) {
//         // Log the exception or handle it as per your application's error handling strategy
//         return response()->json(['message' => 'An error occurred while sending the email'], 500);
//     }

//     // Check if the email is sent successfully for the customer
//     try {
//         $customerEmailSent = sendReservationConfirmation($customerEmail, $customer_message, 'Driver Assigned !');
//         if ($customerEmailSent) {
//             $reservation = Reservation::find($reservation_details['id']);
//             $reservation->is_email_sent = 1; // 1 indicates that the email has been sent successfully to the customer
//             $reservation->email_template_id = $customer_template_id; // Replace with the actual email template ID
//             $reservation->save();
//             return response()->json(['message' => 'Driver assigned successfully'], 201);
//         }
//         else {
//             return response()->json(['message' => 'Failed to send email'], 500);
//         }
//     } catch (\Exception $e) {
//         // Log the exception or handle it as per your application's error handling strategy
//         return response()->json(['message' => 'An error occurred while sending the email'], 500);
//     }
//     // try {
//     //     $emailSent = sendReservationConfirmation($driverEmail, $message, 'Customer Assigned !');
//     //     $customerEmailSent = sendReservationConfirmation($customerEmail, $customer_message, 'Driver Assigned !');

//     //     if ($emailSent ) {
//     //         $reservation = Reservation::find($reservation_details['id']);
//     //         $reservation->email_sent_status = 1; // 1 indicates that the email has been sent successfully
//     //         $reservation->email_template_id = $emailTemplateId; // Replace with the actual email template ID
//     //         $reservation->save();

//     //         return response()->json(['message' => 'Driver assigned successfully'], 201);
//     //     }
//     //     else if( $customerEmailSent){
//     //         $reservation = Reservation::find($reservation_details['id']);
//     //         $reservation->email_sent_status = 1; // 1 indicates that the email has been sent successfully
//     //         $reservation->email_template_id = $emailTemplateId; // Replace with the actual email template ID
//     //         $reservation->save();
//     //     }
//     //     else {
//     //         return response()->json(['message' => 'Failed to send email'], 500);
//     //     }
//     // } catch (\Exception $e) {
//     //     // Log the exception or handle it as per your application's error handling strategy
//     //     return response()->json(['message' => 'An error occurred while sending the email'], 500);
//     // }

//     // return response()->json(['message' => 'Email Sent successfully'], 201);

// }

// function sendReservationConfirmation($email, $message, $subject){
//     try {
//         Mail::to($email)->send(new ReservationConfirmation($message, $subject));
//         return true; // Email sent successfully
//     } catch (\Exception $exception) {
//         return false; // Email failed to send
//     }

// }
// ************************************************** Dashboard Methods *********************************************


function getAllUsersCount()
{
    return User::count();
}

function getAllModulesCount()
{
    return Module::count();
}


function getAllModulesWithChildrenModule()
{
    return Module::with('childrenModules')->get();
}

function storeAllStatesOfSpecificCountry($country_name, $country_id){

    $client = new Client();
    $response = $client->request('POST', 'https://countriesnow.space/api/v0.1/countries/states', [
        'form_params' => [
            'country' => $country_name,
        ]
    ]);

    $response = $response->getBody()->getContents();
    $response =  json_decode($response);

    $count = count($response->data->states);
    for ($n = 0; $n < $count; $n++) {

        $state_data = new State();
        $state_data->country_id = $country_id;
        $state_data->name = $response->data->states[$n]->name;
        $state_data->save();
    }
}

function storeAllCitiesOfSpecificCountry($country_name, $country_id){

    $states = State::where('country_id', $country_id)->get();

        foreach ($states as $state) {

            set_time_limit(300);

            $client = new Client();
            $response = $client->request('POST', 'https://countriesnow.space/api/v0.1/countries/state/cities', [
                'form_params' => [
                    'country' => $country_name,
                    "state" => $state->name
                ]
            ]);

            $response = $response->getBody()->getContents();
            $response =  json_decode($response);

            $count = count($response->data);

            for ($n=0; $n < $count; $n++) {

                $city_data = new City();
                $city_data->state_id = $state->id;
                $city_data->name = $response->data[$n];

                $city_data->save();
            }
        }
}

// Get All Countries from API and store in to database
function getCountriesFromApi(){

    $response = Http::get('https://restcountries.com/v3.1/all');
    $countriesArr = array();

    foreach (json_decode($response) as $country) {
        $countriesArr[] = [
            'name' => $country->name->common,
            'iso_2' => $country->cca2,
            'iso_3' => $country->cca3,
            'flag' => $country->flags->png,
        ];
    }

    Country::insert($countriesArr);
}
// Get All states from API and store in to database
function getStatesFromApi(){

    $response = Http::post('https://countriesnow.space/api/v0.1/countries/states', [
         'country' =>  'United States'
    ]);
    $apiData =  $response->getBody()->getContents();
    $statesArr = array();

    foreach (json_decode($apiData)->data->states as $state) {
        $countriesArr[] = [
            'country_id' => 20,
            'name' => $state->name,
            'state_code' => $state->state_code,
        ];
    }

    State::insert($countriesArr);
}
// Get All Cities By Country and State from API and store in to database
function getCitiesFromApi(){

    $states = State::select('id', 'name')->get();

    $citiesArr = array();
    foreach($states as $state) {
            set_time_limit(300);
            $response = Http::post('https://countriesnow.space/api/v0.1/countries/state/cities', [
                'country' =>  'United States',
                'state' =>  $state->name
            ]);

            $apiData =  $response->getBody()->getContents();

            foreach (json_decode($apiData)->data as $city) {
            $citiesArr[] = [
                'name' => $city,
                'state_id' => $state->id,
            ];
        }
    }
    City::insert($citiesArr);
}

// Get All Zipcodes By City and State from API and store in to database
function getZipCodesFromApi(){
    $cities = City::select('id', 'name')->where('state_id', 34)->get();

    $zipCodesArr = array();

    foreach ($cities as $city) {
        set_time_limit(300);
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, false);

        $data = [
            "city" => $city->name,
            "state_name" => "Missouri",
            "country" => "us",
        ];

        curl_setopt($ch, CURLOPT_URL, "https://app.zipcodebase.com/api/v1/code/city?" . http_build_query($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "apikey: 6f716c00-4f8a-11ed-9e6f-f5c507b4cb89",
        ));

        $response = curl_exec($ch);
        curl_close($ch);

        $json = json_decode($response);

        foreach ($json->results as $zipCode) {
            $zipCodesArr[] = [
                'city_id' => $city->id,
                'zip_code' => $zipCode,
            ];
        }
    }

    ZipCode::insert($zipCodesArr);

}

function sendAuthEmail($to)
{
    // dd($to, $locale, $emailData['signature']);

    // Subject
    $subject = 'Test Mail';

    // Message
    $message = '
                <html>
                    <head>
                    <title>' . 'Test' . '</title>
                    </head>
                    <body>
                        <div>
                            <a>
                                <button>
                                    ' . 'Test Text' . '
                                </button>
                            </a>
                        </div>
                    </body>
                </html>
            ';

    // To send HTML mail, the Content-type header must be set
    $headers[] = 'MIME-Version: 1.0';
    $headers[] = 'Content-type: text/html; charset=iso-8859-1';

    // Mail it
    $mail = mail($to, $subject, $message);
}
