<?php

namespace App\Providers;
use App\Models\Admin\Driver;
use App\Models\Admin\Reservation;
use App\Observers\DriverObserver;
use App\Observers\VehicleObserver;
use App\Observers\ReservationObserver;
use Illuminate\Support\ServiceProvider;
use App\Models\Admin\VehicleMillageCondition;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Reservation::observe(ReservationObserver::class);
        Driver::observe(DriverObserver::class);
        VehicleMillageCondition::observe(VehicleObserver::class);
    }
}
