<?php

namespace App\Observers;

use App\Models\Admin\Driver;
use App\Models\Admin\ActivityLog;
use App\Models\Admin\VehiclePart;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;
use App\Models\Admin\VehicleMillageCondition;

class VehicleObserver
{
    /**
     * Handle the VehicleMillageCondition "created" event.
     *
     * @param  \App\Models\VehicleMillageCondition  $vehicleMillageCondition
     * @return void
     */
    public function created(VehicleMillageCondition $vehicleMillageCondition)
    {
        $description = '';
            foreach ($vehicleMillageCondition->getAttributes() as $attribute => $value) {
                if ($attribute !== 'created_at' && $attribute !== 'updated_at' && $attribute !== 'id' && $attribute !== 'vehicle_id'  && $value !== null) {
                    if ($attribute === 'driver_id') {
                        // Retrieve the driver's name from the driver table using the driver_id
                        $driver = Driver::find($value); // Assuming Driver is your model name
                        if ($driver) {
                            // $description .= 'Driver: ' . $driver->first_name .' '. $driver->last_name . '.<br>';
                            $description .= 'Driver: ' . " '<span style='color: green;'>{$driver->first_name} {$driver->last_name}</span>'.<br> ";
                        } else {
                            $description .= 'Driver ID: ' . $value . '.<br>';
                        }
                    } else if ($attribute === 'vehicle_condition') {
                        $vehicleCondition = json_decode($value, true); // Decode the JSON string

                        $vehiclePartNames = [];
                        foreach ($vehicleCondition as $partId => $condition) {
                            $vehiclePart = VehiclePart::find($partId); // Assuming VehiclePart is your model name
                            if ($vehiclePart) {
                                $vehiclePartNames[] = $vehiclePart->part_name . ': ' .  '<span style="color: green;">' . $condition . '</span>';
                            }
                        }
                        $description .= implode(' | ', $vehiclePartNames) . '.<br>';
                    }  else {
                        $description .= ucwords(str_replace('_', ' ', $attribute)) . " '<span style='color: green;'>{$value}</span>'.<br> ";
                    }
                }
            }

            $currentRoute = URL::current();
            $ipAddress = Request::ip();
            $user=Auth::user();
            $containsDriver = strpos($currentRoute, 'driver') !== false && strpos($currentRoute, 'admin') === false;
            $containsCustomer = strpos($currentRoute, 'with-user') !== false;

            // Set role_id based on conditions
            if ($containsDriver) {
                $roleId = config('app.enums.DRIVER_ROLE_ID');
            } elseif ($containsCustomer) {
                $roleId = null;
            } else {
                // Default to the user's role_id if neither condition is met
                $roleId = $user->role_id;
            }


            ActivityLog::create([
                'user_id' => $user->id,
                'role_id' => $roleId,
                'ip_address' => $ipAddress,
                'item_id' => $vehicleMillageCondition->id,
                'vehicle_id' => $vehicleMillageCondition->vehicle_id,
                'table_name' => 'vehicle_mile_condition',
                'activity' => 'created',
                'activity_detail' => json_encode($vehicleMillageCondition),
                'route' => $currentRoute,
                'activity_description' => $description,
            ]);
    }

    /**
     * Handle the VehicleMillageCondition "updated" event.
     *
     * @param  \App\Models\VehicleMillageCondition  $vehicleMillageCondition
     * @return void
     */
    public function updated(VehicleMillageCondition $vehicleMillageCondition)
    {
        $changes = $vehicleMillageCondition->getDirty(); // Get the updated attributes
        $before = $vehicleMillageCondition->getOriginal(); // Get the original data
        // Create an array to store the changes
        $jsonChanges = [];

        // Loop through the changed attributes
        foreach ($changes as $attribute => $newValue) {
            $jsonChanges[$attribute] = [
                'before' => $before[$attribute],
                'after' => $newValue,
            ];
        }

        $description = '';
        foreach ($changes as $attribute => $newValue) {
            if ($attribute !== 'updated_at' && $attribute !== 'vehicle_condition') {
                    if ($before[$attribute] !== null) {
                        $description .=  ucwords(str_replace('_', ' ', $attribute)) . " '<span style='color: red;'>{$before[$attribute]}</span> ' to '<span style='color: green;'>{$newValue}</span>'.<br> ";
                    } else {
                        $description .=  ucwords(str_replace('_', ' ', $attribute)) . " '<span style='color: green;'>{$newValue}</span>'.<br> ";
                    }
            }
        }

        // Encode the changes as JSON
        $jsonChanges = json_encode($jsonChanges);

        // Check if JSON encoding failed
        if (json_last_error() !== JSON_ERROR_NONE) {
            Log::error('JSON encoding error: ' . json_last_error_msg());
        } else {
            // Get the current URL
            $currentRoute = URL::current();
            $ipAddress = Request::ip();
            $user=Auth::user();
            $containsDriver = strpos($currentRoute, 'driver') !== false && strpos($currentRoute, 'admin') === false;
            $containsCustomer = strpos($currentRoute, 'with-user') !== false;

            // Set role_id based on conditions
            if ($containsDriver) {
                $roleId = config('app.enums.DRIVER_ROLE_ID');
            } elseif ($containsCustomer) {
                $roleId = null;
            } else {
                // Default to the user's role_id if neither condition is met
                $roleId = $user->role_id;
            }


            ActivityLog::create([
                'user_id' => $user->id,
                'role_id' => $roleId,
                'ip_address' => $ipAddress,
                'item_id' => $vehicleMillageCondition->id,
                'vehicle_id' => $vehicleMillageCondition->vehicle_id,
                'table_name' => 'vehicle_mile_condition',
                'activity' => 'updated',
                'activity_detail' => $jsonChanges,
                'route' => $currentRoute,
                'activity_description' => $description,
            ]);

            // Log the changes
            // ActivityLog::create([
            //     'user_id' => $userId,
            //     'role_id' => $roleId,
            //     'item_id' => $vehicleMillageCondition->id,
            //     'vehicle_id' => $vehicleMillageCondition->vehicle_id,
            //     'ip_address' => $ipAddress,
            //     'table_name' => 'vehicle_mile_condition',
            //     'activity' => 'updated',
            //     'activity_detail' => $jsonChanges, // Store the original data
            //     'route' => $currentRoute,
            //     'activity_description' => $description,
            // ]);
        }
    }

    /**
     * Handle the VehicleMillageCondition "deleted" event.
     *
     * @param  \App\Models\VehicleMillageCondition  $vehicleMillageCondition
     * @return void
     */
    public function deleted(VehicleMillageCondition $vehicleMillageCondition)
    {
        //
    }

    /**
     * Handle the VehicleMillageCondition "restored" event.
     *
     * @param  \App\Models\VehicleMillageCondition  $vehicleMillageCondition
     * @return void
     */
    public function restored(VehicleMillageCondition $vehicleMillageCondition)
    {
        //
    }

    /**
     * Handle the VehicleMillageCondition "force deleted" event.
     *
     * @param  \App\Models\VehicleMillageCondition  $vehicleMillageCondition
     * @return void
     */
    public function forceDeleted(VehicleMillageCondition $vehicleMillageCondition)
    {
        //
    }
}
