<?php

namespace App\Observers;

use App\Models\Admin\Driver;
use App\Models\Admin\Customer;
use App\Models\Admin\Reservation;
use  App\Models\Admin\ActivityLog;
use App\Models\Admin\GuestCustomer;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;


class ReservationObserver
{
    /**
     * Handle the Reservation "created" event.
     *
     * @param  \App\Models\Reservation  $reservation
     * @return void
     */

    public function created(Reservation $reservation)
    {
        $description = 'Reservation created.';
        $currentRoute = URL::current();
        $customerId = $reservation->customer_id;
        $user=Auth::user();
        $ipAddress = Request::ip();
        $containsDriver = strpos($currentRoute, 'driver') !== false && strpos($currentRoute, 'admin') === false;
        $containsCustomer = strpos($currentRoute, 'with-user') !== false;
        //determineRoleId global function for role_id
        $roleId = determineRoleId($containsDriver, $containsCustomer, $user);
        $userId = $containsCustomer && $customerId !== null ? $customerId : ($user->id ?? null);

        ActivityLog::create([
            'user_id' => $userId,
            'customer_id' => $customerId,
            'role_id' => $roleId ? $roleId : null,
            'ip_address' => $ipAddress,
            'company_id' => $reservation->site_id,
            'item_id' => $reservation->id,
            'table_name' => 'reservations',
            'activity' => 'created',
            'route' => $currentRoute,
            'activity_description' => $description,
        ]);
        Log::info('Reservation Created');
    }

    /**
     * Handle the Reservation "updated" event.
     *
     * @param  \App\Models\Reservation  $reservation
     * @return void
     */
    public function updated(Reservation $reservation)
    {
        
        $changes = $reservation->getDirty(); // Get the updated attributes
        $before = $reservation->getOriginal(); // Get the original data
        // Create an array to store the changes
        $jsonChanges = [];

        // Loop through the changed attributes
        foreach ($changes as $attribute => $newValue) {
            $jsonChanges[$attribute] = [
                'before' => $before[$attribute],
                'after' => $newValue,
            ];
        }

        $description = '';
        
        foreach ($changes as $attribute => $newValue) {
            Log::info('[Attribute] ' . $attribute);
            if ($attribute !== 'updated_at' ) {
               
                if ($attribute === 'driver_id') {
                    $driver = Driver::find($newValue);
                    $driverName = $driver ? $driver->first_name . ' ' . $driver->last_name : 'Unknown Driver';

                    
                    $previousDriverId = $before[$attribute];
                    $previousDriver = Driver::find($previousDriverId);
                    $previousDriverName = $previousDriver ? $previousDriver->first_name . ' ' . $previousDriver->last_name : 'Unknown Driver';
                    
                    if ($previousDriver !== null) {
                        $description .= "Driver '<span style='color: red;'>{$previousDriverName}</span>' to '<span style='color: green;'>{$driverName}</span>'.<br>";
                    } else {
                        $description .= "Driver '<span style='color: green;'>{$driverName}</span>'.<br> ";
                    }
                }else if($attribute === 'selected_vehicle'){
                    Log::info('Select Vehicle' . json_encode($before[$attribute]));
                    $newVehicle = json_decode($newValue, true);
                    if($newVehicle['id'] !== $before[$attribute]['id'])
                    $description .=  ucwords(str_replace('_', ' ', $attribute)) . " '<span style='color: red;'>{". $before[$attribute]['vehicles_type']."}</span> ' to '<span style='color: green;'>{". $newVehicle['vehicles_type']."}</span>'.<br> ";
                    //if ($newVehicle['ride_type'] !== $before[$attribute]['ride_type'])
                    //$description .=  ucwords(str_replace('_', ' ', 'ride_type')) . " '<span style='color: red;'>{" . $before[$attribute]['ride_type'] . "}</span> ' to '<span style='color: green;'>{" . $newVehicle['ride_type'] . "}</span>'.<br> ";

                }else if ($attribute === 'pick_up_location' || $attribute === 'dropoff_location') {
                    // Log::info('Selet Vehicle' . json_encode($before[$attribute]));
                    $newPickupLocation = json_decode($newValue, true);
                    $description .=  ucwords(str_replace('_', ' ', $attribute)) . " '<span style='color: red;'>{".$before[$attribute]['address']."}</span> ' to '<span style='color: green;'>{". $newPickupLocation['address']."}</span>'.<br> ";
                }else if ($attribute === 'flight_info') {
                    // Log::info('Selet Vehicle' . json_encode($before[$attribute]));
                    $description .=  ucwords(str_replace('_', ' ', $attribute)) . " '<span style='color: red;'>{" . json_encode($before[$attribute]) . "}</span> ' to '<span style='color: green;'>{" . $newValue['address'] . "}</span>'.<br> ";
                } else if ($attribute === 'hourly_fare_detail') {
                    // Log::info('Selet Vehicle' . json_encode($before[$attribute]));
                } else if ($attribute === 'milage_fare_detail') {
                    // Log::info('Selet Vehicle' . json_encode($before[$attribute]));
                } else if ($attribute === 'additional_millage_charges') {
                    // Log::info('Selet Vehicle' . json_encode($before[$attribute]));
                }else {
                    
                    if ($before[$attribute] !== null) {
                        $description .=  ucwords(str_replace('_', ' ', $attribute)) . " '<span style='color: red;'>{$before[$attribute]}</span> ' to '<span style='color: green;'>{$newValue}</span>'.<br> ";
                    } else {
                        $description .=  ucwords(str_replace('_', ' ', $attribute)) . " '<span style='color: green;'>{$newValue}</span>'.<br> ";
                    }
                    
                }
            }
        }


        // Encode the changes as JSON
        
        $jsonChanges = json_encode($jsonChanges);
       
        // Check if JSON encoding failed
        if (json_last_error() !== JSON_ERROR_NONE) {
            Log::error('JSON encoding error: ' . json_last_error_msg());
        } else {
            // Get the current URL
            $currentRoute = URL::current();
            $customerId=$reservation->customer_id;
            $ipAddress = Request::ip();
            $user=Auth::user();
            $containsDriver = strpos($currentRoute, 'driver') !== false && strpos($currentRoute, 'admin') === false;
            $containsCustomer = strpos($currentRoute, 'with-user') !== false;
             //determineRoleId global function for role_id
            $roleId = determineRoleId($containsDriver, $containsCustomer, $user);
            $userId = $containsCustomer && $customerId !== null ? $customerId : ($user->id ?? null);
            
            if( $reservation->undo == 0 || $reservation->undo == 2 ){
                ActivityLog::create([
                    'user_id' => $userId,
                    'customer_id' => $customerId,
                    'role_id' => $roleId,
                    'ip_address' => $ipAddress,
                    'company_id' => $reservation->site_id,
                    'item_id' => $reservation->id,
                    'table_name' => 'reservations',
                    'activity' => $reservation->undo == 0  ? 'updated':'undo',
                    'activity_detail' => $jsonChanges, // Store the original data
                    'route' => $currentRoute,
                    'activity_description' => $description,
                    'undo'=>$reservation->undo == 0 ? config('app.enums.UNDO_TRUE'):config('app.enums.UNDO_NA')
                ]);
            }
            

        }

    }

    /**
     * Handle the Reservation "deleted" event.
     *
     * @param  \App\Models\Reservation  $reservation
     * @return void
     */
    public function deleted(Reservation $reservation)
    {
        //
    }

    /**
     * Handle the Reservation "restored" event.
     *
     * @param  \App\Models\Reservation  $reservation
     * @return void
     */
    public function restored(Reservation $reservation)
    {
        //
    }

    /**
     * Handle the Reservation "force deleted" event.
     *
     * @param  \App\Models\Reservation  $reservation
     * @return void
     */
    public function forceDeleted(Reservation $reservation)
    {
        //
    }
}
