<?php

namespace App\Observers;

use App\Models\Admin\Driver;
use App\Models\Admin\ActivityLog;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;

class DriverObserver
{
    /**
     * Handle the Driver "created" event.
     *
     * @param  \App\Models\Driver  $driver
     * @return void
     */
    public function created(Driver $driver)
    {
        //
    }

    /**
     * Handle the Driver "updated" event.
     *
     * @param  \App\Models\Driver  $driver
     * @return void
     */
    public function updated(Driver $driver)
    {
        $changes = $driver->getDirty(); // Get the updated attributes
        $before = $driver->getOriginal(); // Get the original data
        // Create an array to store the changes
        $jsonChanges = [];

        // Loop through the changed attributes
        foreach ($changes as $attribute => $newValue) {
            $jsonChanges[$attribute] = [
                'before' => $before[$attribute],
                'after' => $newValue,
            ];
        }

        $description = '';
        foreach ($changes as $attribute => $newValue) {
            if ($attribute !== 'updated_at' && $newValue !== null && $attribute !== 'password' && $attribute !== 'readable_password' && $attribute !== 'remember_token') {
                if ($attribute === 'is_duty_status_active') {
                    $dutyStatus = $newValue ? 'On Duty' : 'Off Duty';
                    Log::info("Driver's duty status changed to: $dutyStatus");
                }
                else {
                    if ($before[$attribute] !== null) {
                        $description .=  ucwords(str_replace('_', ' ', $attribute)) . " '<span style='color: red;'>{$before[$attribute]}</span> ' to '<span style='color: green;'>{$newValue}</span>'.<br> ";
                    } else {
                        $description .=  ucwords(str_replace('_', ' ', $attribute)) . " '<span style='color: green;'>{$newValue}</span>'.<br> ";
                    }
                }

            }
        }


        // Encode the changes as JSON
        $jsonChanges = json_encode($jsonChanges);

        // Check if JSON encoding failed
        if (json_last_error() !== JSON_ERROR_NONE) {
            Log::error('JSON encoding error: ' . json_last_error_msg());
        } else {
            $currentRoute = URL::current();
            $ipAddress = Request::ip();
            $user=Auth::user();
            $containsDriver = strpos($currentRoute, 'driver') !== false && strpos($currentRoute, 'admin') === false;
            $containsCustomer = strpos($currentRoute, 'with-user') !== false;

            // Set role_id based on conditions
            if ($containsDriver) {
                $roleId = config('app.enums.DRIVER_ROLE_ID');
            } elseif ($containsCustomer) {
                $roleId = null;
            } else {
                // Default to the user's role_id if neither condition is met
                $roleId = $user->role_id;
            }


            ActivityLog::create([
                'user_id' => $user->id,
                'role_id' => $roleId,
                'ip_address' => $ipAddress,
                'item_id' => $driver->id,
                'table_name' => 'drivers',
                'activity' => 'updated',
                'activity_detail' => $jsonChanges,
                'route' => $currentRoute,
                'activity_description' => $description,
            ]);

        }
    }

    /**
     * Handle the Driver "deleted" event.
     *
     * @param  \App\Models\Driver  $driver
     * @return void
     */
    public function deleted(Driver $driver)
    {
        //
    }

    /**
     * Handle the Driver "restored" event.
     *
     * @param  \App\Models\Driver  $driver
     * @return void
     */
    public function restored(Driver $driver)
    {
        //
    }

    /**
     * Handle the Driver "force deleted" event.
     *
     * @param  \App\Models\Driver  $driver
     * @return void
     */
    public function forceDeleted(Driver $driver)
    {
        //
    }
}
