<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Module extends Model
{
    use HasFactory;

    protected $table = "modules";

    protected $fillable = [
        'id', 'name', 'route', 'head_name', 'icon', 'parent_id', 'order', 'is_active'
    ];

    public function modules()
    {
        return $this->hasMany(Module::class, 'parent_id');
    }

    public function childrenModules()
    {
       return $this->hasMany(Module::class, 'parent_id')->with('childrenModules');
    }

    public function parentModule()
    {
        return $this->belongsTo(Module::class, 'parent_id');
    }

    public function users()
    {
        return $this->belongsToMany(User::class, 'user_company_module')->distinct('user_id');
        // ->using(UserCompanyModule::class);
    }

    public function companies()
    {
        return $this->belongsToMany(Company::class, 'user_company_module')->distinct('company_id');
        // ->using(UserCompanyModule::class);
    }

}
