<?php

namespace App\Models\Frontend;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Reservation extends Model
{
    use HasFactory;

    protected $table = "reservations";

    // protected $connection = 'company';

    protected $fillable = [
        'id', 'ride_type', 'selected_airport', 'state', 'city', 'zip_code', 'drop_off_state', 'drop_off_city', 'drop_off_zip_code',
        'pick_up', 'departure_date', 'departure_time', 'airline', 'flight_no', 'drop_off', 'luggage', 'large', 'return_state', 'return_city',
        'return_zip_code', 'return_drop_off_state', 'return_drop_off_city', 'return_drop_off_zip_code', 'return_pick_up',
        'return_departure_date', 'return_departure_time', 'return_airline', 'return_flight_no', 'return_drop_off',
        'return_travellers', 'return_adults', 'return_children', 'return_infants', 'return_military','return_students',
        'return_senior_citizen', 'return_luggage', 'return_large'
    ];

    protected $casts = [
        'additional_stops' => 'array',
        'return_additional_stops' => 'array'
    ];
}
