<?php

namespace App\Models\Admin;

use App\Models\Admin\City;
use App\Models\admin\Hotel;
use App\Models\Admin\Vehicle;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ZipCode extends Model
{
    use HasFactory;

    protected $table = "zip_codes";

    protected $fillable = [
        'id', 'city_id', 'zip_code', 'status', 'is_active'
    ];

    public function city()
    {
        return $this->belongsTo(City::class);
    }


    public function vehicles()
    {
        return $this->belongsToMany(Vehicle::class, 'zip_codes_vehicles', 'zip_code_id', 'vehicle_id');
    }
}
