<?php

namespace App\Models\Admin;

use App\Models\Admin\Coupon;
use App\Models\Admin\ZipCode;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Vehicle extends Model
{
    use HasFactory;

    protected $table = "vehicles";

    protected $fillable = [
        'id', 'vehicles_type', 'vehicle_image', 'passengers_capacity', 'luggage_capacity', 'status', 'is_shared',  'is_schedule', 'is_active'
    ];

    public function coupon()
    {
        return $this->hasMany(Coupon::class, 'vehicle_make_ids');
    }


    public function zipCodes()
    {
        return $this->belongsToMany(ZipCode::class, 'zip_codes_vehicles', 'zip_code_id', 'vehicle_id');
    }

}
