<?php

namespace App\Models\Admin;

use App\Models\Module;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Contracts\Auth\CanResetPassword;
use Illuminate\Database\Eloquent\Model;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable implements CanResetPassword
{
    use HasFactory,Notifiable;

    protected $table = "users";

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'id', 'access_key', 'parent_id', 'role_id', 'email', 'password', 'readable_password', 'user_seats', 'email_verified_at', 'last_login',
        'last_ip', 'is_active', 'status'
    ];

    protected $appends = ['user_name', 'role'];


    // user / role relationship
    public function role()
    {
        return $this->belongsTo(Role::class);
    }

    // get user name from employees
    public function getUserNameAttribute()
    {
        if (Employee::where('user_id', $this->id)->exists()) {
            $userName = Employee::select('first_name', 'last_name')->where('user_id', $this->id)->first();
            return $userName->first_name . ' ' . $userName->last_name;
        }
    }



    public function getRoleAttribute()
    {
        if ($this->role_id) {
            $role = UserGroup::select('name')->whereId($this->role_id)->first();
            return $role->name;
        }
    }

    public function companies()
    {
        return $this->belongsToMany(Company::class, 'user_company_module')->distinct('company_id');
        // ->using(UserCompanyModule::class);
    }

    public function modules()
    {
        return $this->belongsToMany(Module::class, 'user_company_module')->distinct('module_id');
        // ->using(UserCompanyModule::class);
    }

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
        'readable_password'
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
}
