<?php

namespace App\Models\Admin;

use App\Models\Admin\City;
use App\Models\Admin\Airport;
use App\Models\Admin\Country;
use App\Models\Admin\Employee;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class State extends Model
{
    use HasFactory;

    protected $table = "states";

    protected $fillable = [
        'id', 'country_id', 'name', 'state_code', 'status', 'is_active'
    ];

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function cities()
    {
        return $this->hasMany(City::class, 'city_id');
    }

    public function airports()
    {
        return $this->hasMany(Airport::class, 'state_id');
    }

    public function drivers()
    {
        return $this->hasMany(Driver::class, 'stete_id');
    }

    public function employees()
    {
        return $this->hasMany(Employee::class, 'state_id');
    }
}
