<?php

namespace App\Models\Admin;

use App\Models\Admin\City;
use App\Models\Admin\Vehicle;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ScheduleService extends Model
{
    use HasFactory;

    protected $table = "schedule_services";
    protected $fillable = [
        'id', 'vehicle_type_id', 'shuttle_name', 'vehicle_capacity', 'carry_bags_capacity', 'check_in_bags_capacity', 'is_home_pickup', 'is_home_drop_off', 'timings',
        'pick_up_location', 'drop_off_location', 'pick_up_time', 'drop_off_time', 'price_per_person', 'distance', 'time_duration_hours', 'time_duration_text', 'home_pickup_charges',
        'home_drop_off_charges', 'additional_millage_charges', 'timely_millage_charges', 'reservation_hours', 'reservation_minutes', 'pickup_hours','city_id',
        'pickup_minutes', 'cancel_hours', 'cancel_minute', 'home_pickup_hours', 'home_pickup_minutes', 'home_drop_off_hours', 'home_drop_off_minutes', 'status', 'is_active','charges'
    ];

    protected $casts = [
        'timings' => 'json',
        'home_pickup_address' => 'json',
        'home_drop_off_address' => 'json',
        'pick_up_location' => 'json',
        'drop_off_location' => 'json',
        'selected_airport' => 'json',
        'additional_millage_charges' => 'json',
        'timely_millage_charges' => 'json',
        'charges' => 'json',

    ];

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class, 'vehicle_type_id', 'id');
    }
    public function city(){
        return $this->belongsTo(City::class, 'city_id', 'id');
    }
}
