<?php

namespace App\Models\Admin;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class Reservation extends Model
{
    use HasFactory,SoftDeletes;

    protected $table = "reservations";
    public $undo = 0;

    protected $fillable = [
        'id', 'service_type_id', 'site_id', 'vehicle_type_id', 'user_id', 'customer_id', 'customer_notes', 'customer_type', 'airport_ride', 'pick_up_location', 'pick_up_date', 'departure_pick_up_date',
        'departure_pick_up_time', 'selected_airline', 'selected_flight_destination', 'flight_number', 'return_pick_up_date', 'return_pick_up_time', 'shuttle_name', 'ip_address',
        'admin_discount','coupon', 'drop_off_location', 'drop_off_date', 'drop_off_time', 'travellers', 'travellers_types', 'additional_millage_charges', 'timely_millage_charges', 'pay_type_id',
        'traveller_types_charges', 'additional_stops', 'luggage', 'check_in_bags', 'distance', 'time_duration_text', 'time_duration_hours' , 'drop_off_hours', 'ride_type', 'ride_started_time',
        'ride_completed_time', 'schedule_service_type', 'home_pick_up_location', 'home_drop_off_location', 'vehicles_count', 'total_fare',
        'selected_vehicle','milage_fare_detail', 'hourly_fare_detail','schedule_fare_detail','driver_status','status', 'round_trip', 'is_on_call', 'is_active','cancellation_reason','is_email_sent','email_template_id','driver_email_template_id','is_driver_email_sent'
    ];

    protected $casts = [
        'pick_up_location' => 'json',
        'drop_off_location' => 'json',
        'home_pick_up_location' => 'json',
        'home_drop_off_location' => 'json',
        'travellers_types' => 'json',
        'additional_millage_charges' => 'json',
        'timely_millage_charges' => 'json',
        'traveller_types_charges' => 'json',
        'selected_vehicle' => 'json',
        'milage_fare_detail' => 'json',
        'hourly_fare_detail' => 'json',
        'schedule_fare_detail' => 'json',
        'coupon' => 'json',
        'additional_stops' => 'json',
        'ride_started_time' => 'datetime', // Ensure the column names are correct
        'ride_completed_time' => 'datetime',
    ];


    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
    public function driver()
    {
        return $this->belongsTo(Driver::class, 'driver_id');
    }
    public function guestCustomer()
    {
        return $this->belongsTo(GuestCustomer::class);

    }
    public function  selectedVehicle(){
        //$vehicle =

        return $this->belongsTo(Vehicle::class, 'vehicle_type_id')->select(['id', 'vehicles_type', 'passengers_capacity', 'luggage_capacity']);
    }

}
