<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GuestCustomer extends Model
{
    use HasFactory;
    protected $table = "guest_customers";

    protected $fillable = [
        'id', 'first_name', 'last_name', 'phone_number', 'mobile_number', 'address', 'email', 'customer_type', 'card_type', 'cc_number', 'cc_expiry', 'csv_code',
        'cc_status', 'billing_zip_code', 'card_holder_name', 'billing_address', 'billing_phone_number', 'is_important_info', 'is_discount_promotion', 'status', 'is_active','site_id','pay_type_id','cheque_number'
    ];

    protected $casts = [
        'billing_address' => 'json',
        'address' => 'json',
    ];

    public function reservations()
    {
        return $this->hasMany(Reservation::class, 'customer_id');
    }
}
