<?php

namespace App\Models\Admin;

use App\Models\Admin\City;
use App\Models\Admin\State;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class FlightDestination extends Model
{
    use HasFactory;

    protected $table = "flight_destinations";

    protected $fillable = [
        'id', 'name', 'code', 'state_id', 'city_id', 'status', 'is_active','location'
    ];

    protected $casts = [
        'location' => 'array',
    ];

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function state()
    {
        return $this->belongsTo(State::class);
    }
}

