<?php

namespace App\Models\Admin;

use App\Models\Admin\Driver;
use App\Models\Admin\ExpensesHead;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ExpenseDetails extends Model
{
    use HasFactory;

    protected $table = "expense_details";

    protected $fillable = [
        'id', 'user_id', 'user_group_id', 'expense_id', 'user_name', 'expense_details', 'amount', 'expense_date', 'is_active', 'status'
    ];

    public function expenseHead(){
        return $this->belongsTo(ExpensesHead::class, 'expense_id', 'id');
    }

    public function driver(){
        return $this->belongsTo(Driver::class, 'user_id', 'id');
    }

}
