<?php

namespace App\Models\Admin;

use App\Models\Admin\City;
use App\Models\Admin\State;
use App\Models\Admin\Country;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Employee extends Model
{
    use HasFactory;

    protected $table = "employees";

    protected $fillable = [
        'id', 'user_id',  'emp_category_id', 'first_name', 'last_name', 'profile_image', 'email_address', 'home_phone',
        'cell_phone', 'cell_phone_provider', 'gender', 'country_id',  'state_id', 'city_id', 'address', 'postal_code',
        'gender', 'dob', 'social_security_number', 'emp_id_number', 'emp_id_expiry',
        'emp_license_number', 'emp_license_image', 'emp_license_expiry', 'driving_license_back', 'police_clearance_number',
        'police_clearance_image', 'criminal_record_exp',
        'policy_number', 'policy_image', 'date_of_joining', 'date_of_last_employment', 'prim_emg_name', 'prim_emg_relation', 'prim_emg_phone',
        'prim_emg_mobile', 'prim_emg_address', 'sec_emg_name', 'sec_emg_relation', 'sec_emg_phone', 'sec_emg_mobile',
        'sec_emg_address', 'prim_emg_address', 'status', 'is_active',
    ];

    public function country()
    {
        return $this->belongsTo(Country::class);
    }
    public function state()
    {
        return $this->belongsTo(State::class);
    }
    public function city()
    {
        return $this->belongsTo(City::class);
    }
}
