<?php

namespace App\Models\Admin;

use App\Models\Admin\Vehicle;
use App\Models\Admin\VehicleMake;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class DriverVehicle extends Model
{
    use HasFactory;

    protected $table= "driver_vehicles";

    protected $fillable = [ 'vehicle_make_id','vehicle_model_id', 'vehicle_model_year', 'vehicle_type_id', 'vehicle_registration_number', 'vehicle_color',
    'vehicle_plate_no', 'vehicle_image','car_number','driver_id'];

    public function vehicles(){
        return $this->belongsTo(VehicleMake::class,'vehicle_make_id');
    }
    public function vehicleTypes()
    {
        return $this->belongsTo(Vehicle::class, 'vehicle_type_id' );
    }
}
