<?php

namespace App\Models\Admin;

use App\Models\Admin\DriverVehicle;
use App\Models\Admin\DriverCategory;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Database\Eloquent\SoftDeletes;

class Driver extends Authenticatable implements AuthenticatableContract
{
    use HasFactory, Notifiable,SoftDeletes;

    protected $table = "drivers";

    protected $fillable = [
        'id', 'user_id', 'salary_type', 'salary',  'category_id', 'first_name', 'last_name', 'profile_image', 'email', 'password', 'readable_password',
        'home_phone','cell_phone', 'gender', 'country_id',  'state_id', 'city_id', 'address', 'postal_code',
        'driver_id_number', 'driver_id_expiry','driving_license_number', 'driver_license_image', 'police_clearance_number',
        'police_clearance_image', 'driver_history', 'driver_history_image', 'insurance_number', 'insurance_image', 'dob', 'social_security_number',
        'date_of_joining', 'date_of_last_employment','is_active', 'prim_emg_name', 'prim_emg_relation', 'prim_emg_phone',
        'prim_emg_mobile', 'prim_emg_address', 'sec_emg_name', 'sec_emg_relation', 'sec_emg_phone', 'sec_emg_mobile',
        'sec_emg_address', 'prim_emg_address','is_duty_status_active','active','address_obj'
    ];

    protected $hidden = [
        'password', 'remember_token', 'readable_password'
    ];

    public function cellPhoneProvider()
    {
        return $this->belongsTo(Phone::class, 'phone_provider_id');
    }
    public function country()
    {
        return $this->belongsTo(Country::class);
    }
    public function state()
    {
        return $this->belongsTo(State::class);
    }
    public function city()
    {
        return $this->belongsTo(City::class);
    }
    public function category()
    {
        return $this->belongsTo(DriverCategory::class);
    }

    public function driver_vehicles(){
        return $this->hasMany(DriverVehicle::class,'driver_id','id');
    }

    protected $casts = [
        'address_obj' => 'json',
    ];
}
