<?php

namespace App\Models\Admin;

use Illuminate\Support\Facades\Crypt;
use Illuminate\Database\Eloquent\Model;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\CanResetPassword;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Database\Eloquent\SoftDeletes;
use Laravel\Passport\HasApiTokens;

class Customer extends Authenticatable implements AuthenticatableContract,CanResetPassword
{
    use HasFactory, Notifiable,HasApiTokens,SoftDeletes;

    protected $guard = 'customer';

    protected $table = "customers";

    protected $fillable = [
        'id', 'first_name', 'last_name', 'phone_number', 'mobile_number', 'address', 'email', 'password', 'readable_password', 'customer_type', 'card_type', 'cc_number', 'cc_expiry', 'csv_code',
        'cc_status', 'billing_zip_code', 'card_holder_name', 'billing_address', 'billing_phone_number', 'is_important_info', 'is_discount_promotion', 'status', 'is_active','site_id','pay_type_id','cheque_number'
    ];
    protected $appends = ['cc_last_digits'];

    protected $hidden = [
        'password', 'remember_token','readable_password'
    ];

    protected $casts = [
        'billing_address' => 'json',
        'address' => 'json',
    ];

    public function getCcLastDigitsAttribute()
    {
        $cc_number = $this->attributes['cc_number'];
        return substr($cc_number, -4);
    }

    public function setCcNumberAttribute($value)
    {
        $this->attributes['cc_number'] = Crypt::encrypt($value);
    }

    public function getCcNumberAttribute($value)
    {
        try {
            return !is_null($value) ? Crypt::decrypt($value) : '';
        } catch (\Exception $e) {
            return '';
        }
    }

    public function setCsvCodeAttribute($value)
    {
        $this->attributes['csv_code'] = Crypt::encrypt($value);
    }

    public function getCsvCodeAttribute($value)
    {
        try {
            return !is_null($value) ? Crypt::decrypt($value) : '';
        } catch (\Exception $e) {
            return '';
        }
    }

    public function reservations()
    {
        return $this->hasMany(Reservation::class, 'customer_id');
    }
}
