<?php

namespace App\Models\Admin;

use App\Models\Admin\City;
use App\Models\Admin\Vehicle;
use App\Models\Admin\Services;
use App\Models\Admin\VehicleMake;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Coupon extends Model
{
    use HasFactory;
    protected $table = "coupons";

    protected $fillable = [
        'id', 'user_id', 'city_id', 'service_id', 'coupon_code', 'vehicle_make_ids' ,'coupon_type', 'coupon_price', 'expiry_date', 'is_active'
    ];

    protected $casts = [
        'vehicle_make_ids' => 'array'
    ];

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }

    public function service()
    {
        return $this->belongsTo(Services::class);
    }

    public function city()
    {
        return $this->belongsTo(City::class);
    }


}
