<?php

namespace App\Models\Admin;

use App\Models\Admin\State;
use App\Models\Admin\Employee;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Country extends Model
{
    use HasFactory;

    protected $table = "countries";
    
    protected $fillable = [
        'id', 'name', 'iso_2', 'iso_3', 'flag'
    ];

    public function states()
    {
        return $this->hasMany(State::class, 'country_id');
    }

    public function drivers()
    {
        return $this->hasMany(Driver::class, 'country_id');
    }

    public function employees()
    {
        return $this->hasMany(Employee::class, 'country_id');
    }
}
