<?php

namespace App\Models\Admin;

use App\Models\Admin\State;
use App\Models\Admin\Coupon;
use App\Models\Admin\Airport;
use App\Models\Admin\ZipCode;
use App\Models\Admin\Employee;
use App\Models\Admin\VehicleMake;
use App\Models\Admin\ServicesVehicles;
use App\Models\Admin\FlightDestination;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class City extends Model
{
    use HasFactory;

    protected $table = "cities";

    protected $fillable = [
        'id', 'state_id', 'name', 'services', 'schedule_services', 'reservation_time_limit', 'cancel_time_limit', 'status', 'is_active'
    ];

    protected $casts = [
        'services' => 'array',
        'schedule_services' => 'array'
    ];

    public function state()
    {
        return $this->belongsTo(State::class);
    }

    public function zipCodes()
    {
        return $this->HasMany(ZipCode::class, 'city_id');
    }

    public function airPorts()
    {
        return $this->HasMany(Airport::class, 'city_id');
    }

    public function drivers()
    {
        return $this->hasMany(Driver::class, 'city_id');
    }

    public function employees()
    {
        return $this->hasMany(Employee::class, 'city_id');
    }


    public function coupon()
    {
        return $this->hasMany(Coupon::class, 'city_id');
    }

    public function flightDestination()
    {
        return $this->hasMany(FlightDestination::class, 'city_id');
    }
}
