<?php

namespace App\Models\Admin;

use App\Models\Admin\Driver;
use App\Models\Admin\Customer;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class BlockDriver extends Model
{
    use HasFactory;

    protected $table = "blocked_drivers";

    protected $fillable = [
        'id', 'user_id', 'customer_id', 'driver_id', 'reason', 'reservation_id', 'blocked'
    ];

    public function drivers(){
        return $this->hasOne(Driver::class,'id','driver_id');
    }

    public function customers(){
        return $this->hasOne(Customer::class,'id','customer_id');
    }
}
