<?php

namespace App\Models\Admin;

use App\Models\Admin\State;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Airport extends Model
{
    use HasFactory;

    protected $table = "airports";

    protected $fillable = [
        'id', 'state_id', 'city_id', 'name', 'status', 'is_active', 'airport_location'
    ];

    protected $casts = [
        'airport_location' => 'array',
    ];

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function state()
    {
        return $this->belongsTo(State::class);
    }
}
