<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Support\Facades\Log;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class ReservationConfirmation extends Mailable
{
    use Queueable, SerializesModels;

    public $data, $subject,$bladeFile,$reservationIds;

    /**
     * Create a new message instance.
     *
     * @param  string  $message
     * @return void
     */
    public function __construct($data, $subject,$reservationIds = [],$bladeFile = null)
    {
        $this->data = $data;
        $this->subject = $subject;
        $this->reservationIds = $reservationIds;
        $this->bladeFile = $bladeFile;
    }

    /**
     * Build the message.
     *
     * @return $this
     */

    public function build()
    {
        $address = env('MAIL_FROM_ADDRESS');
        $name = env('MAIL_FROM_NAME');

        if($this->bladeFile){
            return $this->view($this->bladeFile)
                ->from($address, $name)
                ->subject($this->subject)
                ->with(
                    ['booking' => json_decode(json_encode($this->data), true)
                    ,'subject' => $this->subject,
                    'reservationIds'=>$this->reservationIds
                    ]
                );
        }
        else{
            return $this->html($this->data)
            ->from($address, $name)
            ->subject($this->subject);
        }
    }
}
