<?php

namespace App\Mail;

use GuzzleHttp\Psr7\Request;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class NewUserWelcomeMail extends Mailable
{
    use Queueable, SerializesModels;

    public $message;
    public $email;

    /**
     * Create a new message instance.
     *
     * @param  string  $message
     * @param  string  $email
     * @return void
     */
    public function __construct($message, $email)
    {
        $this->message = $message;
        $this->email = $email;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('admin.reservations.index');
    }
}

