<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class MailHandler extends Mailable
{
    use Queueable, SerializesModels;

    public $fromAddress, $fromName, $message, $subject;

    /**
     * Create a new message instance.
     *
     * @param  string  $message
     * @return void
     */
    public function __construct($message, $subject, $fromName = "QuickSilver Shuttle & Car Service-New Reservation Alert!")
    {
        $this->fromAddress = env('MAIL_FROM_ADDRESS');
        $this->fromName = $fromName;
        $this->message = $message;
        $this->subject = $subject;
    }

    /**
     * Build the message.
     *
     * @return $this
     */

    public function build()
    {
        return $this->html($this->message)
            ->from($this->fromAddress, $this->fromName)
            ->subject($this->subject);
    }
}
