<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class CheckAuthorizationHeader
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $headers = $request->headers->all();
        foreach ($headers as $key => $value) {
            Log::info('Header: ' . $key . ' => ' . implode(', ', $value));
        }
        if (!$request->hasHeader('Authorization')) {
            return response()->json(['error' => 'Authorization header not found'], 401);
        }
        return $next($request);
    }
}
