<?php

namespace App\Http\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;

class Authenticate extends Middleware
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return string|null
     */
    protected function redirectTo($request)
    {
        if ($request->is('admin/*')) {
            // Redirect admin to the admin login page
            return route('admin-login-page');
        } elseif ($request->is('customer/*')) {
            // Redirect customer to the customer login page
            return route('customer.login');
        } elseif ($request->is('driver/*')) {
            // Redirect driver to the driver login page
            return route('driver.login');
        }
    }
}
