<?php

namespace App\Http\Controllers\Frontend;

use stdClass;
use Illuminate\Http\Request;
use App\Models\Admin\Services;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Admin\Airport;
use App\Models\Frontend\Reservation;

class FrontendController extends Controller
{
    public function index()
    {
        // dd('from list');
        return view('frontend.list');
    }

    public function list()
    {
        // dd('from list');
        return view('frontend.index');
    }

    public function search(Request $request)
    {
        return response()->json(['data' => $request->all()], 201);
        // return response()->json(['data' => $request->all()], 201);
        // return view('frontend.index');
    }

    public function createReservations(Request $request)
    {
        if ($request->reservation_type == 1) {
            try {
                DB::beginTransaction();

                $reservation = new Reservation();

                $reservation->ride_type = $request->ride_type;
                $reservation->selected_airport = $request->selected_airport;
                $reservation->state = $request->state;
                $reservation->city = $request->city;
                $reservation->zip_code = $request->zip_code;
                $reservation->pick_up = $request->pick_up;
                $reservation->departure_date = $request->departure_date;
                $reservation->departure_time = $request->departure_time;
                $reservation->airline = $request->airline;
                $reservation->flight_no = $request->flight_no;
                $reservation->drop_off = $request->drop_off;
                $reservation->travellers = $request->travellers;
                $reservation->adults = $request->adults;
                $reservation->children = $request->children;
                $reservation->infants = $request->infants;
                $reservation->military = $request->military;
                $reservation->students = $request->students;
                $reservation->senior_citizen = $request->senior_citizen;
                $reservation->luggage = $request->luggage;
                $reservation->large = $request->large;
                $reservation->senior_citizen = $request->senior_citizen;
                $reservation->additional_stops = $request->additional_stops;
                $reservation->reservation_type = $request->reservation_type;

                $reservation->save();
                DB::commit();
                return response()->json(['message' => 'Reservation added successfully'], 201);
            } catch (\Exception $exception) {
                DB::rollback();
                return response()->json(['error' => $exception->getMessage()], 500);
            }

        }
        else if ($request->reservation_type == 2) {
            try {
                DB::beginTransaction();

                $reservation = new Reservation();

                $reservation->reservation_type = $request->reservation_type;

                $reservation->ride_type = $request->ride_type;
                $reservation->selected_airport = $request->selected_airport;
                $reservation->state = $request->state;
                $reservation->city = $request->city;
                $reservation->zip_code = $request->zip_code;
                $reservation->pick_up = $request->pick_up;
                $reservation->departure_date = $request->departure_date;
                $reservation->departure_time = $request->departure_time;
                $reservation->airline = $request->airline;
                $reservation->flight_no = $request->flight_no;
                $reservation->drop_off = $request->drop_off;

                $reservation->return_state = $request->return_state;
                $reservation->return_city = $request->return_city;
                $reservation->return_zip_code = $request->return_zip_code;
                $reservation->return_pick_up = $request->return_pick_up;
                $reservation->return_departure_date = $request->return_departure_date;
                $reservation->return_departure_time = $request->return_departure_time;
                $reservation->return_airline = $request->return_airline;
                $reservation->return_flight_no = $request->return_flight_no;
                $reservation->return_drop_off = $request->return_drop_off;

                $reservation->travellers = $request->travellers;
                $reservation->adults = $request->adults;
                $reservation->children = $request->children;
                $reservation->infants = $request->infants;
                $reservation->military = $request->military;
                $reservation->students = $request->students;
                $reservation->senior_citizen = $request->senior_citizen;
                $reservation->additional_stops = $request->additional_stops;

                $reservation->return_travellers = $request->return_travellers;
                $reservation->return_adults = $request->return_adults;
                $reservation->return_children = $request->return_children;
                $reservation->return_infants = $request->return_infants;
                $reservation->return_military = $request->return_military;
                $reservation->return_students = $request->return_students;
                $reservation->return_senior_citizen = $request->return_senior_citizen;
                $reservation->return_additional_stops = $request->return_additional_stops;

                $reservation->luggage = $request->luggage;
                $reservation->large = $request->large;

                $reservation->return_luggage = $request->return_luggage;
                $reservation->return_large = $request->return_large;
                $reservation->reservation_type = $request->reservation_type;

                $reservation->save();

                DB::commit();
                return response()->json(['message' => 'Reservation added successfully'], 201);
            } catch (\Exception $exception) {
                DB::rollback();
                return response()->json(['error' => $exception->getMessage()], 500);
            }
        }
        else if ($request->reservation_type == 3) {

            if ($request->is_round_trip == true) {
                try {
                    DB::beginTransaction();

                    $reservation = new Reservation();

                    $reservation->reservation_type = $request->reservation_type;

                    $reservation->state = $request->state;
                    $reservation->city = $request->city;
                    $reservation->zip_code = $request->zip_code;
                    $reservation->pick_up = $request->pick_up;

                    $reservation->drop_off_state = $request->drop_off_state;
                    $reservation->drop_off_city = $request->city;
                    $reservation->drop_off_zip_code = $request->drop_off_zip_code;
                    $reservation->drop_off = $request->drop_off;

                    $reservation->departure_date = $request->departure_date;
                    $reservation->departure_time = $request->departure_time;

                    $reservation->travellers = $request->travellers;
                    $reservation->adults = $request->adults;
                    $reservation->children = $request->children;
                    $reservation->infants = $request->infants;
                    $reservation->military = $request->military;
                    $reservation->students = $request->students;
                    $reservation->senior_citizen = $request->senior_citizen;
                    $reservation->additional_stops = $request->additional_stops;

                    $reservation->return_state = $request->return_state;
                    $reservation->return_city = $request->return_city;
                    $reservation->return_zip_code = $request->return_zip_code;
                    $reservation->return_pick_up = $request->return_pick_up;

                    $reservation->return_drop_off_state = $request->return_drop_off_state;
                    $reservation->return_drop_off_city = $request->return_city;
                    $reservation->return_drop_off_zip_code = $request->return_drop_off_zip_code;
                    $reservation->return_drop_off = $request->return_drop_off;

                    $reservation->return_departure_date = $request->return_departure_date;
                    $reservation->return_departure_time = $request->return_departure_time;

                    $reservation->return_travellers = $request->return_travellers;
                    $reservation->return_adults = $request->return_adults;
                    $reservation->return_children = $request->return_children;
                    $reservation->return_infants = $request->return_infants;
                    $reservation->return_military = $request->return_military;
                    $reservation->return_students = $request->return_students;
                    $reservation->return_senior_citizen = $request->return_senior_citizen;
                    $reservation->return_additional_stops = $request->return_additional_stops;

                    $reservation->luggage = $request->luggage;
                    $reservation->large = $request->large;

                    $reservation->return_luggage = $request->return_luggage;
                    $reservation->return_large = $request->return_large;
                    $reservation->reservation_type = $request->reservation_type;

                    $reservation->save();

                    DB::commit();
                    return response()->json(['message' => 'Reservation added successfully'], 201);
                } catch (\Exception $exception) {
                    DB::rollback();
                    return response()->json(['error' => $exception->getMessage()], 500);
                }
            } else {

                try {
                    DB::beginTransaction();

                    $reservation = new Reservation();

                    $reservation->reservation_type = $request->reservation_type;

                    $reservation->state = $request->state;
                    $reservation->city = $request->city;
                    $reservation->zip_code = $request->zip_code;
                    $reservation->pick_up = $request->pick_up;

                    $reservation->drop_off_state = $request->drop_off_state;
                    $reservation->drop_off_city = $request->city;
                    $reservation->drop_off_zip_code = $request->drop_off_zip_code;
                    $reservation->drop_off = $request->drop_off;

                    $reservation->departure_date = $request->departure_date;
                    $reservation->departure_time = $request->departure_time;

                    $reservation->travellers = $request->travellers;
                    $reservation->adults = $request->adults;
                    $reservation->children = $request->children;
                    $reservation->infants = $request->infants;
                    $reservation->military = $request->military;
                    $reservation->students = $request->students;
                    $reservation->senior_citizen = $request->senior_citizen;
                    $reservation->additional_stops = $request->additional_stops;

                    $reservation->luggage = $request->luggage;
                    $reservation->large = $request->large;
                    $reservation->reservation_type = $request->reservation_type;

                    $reservation->save();

                    DB::commit();
                    return response()->json(['message' => 'Reservation added successfully'], 201);
                } catch (\Exception $exception) {
                    DB::rollback();
                    return response()->json(['error' => $exception->getMessage()], 500);
                }
            }
        }
    }

    public function getReservationData(){
        try {
            $obj = new stdClass();
            $obj->allServices = Services::select('id', 'service_name')->where('is_active', 1)->get();
            $obj->allAirports = Airport::select('id', 'name')->where('is_active', 1)->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }

    }
}
