<?php

namespace App\Http\Controllers\External;

use App\Models\Admin\Site;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class ExternalLinkController extends Controller
{
    // public function handleSite($token, $fareQuote = false,$customer = false,$customerDashboard = false,$schedule = false,$nextRoute = '',$findReservation = false)
    // {
    //     $site = Site::where('token', $token)->select('id', 'image', 'site_name', 'site_url')->first();
    //     if ($site) {
    //         if($customer){
    //             return view('externalLinks.customer', [
    //                 'site' => $site,
    //                 'nextRoute' => $nextRoute
    //             ]);
    //         }
    //         else if($customerDashboard){
    //             return view('externalLinks.customerDashboard', [
    //                 'site' => $site,
    //             ]);
    //         }
    //         else if($schedule){
    //             return view('externalLinks.schedule', [
    //                 'site' => $site,
    //             ]);
    //         }
    //         else if($findReservation){
    //             return view('externalLinks.findReservation', [
    //                 'site' => $site,
    //             ]);
    //         }
    //         else{
    //             return view('externalLinks.reservation', [
    //                 'site' => $site,
    //                 'fareQuote' => $fareQuote
    //             ]);
    //         }
    //     }

    //     // Handle the case where the site is not found (optional)
    //      abort(401);
    // }

    // public function makeReservation($token)
    // {
    //     $isGuest = request()->has('guest');
    //      // If the guest flag is set, skip authentication check
    //     if ($isGuest || auth()->guard('customer')->check()) {
    //         return $this->handleSite($token);
    //     }

    //     return $this->handleSite($token,false,true,false,false,'reservation');
    // }

    // public function fareQuote($token)
    // {
    //     $isGuest = request()->has('guest');

    //     if ($isGuest || auth()->guard('customer')->check()) {
    //         return $this->handleSite($token, true);
    //     }
    //     return $this->handleSite($token,false,true,false,false,'fare-quote');
    // }

    // public function scheduleService($token){

    //     $isGuest = request()->has('guest');
    //     if ($isGuest || auth()->guard('customer')->check()) {
    //         return $this->handleSite($token,false,false,false,true);
    //     }
    //     return $this->handleSite($token,false,true,false,false,'schedule-service');
    // }

    // public function findReservation($token){

    //     return $this->handleSite($token,false,false,false,false,'',true);
    // }
    // public function customerLogin($token){
    //     return $this->handleSite($token,false,true);
    // }

    // public function customerDashboard($token){
    //     if (!auth()->guard('customer')->check()) {
    //         return $this->handleSite($token,false,true);
    //     }
    //     return $this->handleSite($token,false,false,true);
    // }

    // public function logout($token)
    // {
    //     Auth::guard('customer')->logout();
    //     return redirect()->route('extCustomer',['token' => $token])->with('message', 'Logout Successfully');
    // }

    const VIEW_CUSTOMER = 'externalLinks.customer';
    const VIEW_CUSTOMER_DASHBOARD = 'externalLinks.customerDashboard';
    const VIEW_SCHEDULE = 'externalLinks.schedule';
    const VIEW_FIND_RESERVATION = 'externalLinks.findReservation';
    const VIEW_RESERVATION = 'externalLinks.reservation';

    const NEXT_ROUTE_RESERVATION = 'reservation';
    const NEXT_ROUTE_FARE_QUOTE = 'fare-quote';
    const NEXT_ROUTE_SCHEDULE_SERVICE = 'schedule-service';

    public function handleSite($token, $fareQuote = false, $view = self::VIEW_RESERVATION, $nextRoute = '', $additionalData = [])
    {
        $site = Site::where('token', $token)->select('id', 'image', 'site_name', 'site_url')->first();

        if ($site) {
            $data = array_merge(['site' => $site, 'fareQuote' => $fareQuote, 'nextRoute' => $nextRoute], $additionalData);
            return view($view, $data);
        }

        // Handle the case where the site is not found (optional)
        abort(401);
    }

    public function makeReservation($token)
    {
        $isGuest = request()->has('guest');

        if ($isGuest || auth()->guard('customer')->check()) {
            return $this->handleSite($token);
        }

        return $this->handleSite($token, false, self::VIEW_CUSTOMER, self::NEXT_ROUTE_RESERVATION);
    }

    public function fareQuote($token)
    {
        $isGuest = request()->has('guest');

        if ($isGuest || auth()->guard('customer')->check()) {
            return $this->handleSite($token, true);
        }

        return $this->handleSite($token, false, self::VIEW_CUSTOMER, self::NEXT_ROUTE_FARE_QUOTE);
    }

    public function scheduleService($token)
    {
        $isGuest = request()->has('guest');

        if ($isGuest || auth()->guard('customer')->check()) {
            return $this->handleSite($token, false, self::VIEW_SCHEDULE);
        }

        return $this->handleSite($token, false, self::VIEW_CUSTOMER, self::NEXT_ROUTE_SCHEDULE_SERVICE);
    }

    public function findReservation($token)
    {
        return $this->handleSite($token, false, self::VIEW_FIND_RESERVATION);
    }

    public function customerLogin($token)
    {
        return $this->handleSite($token, false, self::VIEW_CUSTOMER);
    }

    public function customerDashboard($token)
    {
        if (!auth()->guard('customer')->check()) {
            return $this->handleSite($token, false, self::VIEW_CUSTOMER);
        }

        return $this->handleSite($token, false, self::VIEW_CUSTOMER_DASHBOARD);
    }

    public function logout($token)
    {
        Auth::guard('customer')->logout();
        return redirect()->route('extCustomer', ['token' => $token])->with('message', 'Logout Successfully');
    }

}
