<?php

namespace App\Http\Controllers\Email;

use stdClass;
use Google\Client;
use App\Mail\MailHandler;
use App\Mail\MyTestEmail;
use Google\Service\Gmail;
use App\Models\Admin\Site;
use Illuminate\Http\Request;
use Illuminate\Mail\Mailable;
use App\Models\Admin\ActivityLog;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\PHPMailer;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use App\Models\Admin\EmailTemplates;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\View;
use App\Mail\ReservationConfirmation;
use App\Services\EmailService;

class EmailSentController extends Controller
{
    protected $emailService;

    public function __construct(EmailService $emailService)
    {
        $this->emailService = $emailService;
    }
    public function index()
    {
        $emailData = [
            'subject' => "Subject",
            'title' => "title",
            'content' => "content",
        ];
        // Subject
        $subject = $emailData['subject'];

        // Message
        $message = '
                <html>
                    <head>
                    <title>' . $emailData['title'] . '</title>
                    </head>
                    <body>
                        <p><b>' . $emailData['content'] . '</b></p>
                    </body>
                </html>
            ';

        // To send HTML mail, the Content-type header must be set
        $headers[] = 'MIME-Version: 1.0';
        $headers[] = 'Content-type: text/html; charset=iso-8859-1';

        // Additional headers
        // $headers[] = 'From: Test Email < test@3.36.181.47';
        $headers[] = 'From: Test Email < hiqusol88@gmail.com';

        // Mail it
        return mail('info.alihassan@gmail.com', $subject, $message, implode("\r\n", $headers));

    }

    // function sendEmail(Request $request)
    // {

    //     $mailto = "deepak@dunitech.com";
    //     $subject = "this is attcmentcode";

    //     // $file = "Xactimate4_1428674826.png";
    //     // $file_size = filesize($file);
    //     // $handle = fopen($file, "r");
    //     // $content = fread($handle, $file_size);
    //     // fclose($handle);
    //     // $content = chunk_split(base64_encode($content));

    //     // a random hash will be necessary to send mixed content
    //     $separator = md5(time());

    //     // carriage return type (we use a PHP end of line constant)
    //     $eol = PHP_EOL;

    //     // main header (multipart mandatory)
    //     $headers = "From: name <test@test.com>" . $eol;
    //     $headers .= "MIME-Version: 1.0" . $eol;
    //     $headers .= "Content-Type: multipart/mixed; boundary=\"" . $separator . "\"" . $eol . $eol;
    //     $headers .= "Content-Transfer-Encoding: 7bit" . $eol;
    //     $headers .= "This is a MIME encoded message." . $eol . $eol;

    //     // message
    //     $message = 'test email';

    //     $headers .= "--" . $separator . $eol;
    //     $headers .= "Content-Type: text/plain; charset=\"iso-8859-1\"" . $eol;
    //     $headers .= "Content-Transfer-Encoding: 8bit" . $eol . $eol;
    //     $headers .= $message . $eol . $eol;



    //     //SEND Mail
    //     if (mail($mailto, $subject, "", $headers)) {
    //         echo "mail send ... OK"; // or use booleans here
    //     } else {
    //         echo "mail send ... ERROR!";
    //     }
    // }

    // commented by Awais
    // public function sendEmail(Request $request)
    // {

    //     try {
    //         $obj = new stdClass();

    //         $obj->email = $request->email;
    //         $obj->message  = $request->message;

    //         $subject = 'Reservation Confirmation !';
    //         // $obj->message  = 'test email message';

    //         $this->sendReservationConfirmation($obj->email, $obj->message, $subject);


    //         function replacePlaceholders($template, $request)
    //         {
    //             $placeholders = [];
    //             preg_match_all('/{{\s*(\w+)\s*}}/', $template, $matches);

    //             foreach ($matches[1] as $key) {
    //                 if (property_exists($request, $key)) {
    //                     $placeholders['{{ ' . $key . ' }}'] = $request->$key;
    //                 }
    //             }
    //             return strtr($template, $placeholders);
    //         }
    //         return response()->json($obj);

    //     } catch (\Exception $exception) {
    //         return response()->json(['error' => $exception->getMessage()], 500);
    //     }

    //     // return response()->json(['message' => 'Email sent successfully!'], 200);
    // }

    // public function sendReservationConfirmation($email, $message, $subject)
    // {
        // Mail::to($email)->send(new ReservationConfirmation($message, $subject));
    // }

    public function sendEmail(Request $request)
    {
        try {
            $email = $request->email;
            $message = $request->message;

            $reservationIds = (array)$request->reservation_id;
            $subject = $request->is_edit ? 'Changes Made to the Reservation '. implode(' ,', $reservationIds) .'' : 'Reservation Confirmation !';
            $customerId=$request->customer_id;

            $mailable = new ReservationConfirmation($message, $subject, $reservationIds);

            // Queue the email
            $emailSent = $this->emailService->sendEmail($email, $mailable,$message,$reservationIds, $customerId);
            return response()->json(['message' => $emailSent ? 'Email send successfully.' : 'Email failed to send.']);
            } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function redirectToGoogle()
    {
        $client = new Client();
        $client->setAuthConfig(storage_path('app/client_secret.json'));
        $client->setRedirectUri(route('google.auth.callback'));
        $client->addScope(Gmail::GMAIL_COMPOSE);

        return redirect()->to($client->createAuthUrl());
    }

    public function handleGoogleCallback(Request $request)
    {
        $client = new Client();
        $client->setAuthConfig(storage_path('app/client_secret.json'));
        $client->setRedirectUri(route('google.auth.callback'));
        $client->addScope(Gmail::GMAIL_COMPOSE);

        if ($request->has('code')) {
            $client->fetchAccessTokenWithAuthCode($request->get('code'));
            $accessToken = $client->getAccessToken();

            // Store the access token in the session or database for future use

            // Perform further actions like sending emails using the access token

            // Redirect or show a success message
        } else {
            // Handle error case
        }
    }


    public function sendTestEmail()
    {

        return $this->sendTestMailV2();

        // $mailto = "ali_hassan2745@yahoo.com";
        // $subject = "This is a test email";

        // // a random hash will be necessary to send mixed content
        // $separator = md5(time());

        // // carriage return type (we use a PHP end of line constant)
        // $eol = PHP_EOL;

        // // main header (multipart mandatory)
        // $headers = "From: Go KC Quick Silver <info@gokcquicksilver.com>" ;
        // $headers .= "MIME-Version: 1.0" ;
        // $headers .= "Content-Type: multipart/alternative; boundary=\"" . $separator . "\""  ;
        // $headers .= "Content-Transfer-Encoding: 7bit" ;
        // $headers .= "This is a MIME encoded message."  ;

        // // message
        // $message = 'test email';

        // $headers .= "--" . $separator ;
        // $headers .= "Content-Type: text/html; charset=\"iso-8859-1\"" ;
        // $headers .= "Content-Transfer-Encoding: 8bit"  ;
        // $headers .= $message  ;

        // //SEND Mail
        // if (mail($mailto, $subject, "", $headers)) {
        //     echo "mail send ... OK"; // or use booleans here
        // } else {
        //     echo "mail send ... ERROR!";
        // }
    }

    public function sendTestMailV2(){
        $address = 'malikawaisj670@gmial.com';
        $name = 'Iftikhar Ali';
        $subject = 'Reservation Confirmation [NO-REPLY]';

        # MIME BOUNDARY
        $mime_boundary = "----www.gokcquicksilver.com----" . md5(time());

        $sender_name = 'Go KC Quick Silver';
        $from = 'info@gokcquicksilver.com';

        # MAIL HEADERS
        $headers = "From: $sender_name <$from>\r\n";
        $headers .= "Reply-To: $sender_name <$from>\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: multipart/alternative; boundary=\"$mime_boundary\"\r\n";
        // You may need additional headers like 'Date' and 'Subject'

        # EMAIL BODY
        $message = "Your reservation has been confirmed."; // This is a simple text message

        try {
            // Send Email
            mail($address, $subject, $message, $headers);

            // Alternatively, you can use Laravel's Mail facade
            // Mail::to($address)
            //     ->send($message);

            return response()->json(['Message' => 'Test email sent'], 200);
        } catch (Exception $ex) {
            return response()->json(['error' => $ex->getMessage()], 401);
        }


        // $address = 'mriftikhar@gmail.com';
        // $name = 'Iftikhar Ali';
        // $subject = 'Reservation Confirmation [NO-REPLY]';

        // # -=-=-=- MIME BOUNDARY
        // $mime_boundary = "----www.gokcquicksilver.com----" . md5(time());

        // $sender_name = 'Go KC Quick Silver';
        // $from = 'info@gokcquicksilver.com';

        // # -=-=-=- MAIL HEADERS
        // // $headers = "From: $sender_name <$from>\n";

        // $headers = "MIME-Version: 1.0\n";
        // $headers .= "Content-Type: multipart/alternative; boundary=\"$mime_boundary\"\n";
        // try{
        //     //$obj = new ReservationConfirmation("Testing email");

        //     Mail::to($address)
        //      ->send("Your reservation has been");
        //     return response()->json(['Message'=>'Test email sent', "Your reservation has been"],200);
        // }catch (Exception $ex){
        //     return response()->json(['error' => $ex->getMessage()], 401);
        // }

    }

    public function testEmail(){
        Mail::to('malikawaisj670@gmail.com')->send(new MailHandler(
            'TEST EMAIL',
            "Reservation #"
        ));
        // Mail::to('malikawaisj670@gmail.com')->send(new MyTestEmail());
        return response()->json(['message'=>'SendSuccessfully']);
    }
}
