<?php

namespace App\Http\Controllers\admin\ZipCodes;

use stdClass;
use App\Models\Admin\City;
use App\Models\Admin\State;
use Illuminate\Http\Request;
use App\Models\Admin\ZipCode;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class ZipCodeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.managements.zip-codes.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $zip_code = new ZipCode();
            $zip_code->city_id = $request->city_id;
            $zip_code->zip_code = $request->zip_code;
            $zip_code->save();

            return response()->json(['message' => 'Zip Code save successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $obj = new stdClass();

            $zip_code = ZipCode::with('city.state.country')->findOrFail($id);

            $obj->zip_code = $zip_code;

            return response()->json($obj);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $zip_code = ZipCode::findOrFail($id);
            $zip_code->city_id = $request->city_id;
            $zip_code->zip_code = $request->zip_code;

            $zip_code->save();

            return response()->json(['message' => 'Zip Code updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getCities($stateId)
    {
        try {
            $obj = new stdClass();
            $obj->allCities = City::select('id', 'name')->where('state_id', $stateId)->where('is_active', 1)->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getZipCodes($cityId)
    {
        try {
            $obj = new stdClass();
            $obj->allZipCodes = ZipCode::select('id', 'zip_code')->where('city_id', $cityId)->where('is_active', 1)->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getData($cityId)
    {
        try {
            $obj = new stdClass();

            $data = ZipCode::select('id', 'zip_code', 'city_id', 'is_active', 'is_reserved')
            ->with(['city' => function ($q) {
                $q->select('id', 'name');
            }])->where('city_id', $cityId)->orderby('zip_code', 'ASC')->get();

            $obj->data = $data;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    // Check name
    public function checkInputField(Request $request)
    {
        try {

            if (ZipCode::where('zip_code', $request->zip_code)->exists()) {
                return response()->json(['isAvailable' => false]);
            } else {
                return response()->json(['isAvailable' => true]);
            }

        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getFormData()
    {
        try {
            $obj = new stdClass();
            $obj->allStates = State::select('id', 'name')->where('is_active', 1)->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsActive(Request $request, $id)
    {
        try {
            ZipCode::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Zip Code status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsReserved(Request $request, $id)
    {
        try {
            ZipCode::whereId($id)->update([
                'is_reserved' => $request->status
            ]);

            return response()->json(['message' => 'Zip Code Reservation status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getExportedData(Request $request){
        try {
        //   dd($request->all());
            $cityId = $request->cityID;
            $zipCodes = $request->zip_codes;

            // Ensure that 'city_name' is an array
            if (!is_array($zipCodes)) {
                return response()->json(['message' => 'Invalid Zip Code'], 400);
            }

            foreach ($zipCodes as $zipCode) {

                $existingRecord = ZipCode::where('city_id', $cityId)
                                ->where('zip_code', $zipCode)
                                ->first();

                if(!$existingRecord){
                        $zip_code_data = new ZipCode();

                        $zip_code_data->city_id = $cityId;
                        $zip_code_data->zip_code = $zipCode;

                        $zip_code_data->save();
                    }
                }
            return response()->json(['message' => 'Zip Codes stored successfully'], 200);
        } catch (\Exception $e) {
            return response()->json(['message' => 'Error storing data: ' . $e->getMessage()], 500);
        }

    }
}
