<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Models\Admin\Vehicle;
use App\Models\Admin\VehicleMake;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\Admin\CitiesServicesSettings;
use Illuminate\Support\Facades\Log;

class VehiclesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.vehicles.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            DB::beginTransaction();

            $vehicle = new Vehicle();

            $vehicle->user_id = Auth::id();
            $vehicle->vehicles_type = $request->vehicles_type;
            $vehicle->passengers_capacity = $request->passengers_capacity;
            $vehicle->luggage_capacity = $request->luggage_capacity;

            $vehicle->is_shared = $request->is_shared;
            $vehicle->is_schedule = $request->is_schedule;

            $vehicle->save();

            $vehicleImage = null;

            if ($request->file('vehicle_image')) {
                $vehicleImage =  $vehicle->id . '_vehicle_image.' . pathinfo($request->file('vehicle_image')
                    ->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('vehicle_image')->storeAs('vehicle_images', $vehicleImage, 'public');
            }

            Vehicle::where('id', $vehicle->id)->update([
                'vehicle_image' =>  $vehicleImage,
            ]);

            DB::commit();
            return response()->json(['message' => 'Vehicle added successfully'], 201);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Vehicle  $carModel
     * @return \Illuminate\Http\Response
     */
    public function show(Vehicle $carModel)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Vehicle  $carModel
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            // car model
            $vehicles = Vehicle::whereId($id)->first();

            return response()->json($vehicles, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Vehicle  $carModel
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            DB::beginTransaction();

            $vehicle = Vehicle::findOrFail($id);

            $vehicle->vehicles_type = $request->vehicles_type;
            $vehicle->passengers_capacity = $request->passengers_capacity;
            $vehicle->luggage_capacity = $request->luggage_capacity;

            $vehicle->is_shared = $request->is_shared;

            $cityServiceSettingsAvailable = CitiesServicesSettings::where('city_id', 5964)
                ->where('service_id', 1)
                ->first();

            // dd($cityServiceSettingsAvailable['services']['services'][0]['millage_service']['additional_millage_charges']);
            // $cityServiceSettingsAvailable = CitiesServicesSettings::select('id', 'services')->pluck('services');

            // if ($vehicle->is_shared == false) {

            //     $servicesArray = $cityServiceSettingsAvailable->services;

            //     // dd($servicesArray['services']['0']);

            //     foreach ($servicesArray['services'] as $services){

            //         // dd($services['millage_service']['additional_millage_charges']);
            //         foreach($services['millage_service']['additional_millage_charges'] as $service){
            //             if($service['id'] == 9){
            //                 $service['is_charge'] = false;
            //             }
            //         }

            //     }

            //     $cityServiceSettingsAvailable->services = $servicesArray;

            //     $cityServiceSettingsAvailable->save();

            //     dd($cityServiceSettingsAvailable);
            // }


            // dd('outside');

            $vehicle->is_schedule = $request->is_schedule;

            $vehicle->save();



            if ($request->file('vehicle_image')) {
                $vehicleImage = $request->file('vehicle_image');
                $vehicleImage =  $vehicle->id . '_vehicle_image.' . pathinfo($request->file('vehicle_image')
                    ->getClientOriginalName(), PATHINFO_EXTENSION);
                $request->file('vehicle_image')->storeAs('vehicle_images', $vehicleImage, 'public');
                Vehicle::where('id', $vehicle->id)->update([
                    'vehicle_image' =>  $vehicleImage,
                ]);
            }



            DB::commit();
            return response()->json(['message' => 'Vehicle updated successfully'], 200);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Vehicle  $carModel
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            CitiesServicesSettings::select('id', 'city_id', 'service_id', 'services')
                ->chunk(100, function ($cityServiceSettings, $id) {
                    foreach ($cityServiceSettings as $setting) {
                        $services = $setting->services; // Decode JSON to array

                        if (isset($services['services'])) {
                            foreach ($services['services'] as $key => $service) { // Use reference to modify the original array

                                if ((int)$service['id'] === (int)$id) {
                                    $array_deleted[] = $service['id'];
                                    unset($services['services'][$key]);
                                }
                                $services['services'] = array_values($services['services']);
                            }
                        }

                        // Encode the modified array back to JSON and save it
                        $setting->services = $services;
                        $setting->save();
                    }
                });
            $vehicle = Vehicle::findOrFail($id);
            $vehicle->delete();


            return response()->json(['message' => 'Successfully deleted!'], 200);
        } catch (\Exception $exception) {
            dd($exception->getMessage());
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function updateIsActive(Request $request, $id)
    {
        try {
            Vehicle::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Vehicle status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function removeVehicle($id)
    {
        return $this->destroy($id);
    }

    public function getVehicleList()
    {
        try {
            $vehicles = Vehicle::select('id', 'vehicle_image', 'vehicles_type', 'passengers_capacity', 'luggage_capacity', 'is_shared',  'is_schedule')
                ->orderBy('vehicles_type', 'ASC')
                ->get();
            return response()->json($vehicles, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
