<?php

namespace App\Http\Controllers\Admin;

use stdClass;

use Illuminate\Http\Request;
use App\Models\Admin\VehiclePart;
use App\Http\Controllers\Controller;

class VehiclePartController extends Controller
{
    public function index()
    {
        // $parts = VehiclePart::all();

        return view('parts.index');
    }

    public function create()
    {
        return view('parts.create');
    }

    public function store(Request $request)
    {
        // dd($request->all());
        try{
            $part = new VehiclePart();

            $part->part_name = $request->part_name;

            $part->save();

            return response()->json(['message' => 'Vehicle Part added successfully'], 201);

        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        try{
            $obj = new stdClass();

            $vehicle_part = VehiclePart::findOrFail($id);

            $obj->vehicle_part = $vehicle_part;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function update(Request $request, $id)
    {
        try{
            $part = VehiclePart::findOrFail($id);

            $part->part_name = $request->part_name;

            $part->save();

            return response()->json(['message' => 'Part Name updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function destroy($id)
    {
     //
    }
     // get data
    public function getServerData()
    {
        try {
            $data = VehiclePart::select('id', 'part_name','is_active')
            ->orderBy('part_name', 'asc')
            ->get();

            return response()->json($data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsActive(Request $request, $id)
    {
        try {
            VehiclePart::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Vehicle part status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
