<?php

namespace App\Http\Controllers\Admin;

use stdClass;
use App\Models\Admin\Driver;
use Illuminate\Http\Request;
use App\Models\Admin\Vehicle;
use App\Models\Admin\Employee;
use App\Models\Admin\UserGroup;
use App\Models\Admin\ActivityLog;
use App\Models\Admin\VehicleMake;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\Admin\VehicleMillageCondition;

class VehicleMakeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $vehicleMake = VehicleMake::select('id','make' ,'name', 'status', 'is_active')->orderby('name', 'ASC')->get();
        // dd($vehicleMake);
        return view('admin.vehicle-make.index', [
            'vehicleMake' => $vehicleMake
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            DB::beginTransaction();
            // dd($request->all());
            $vehicle_make = new VehicleMake();

            $vehicle_make->user_id = Auth::id();
            $vehicle_make->name = $request->name;
            $vehicle_make->make = $request->make;
            $vehicle_make->save();


            DB::commit();
            return response()->json(['message' => 'Vehicle added successfully'], 201);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\VehicleMake  $carType
     * @return \Illuminate\Http\Response
     */
    public function show(VehicleMake $carType)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\VehicleMake  $carType
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $obj = new stdClass();

            $vehicle_make = VehicleMake::findOrFail($id);

            $obj->vehicle_make = $vehicle_make;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\VehicleMake  $carType
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            DB::beginTransaction();

            $vehicle_make = VehicleMake::findOrFail($id);
            $vehicle_make->name = $request->name;
            $vehicle_make->make = $request->make;

            $vehicle_make->save();


            DB::commit();
            return response()->json(['message' => 'Car Type updated successfully'], 200);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\VehicleMake  $carType
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $vehicleMake = VehicleMake::findOrFail($id);
        $vehicleMake->delete();
        return response()->json(['message' => 'Vehicle Make deleted successfully']);
    }

    // public function getFormData()
    // {
    //     try {
    //         $obj = new stdClass();
    //         $obj->allVehicleTypes = Vehicle::select('id', 'vehicles_type')->where('is_active', 1)->get();
    //         // dd($obj);
    //         return response()->json($obj, 200);
    //     } catch (\Exception $exception) {
    //         return response()->json(['error' => $exception->getMessage()], 500);
    //     }
    // }

    public function updateIsActive(Request $request, $id)
    {
        try {
            VehicleMake::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Vehicle status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getVehicleActivityLog($vehicleMakeId){
        try {
            // dd($driverId);
            $obj = new stdClass();

            $obj->activity = ActivityLog::where('vehicle_id', $vehicleMakeId)->orderBy('id', 'desc')->get();

            $userId = ActivityLog::where('vehicle_id', $vehicleMakeId)
                    ->where('role_id', '<>', 2)
                    ->select('user_id')
                    ->distinct()
                    ->get();
                // Assuming $userId is the result obtained from the previous query
                $userIds = $userId->pluck('user_id');
                // Retrieve names from the Employee table for the selected user IDs
                $obj->user = $userIds ? Employee::whereIn('user_id', $userIds)->select('id','user_id','first_name','last_name')->get(): null;

                $driverId = ActivityLog::where('vehicle_id', $vehicleMakeId)
                ->where('role_id',2)
                ->select('user_id')
                ->distinct()
                ->get();

                $driverIds = $driverId->pluck('user_id');

                $obj->driver = $driverIds ? Driver::whereIn('id', $driverIds)->select('id','user_id','first_name','last_name')->get() : null;
                $obj->roles=UserGroup::where('id','!=' , 2)->select('id','name')->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }

    }

    public function importData(Request $request)
    {
       $insertedCount = 0;
        DB::beginTransaction();
        try {

            $data = $request->all();
            $insertData = [];
            foreach ($data as $row) {
                // Map the Excel sheet data to the database columns
                if(!empty('Vehicle Model') && !empty($row['Vehicle Make'])){
                 $insertData[] = [
                    'user_id' => Auth::id(),
                    'name' => $row['Vehicle Model'] ?? null,
                    'make' => $row['Vehicle Make'] ?? null,
                ];
                 $insertedCount++;

               }
            }
            // Batch insert
            if (!empty($insertData)) {
                VehicleMake::insert($insertData);
            }

            // Batch update (use a package or raw queries for this)

            DB::commit();
            return response()->json([
                'message' => 'Vehicle Make/Model imported successfully',
                'inserted_count' => $insertedCount
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['error' => 'Error importing vehicle make/model', 'message' => $e->getMessage()], 500);
        }
    }

}
