<?php

namespace App\Http\Controllers\Admin\TravellerTypes;

use stdClass;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Admin\TravellerTypes;
use Illuminate\Support\Facades\Auth;
use App\Models\Admin\CitiesServicesSettings;

class TravellerTypesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.settings.traveller-types.index');
    }

    public function getAll()
    {

        try {
            $data = TravellerTypes::select('id', 'name', 'count')->where('is_active', 1)
                ->get();
            return response()->json($data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {

            TravellerTypes::create($request->all());

            return response()->json(['message' => 'Traveller Type saved successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $obj = new stdClass();

            $traveller_types = TravellerTypes::findOrFail($id);

            $obj->traveller_types = $traveller_types;

            return response()->json($obj);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $traveller_types = TravellerTypes::findOrFail($id);

            $traveller_types->fill($request->all())->save();

            return response()->json(['message' => 'Traveller Type updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {

            CitiesServicesSettings::select('id', 'city_id', 'service_id', 'services')
                ->chunk(100, function ($cityServiceSettings,$id) {
                    foreach ($cityServiceSettings as $setting) {
                        $services = $setting->services; // Decode JSON to array

                        if (isset($services['services'])) {
                            foreach ($services['services'] as &$service) { // Use reference to modify the original array
                                if (isset($service['millage_service']['traveller_types_charges'])) {
                                    foreach ($service['millage_service']['traveller_types_charges'] as $key => $charges) {

                                        if ((int)$charges['id'] === (int)$id) {
                                            $array_deleted[] = $charges;
                                            unset($service['millage_service']['traveller_types_charges'][$key]);
                                        }
                                    }
                                    // Re-index the array to prevent JSON array gaps
                                    $service['millage_service']['traveller_types_charges'] = array_values($service['millage_service']['traveller_types_charges']);
                                }

                                // Remove from Hourly Service As well
                                if (isset($service['hourly_service']['traveller_types_charges'])) {
                                    foreach ($service['hourly_service']['traveller_types_charges'] as $key => $charges) {

                                        if ((int)$charges['id'] === (int)$id) {
                                            $array_deleted[] = $charges;
                                            unset($service['hourly_service']['traveller_types_charges'][$key]);
                                        }
                                    }
                                    // Re-index the array to prevent JSON array gaps
                                    $service['hourly_service']['traveller_types_charges'] = array_values($service['hourly_service']['traveller_types_charges']);
                                }
                            }
                        }

                        // Encode the modified array back to JSON and save it
                        $setting->services = $services;
                        $setting->save();
                    }
                });

            // $cityServiceSettings = CitiesServicesSettings::select('id', 'city_id', 'service_id', 'services')
            // ->get();
            // // dd($id);
            // $array_deleted = [];
            // if ($cityServiceSettings) {
            //     foreach ($cityServiceSettings as $cityService) {
            //         $services = $cityService->services; // Decode JSON to array

            //         if (isset($services['services'])) {
            //             foreach ($services['services'] as &$service) { // Use reference to modify the original array
            //                 if (isset($service['millage_service']['traveller_types_charges'])) {
            //                     foreach ($service['millage_service']['traveller_types_charges'] as $key => $charges) {

            //                         if ((int)$charges['id'] === (int)$id) {
            //                             $array_deleted[] = $charges;
            //                             unset($service['millage_service']['traveller_types_charges'][$key]);
            //                         }
            //                     }
            //                     // Re-index the array to prevent JSON array gaps
            //                     $service['millage_service']['traveller_types_charges'] = array_values($service['millage_service']['traveller_types_charges']);
            //                 }

            //                 // Remove from Hourly Service As well
            //                 if (isset($service['hourly_service']['traveller_types_charges'])) {
            //                     foreach ($service['hourly_service']['traveller_types_charges'] as $key => $charges) {

            //                         if ((int)$charges['id'] === (int)$id) {
            //                             $array_deleted[] = $charges;
            //                             unset($service['hourly_service']['traveller_types_charges'][$key]);
            //                         }
            //                     }
            //                     // Re-index the array to prevent JSON array gaps
            //                     $service['hourly_service']['traveller_types_charges'] = array_values($service['hourly_service']['traveller_types_charges']);
            //                 }
            //             }
            //         }

            //         // Encode the modified array back to JSON and save it
            //         $cityService->services = $services;
            //         $cityService->save();
            //     }
            // }

            $charges = TravellerTypes::findOrFail($id);
            $charges->delete();



            return response()->json(['message' => 'Successfully deleted'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getData()
    {
        try {
            $data = TravellerTypes::select('id', 'name', 'is_active')
                ->orderby('name', 'ASC')->get();

            return response()->json($data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsActive(Request $request, $id)
    {
        try {
            TravellerTypes::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Traveller Type status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function remove($id) {}
}
