<?php

namespace App\Http\Controllers\Admin\TimelyAdditionalCharges;

use stdClass;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\Admin\CitiesServicesSettings;
use App\Models\Admin\TimelyAdditionalCharges;

class TimelyAdditionalChargesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.managements.timely-additional-charges.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {

            TimelyAdditionalCharges::create($request->all());

            return response()->json(['message' => 'Timely Additional Charges saved successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $obj = new stdClass();

            $timely_additional_charges = TimelyAdditionalCharges::findOrFail($id);

            $obj->timely_additional_charges = $timely_additional_charges;

            return response()->json($obj);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {

            // $index = $id - 1;

            // $timelyMillageCharges = CitiesServicesSettings::selectRaw("json_extract(services, '$.services[0].millage_service.timely_millage_charges[$index].id') as JSON")
            // ->get();

            // $array = array();

            // foreach ($timelyMillageCharges as $timelyMillageCharge) {
            //     if ($timelyMillageCharge['JSON']) {
            //         $array[] = $timelyMillageCharge['JSON'];
            //     }
            // }

            // dd($array);

            // dd($request->time_in, $cityServices[0]['JSON']);



            $timely_additional_charges = TimelyAdditionalCharges::findOrFail($id);

            $timely_additional_charges->fill($request->all())->save();

            return response()->json(['message' => 'Timely Additional Charges updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {

            CitiesServicesSettings::select('id', 'city_id', 'service_id', 'services')
                ->chunk(100, function ($cityServiceSettings, $id) {
                    foreach ($cityServiceSettings as $setting) {
                        $services = $setting->services; // Decode JSON to array

                        if (isset($services['services'])) {
                            foreach ($services['services'] as &$service) { // Use reference to modify the original array
                                if (isset($service['millage_service']['timely_millage_charges'])) {
                                    foreach ($service['millage_service']['timely_millage_charges'] as $key => $charges) {

                                        if ((int)$charges['id'] === (int)$id) {
                                            $array_deleted[] = $charges;
                                            unset($service['millage_service']['timely_millage_charges'][$key]);
                                        }
                                    }
                                    // Re-index the array to prevent JSON array gaps
                                    $service['millage_service']['timely_millage_charges'] = array_values($service['millage_service']['timely_millage_charges']);
                                }

                                // Remove from Hourly Service As well
                                if (isset($service['hourly_service']['timely_hourly_charges'])) {
                                    foreach ($service['hourly_service']['timely_hourly_charges'] as $key => $charges) {

                                        if ((int)$charges['id'] === (int)$id) {
                                            $array_deleted[] = $charges;
                                            unset($service['hourly_service']['timely_hourly_charges'][$key]);
                                        }
                                    }
                                    // Re-index the array to prevent JSON array gaps
                                    $service['hourly_service']['timely_hourly_charges'] = array_values($service['hourly_service']['timely_hourly_charges']);
                                }
                            }
                        }

                        // Encode the modified array back to JSON and save it
                        $setting->services = $services;
                        $setting->save();
                    }
                });

            // $cityServiceSettings = CitiesServicesSettings::select('id', 'city_id', 'service_id', 'services')
            //     ->get();
            // // dd($id);
            // $array_deleted = [];
            // if ($cityServiceSettings) {
            //     foreach ($cityServiceSettings as $cityService) {
            //         $services = $cityService->services; // Decode JSON to array

            //         if (isset($services['services'])) {
            //             foreach ($services['services'] as &$service) { // Use reference to modify the original array
            //                 if (isset($service['millage_service']['timely_millage_charges'])) {
            //                     foreach ($service['millage_service']['timely_millage_charges'] as $key => $charges) {

            //                         if ((int)$charges['id'] === (int)$id) {
            //                             $array_deleted[] = $charges;
            //                             unset($service['millage_service']['timely_millage_charges'][$key]);
            //                         }
            //                     }
            //                     // Re-index the array to prevent JSON array gaps
            //                     $service['millage_service']['timely_millage_charges'] = array_values($service['millage_service']['timely_millage_charges']);
            //                 }

            //                 // Remove from Hourly Service As well
            //                 if (isset($service['hourly_service']['timely_hourly_charges'])) {
            //                     foreach ($service['hourly_service']['timely_hourly_charges'] as $key => $charges) {

            //                         if ((int)$charges['id'] === (int)$id) {
            //                             $array_deleted[] = $charges;
            //                             unset($service['hourly_service']['timely_hourly_charges'][$key]);
            //                         }
            //                     }
            //                     // Re-index the array to prevent JSON array gaps
            //                     $service['hourly_service']['timely_hourly_charges'] = array_values($service['hourly_service']['timely_hourly_charges']);
            //                 }
            //             }
            //         }

            //         // Encode the modified array back to JSON and save it
            //         $cityService->services = $services;
            //         $cityService->save();
            //     }
            // }

            $charges = TimelyAdditionalCharges::findOrFail($id);
            $charges->delete();



            return response()->json(['message' => 'Successfully deleted'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    // get data
    public function getData()
    {
        try {
            $data = TimelyAdditionalCharges::select('id', 'time_in', 'time_out', 'operator', 'is_active')
                ->orderby('time_in', 'ASC')->get();

            return response()->json($data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsActive(Request $request, $id)
    {
        try {
            TimelyAdditionalCharges::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Timely Additional Charges status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function removeCharges($id) {}
}
