<?php

namespace App\Http\Controllers\Admin\States;

use stdClass;
use App\Models\Admin\City;
use App\Models\Admin\State;
use Illuminate\Http\Request;
use App\Models\Admin\Country;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class StatesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.managements.states.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $state = new State();
            $state->country_id = $request->country_id;
            $state->name = $request->name;
            $state->state_code = $request->state_code;
            $state->save();

            return response()->json(['message' => 'State save successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $state = State::findOrFail($id);

            return response()->json($state);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $state = State::findOrFail($id);
            $state->country_id = $request->country_id;
            $state->state_code = $request->state_code;
            $state->name = $request->name;
            $state->save();

            return response()->json(['message' => 'State updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    // get Data
    public function getData($countryId)
    {
        try {
            $data = State::select('id', 'name', 'state_code', 'country_id', 'is_active', 'is_reserved')
                ->with(['country' => function($q){
                    $q->select('id', 'name')->where('is_active', 1);
                }])->where('country_id', $countryId)->orderby('name', 'ASC')->get();

            return response()->json($data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    // Check name
    public function checkInputField(Request $request)
    {
        try {
            if($request->name){
                if (State::whereName($request->name)->exists()) {
                    return response()->json(['isAvailable' => false]);
                } else {
                    return response()->json(['isAvailable' => true]);
                }
            }

            if($request->state_code){
                if (State::where('state_code', $request->state_code)->exists()) {
                    return response()->json(['isAvailable' => false]);
                } else {
                    return response()->json(['isAvailable' => true]);
                }
            }
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsActive(Request $request, $id)
    {
        try {
            // Update the state
            State::whereId($id)->update([
                'is_active' => $request->status
            ]);

            // Update the cities associated with the state
            $cities = City::where('state_id', $id)->get();

            foreach ($cities as $city) {
                $city->update([
                    'is_active' => $request->status,
                ]);
            }

            return response()->json(['message' => 'State and associated cities status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }


    public function updateIsReserved(Request $request, $id)
    {
        try {
            State::whereId($id)->update([
                'is_reserved' => $request->status
            ]);

            return response()->json(['message' => 'State Reservation status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }


    public function getExportedData(Request $request)
    {
        // dd($request->all());
        try {
            $countryId = $request->countryID;
            $states = $request->States;

            // Ensure that 'airports' is an array
            if (!is_array($states)) {
                return response()->json(['message' => 'Invalid State Data'], 400);
            }

            foreach ($states as $statesData) {
                $stateName = $statesData['StateName'];
                $stateCode = $statesData['StateCode'];

                $existingRecord = State::where('country_id', $countryId)
                    ->where('name', $stateName) // Check if an airport with the same name already exists
                    ->first();

                if (!$existingRecord) {
                    $state = new State();
                    $state->country_id = $countryId;
                    $state->name = $stateName;
                    $state->state_code = $stateCode;
                    $state->save();
                }
            }

            return response()->json(['message' => 'States stored successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
    }
    }
}
