<?php

namespace App\Http\Controllers\Admin\Sites;

use stdClass;
use App\Models\Admin\Site;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class SitesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.managements.sites.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            DB::beginTransaction();
            $sites = new Site();

            $sites->site_name = $request->site_name;
            $sites->code = $request->code;
            $sites->site_url = $request->site_url;
            $sites->save();

            // dd($sites);

            $siteId = Site::where('site_name',$request->site_name)->pluck('id')->first();

            // dd($siteId);

            if ($siteId) {
                $md5data = md5($siteId);
                $sites->token = $md5data;
                $sites->save(); // Save the updated token value to the database
            }


            if ($request->file('image')) {
                $requestImage = $request->file('image');
                $imageName = strtolower($siteId .'_'. str_replace(' ', '_', $requestImage->getClientOriginalName()));
                $destinationPath = storage_path('app/public/site_images');
                $siteImage = $imageName;

                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0777, true);
                }
                $requestImage->move($destinationPath, $imageName);
                Site::where('id',$siteId)->update([
                    'image' => $siteImage
                ]);
            }
            DB::commit();
            return response()->json(['message' => 'Successfully created', 'token' => $md5data], 200);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $obj = new stdClass();

            $site = Site::findOrFail($id);

            $obj->site = $site;

            return response()->json($obj);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {

            DB::beginTransaction();
            $site = Site::findOrFail($id);

            $site->site_name = $request->site_name;
            $site->code = $request->code;
            $site->site_url = $request->site_url;
            $site->save();

            if ($request->file('image')) {
                $requestImage = $request->file('image');
                $imageName = strtolower($site->id .'_'. str_replace(' ', '_', $requestImage->getClientOriginalName()));
                $destinationPath = storage_path('app/public/site_images');
                $siteImage = $imageName;

                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0777, true);
                }
                $requestImage->move($destinationPath, $imageName);
                Site::where('id',$id)->update([
                    'image' => $siteImage
                ]);
            }

            DB::commit();

            return response()->json(['message' => 'Site updated successfully'], 200);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getData()
    {
        try {
            $data = Site::select('id', 'site_name', 'code', 'site_url' , 'secret_key', 'token' , 'status' , 'is_active','image')->where('is_active', 1)->get();

            return response()->json($data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsActive(Request $request, $id)
    {
        try {
            Site::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Site status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
