<?php

namespace App\Http\Controllers\Admin;

use mysqli;
use stdClass;

use Carbon\Carbon;
use App\Models\Admin\City;
use App\Models\Admin\State;
use Illuminate\Http\Request;
use App\Models\Admin\Vehicle;
use App\Models\Admin\Services;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\Admin\ServicesVehicles;
use App\Models\Admin\ZipCodesVehicles;
use App\Models\Admin\CitiesServicesSettings;

class ServicesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $services = Services::select('id', 'service_name', 'status', 'is_active')->orderby('service_name', 'ASC')->get();

        return view('admin.services.index', [
            'services' => $services
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{
            DB::beginTransaction();

            $service = new Services();

            $service->user_id = Auth::id();
            $service->service_name = $request->service_name;

            $service->save();
            DB::commit();
            return response()->json(['message' => 'Service added successfully'], 201);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Services  $services
     * @return \Illuminate\Http\Response
     */
    public function show(Services $services)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Services  $services
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            // coupon
            $service = Services::whereId($id)->first();

            return response()->json($service, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Services  $services
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            DB::beginTransaction();

            $service = Services::findOrFail($id);

            $service->service_name = $request->service_name;

            $service->save();

            DB::commit();
            return response()->json(['message' => 'Service updated successfully'], 200);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Services  $services
     * @return \Illuminate\Http\Response
     */
    public function destroy(Services $services)
    {
        //
    }

    public function updateServices(Request $request, $cityId){

        // dd($request->all(), $cityId);

        try {
            if($request->cities_services == null) {

                $city = City::findOrFail($cityId);

                $city->services = $request->services;
                // $city->reservation_time_limit = $request->reservation_time_limit;
                // $city->cancel_time_limit = $request->cancel_time_limit;

                $city->save();
            }
            else {
                $city = City::findOrFail($cityId);

                $city->services = $request->services;
                $city->reservation_time_limit = $request->reservation_time_limit;
                $city->cancel_time_limit = $request->cancel_time_limit;

                $city->save();

                foreach($request->cities_services as $city_id){
                    $city = City::findOrFail($city_id);

                    $city->services = $request->services;
                    $city->reservation_time_limit = $request->reservation_time_limit;
                    $city->cancel_time_limit = $request->cancel_time_limit;

                    $city->save();
                }
            }

        return response()->json(['message' => 'City updated with services successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    //add vehicle services with other cities
    public function addVehicleServices(Request $request){

        try {
            $cityServiceSettingsAvailable = CitiesServicesSettings::where('city_id', $request->city_id)->where('service_id', $request->service_type_id)->first();

            if($cityServiceSettingsAvailable == null){

                $cityServiceSetting = new CitiesServicesSettings();

                $cityServiceSetting->city_id = $request->city_id;
                $cityServiceSetting->service_id = $request->service_type_id;

                if($request->is_schedule){
                    $cityServiceSetting->schedule_services = $request->schedule_services;
                }
                else{
                    $cityServiceSetting->services = $request->services;
                }
                $cityServiceSetting->save();
            }
            else{

                $cityServiceSettingsAvailable->city_id = $request->city_id;
                $cityServiceSettingsAvailable->service_id = $request->service_type_id;

                if ($request->is_schedule) {
                    $cityServiceSettingsAvailable->schedule_services = $request->schedule_services;
                } else {
                    $cityServiceSettingsAvailable->services = $request->services;
                }
                $cityServiceSettingsAvailable->save();

            }

        return response()->json(['message' => 'City updated with services successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    //update vehicle services with other cities
    public function updateVehicleServices(Request $request, $id){
        try {
            $cityServices = CitiesServicesSettings::where('city_id', $request->city_id)->where('service_id', $request->service_type_id)->first();

            dd($cityServices);

            if ($request->is_schedule) {
                $cityServices->schedule_services = $request->schedule_services;
            } else {
                $cityServices->services = $request->services;
            }

            $cityServices->save();

            // else {
            //     $city = City::findOrFail($cityId);

            //     $city->services = $request->services;
            //     $city->reservation_time_limit = $request->reservation_time_limit;
            //     $city->cancel_time_limit = $request->cancel_time_limit;

            //     $city->save();

            //     foreach($request->cities_services as $city_id){
            //         $city = City::findOrFail($city_id);

            //         $city->services = $request->services;
            //         $city->reservation_time_limit = $request->reservation_time_limit;
            //         $city->cancel_time_limit = $request->cancel_time_limit;

            //         $city->save();
            //     }
            // }

        return response()->json(['message' => 'Services updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function editServices(Request $request){
        try {
            // Services Vehicles
            $city = City::select('services', 'schedule_services')->where('id',$request->city_id)->first();

            return response()->json($city, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }

    }

    public function getAllServices(){
        try {
            // Services Vehicles
            $allServices = Services::select('id', 'service_name', 'icon_class')->where('id','!=' , 4)->where('is_active', 1)->get();

            return response()->json($allServices, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }

    }

    public function updateIsActive(Request $request, $id)
    {
        try {
            Services::whereId($id)->update([
                'is_active' => $request->status
            ]);

            return response()->json(['message' => 'Service status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getFormData()
    {
        try {
            $obj = new stdClass();
            $obj->allServices = Services::select('id', 'service_name')->where('is_active', 1)->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getCityServicesSettings(Request $request){
        try {
            $obj = new stdClass();
            if($request->is_schedule){
                $obj->allCityServicesSettings = CitiesServicesSettings::select('id', 'city_id', 'service_id', 'schedule_services')
                    ->where('city_id', $request->city_id)
                    ->where('service_id', $request->service_type_id)
                    ->first();
            }
            else if (!$request->is_schedule) {
                $obj->allCityServicesSettings = CitiesServicesSettings::select('id', 'city_id', 'service_id', 'services')
                    ->where('city_id', $request->city_id)
                    ->where('service_id', $request->service_type_id)
                    ->first();
            }
            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function priceCalculator(){

        $millage = 100;

        $vehicle_type_id = 1;

        $cityId = 5964;

        $price = 0;

        $vehicle_services = City::select('services')->where('id', $cityId)->first();

        return $vehicle_services;

        foreach ($vehicle_services->services as $service){

            if($vehicle_type_id == $service['id']){

                $base_fare = 0;
                $base_millage = 0;

                foreach ($service['service_millage_pricing'] as $pricing){

                    if($pricing['condition'] == 'upto'){

                        $base_fare = $pricing['price'];
                        $base_millage = $pricing['millage'];

                        if ($millage <= $pricing['millage']){
                            $price =  $base_fare;
                        }
                    }
                    if($pricing['condition'] == 'between'){

                        if ($millage >= $pricing['millage'] && $millage <= $pricing['millage2']){
                            $millage_value = $millage - $base_millage;
                            $price =  $base_fare + $millage_value * $pricing['price'] ;
                        }
                    }
                    if($pricing['condition'] == 'greater_than'){

                        if ($millage > $pricing['millage']){

                            $price =  $base_fare+$millage*$pricing['price'];

                        }
                    }
                }
            }

            return $price;
        }
    }

    public function getCityServiceVehicles(Request $request)
    {
        try {

            $cityServiceSettings = CitiesServicesSettings::select('id', 'city_id', 'service_id', 'services')
            ->where('city_id', $request->city_id)
                ->where('service_id', $request->service_type_id)
                ->first();


            $services = [];
            $tempServices = [];

            if ($cityServiceSettings) {
                foreach ($cityServiceSettings->services['services'] as $service) {
                    if ($service['is_checked']) {
                        $tempCharges = [];
                        foreach ($service['millage_service']['additional_millage_charges'] as  $key => $charges) {
                            if (isset($charges['price']) && (@$charges['price'] > 0 ||  $charges['is_percentage'] > 0)) {
                                $tempCharges[] = $charges;
                            }
                        }
                        $service['millage_service']['additional_millage_charges'] =  $tempCharges;
                        //$service['millage_fare'] = $this->calculateMilageFareV2($tempCharges);
                        // unset($service['millage_service']);
                        // unset($service['hourly_service']);
                        // unset($service['zip_code_services']);

                        array_push($services, $service);
                    }
                }
            }

            if ($cityServiceSettings) {
                $tempServices['services']['reservation_hours'] =  $cityServiceSettings->services['reservation_hours'];
                $tempServices['services']['reservation_minutes'] =  $cityServiceSettings->services['reservation_minutes'];
                $tempServices['services']['cancel_hours'] =  $cityServiceSettings->services['cancel_hours'];
                $tempServices['services']['cancel_minute'] =  $cityServiceSettings->services['cancel_minute'];
                $tempServices['services']['wait_time_limit'] =  $cityServiceSettings->services['wait_time_limit'];
                $tempServices['services']['wait_time_charges'] =  $cityServiceSettings->services['wait_time_charges'];
                $tempServices['services']['change_all_charges'] =  $cityServiceSettings->services['change_all_charges'];
                $tempServices['services']['services'] =  $services;
            }


            return response()->json($tempServices, 200);

            //return response()->json($services, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    private function getStateCityByName($stateName, $cityName){

            if (isset($cityName) && isset($stateName)) {

                $state = State::select('id')->where('name', $stateName)->pluck('id')->first();

                $city = City::select('id', 'name', 'is_active')->where('state_id', $state)
                    ->where('name', $cityName)
                    ->first();

                return $city;
            } else {
                return false;
            }


    }

    public function getHourlyFareDetails(Request $request){
         $request = new Request(['city_id' => $city->id, 'service_type_id' => $reservationObj['service_type_id']]);
    }
    public function getReservationVehicleFares(Request $request){

        //$request = new Request(['cityName' => $reservation->reservation['pickup_location']['city'], 'stateName' => $reservation->reservation['pickup_location']['state']]);
        $reservationObj = $request->reservation;
        $isDepartureFlight = false;
        if($request['service_type_id'] == 1 && $reservationObj['flight_info']['flight_type'] === 'arrival'){
            $cityName = $reservationObj['dropoff_location']['city'];
            $stateName = $reservationObj['dropoff_location']['state'];

        }else{
            $cityName = $reservationObj['pickup_location']['city'];
            $stateName = $reservationObj['pickup_location']['state'];
            $isDepartureFlight = true;
        }

        try {

            $city = $this->getStateCityByName($stateName, $cityName);

            $request = new Request(['city_id' => $city->id, 'service_type_id' => $request['service_type_id']]);
            $returnData = $this->getCityServiceVehicles($request);
            $citySetting = json_decode($returnData->content(), true);

            foreach( $citySetting['services']['services'] as $index => $vehicle){


                $vehicleInfo = Vehicle::select('id', 'vehicles_type', 'vehicle_image', 'passengers_capacity', 'luggage_capacity', 'status', 'is_shared',  'is_schedule', 'is_active')->where('id', $vehicle['id'])->first();
                if($vehicleInfo){

                    //$vehicle['info'] = $vehicleInfo;
                    $vehicle['vehicles_type'] = $vehicleInfo['vehicles_type'];
                    $vehicle['vehicle_image'] = $vehicleInfo['vehicle_image'];
                    $vehicle['passengers_capacity'] = $vehicleInfo['passengers_capacity'];
                    $vehicle['luggage_capacity'] = $vehicleInfo['luggage_capacity'];
                    $vehicle['status'] = $vehicleInfo['status'];
                    $vehicle['is_shared'] = $vehicleInfo['is_shared'];
                    $vehicle['is_schedule'] = $vehicleInfo['is_schedule'];

                    $vehicle['milage_fare_detail'] = $this->calculateMilageFareV2($reservationObj, $vehicle['millage_service'],'millage', $isDepartureFlight);
                    $vehicle['milage_fare_detail']['departure_time_limit'] = ["pickup_hours"=> $vehicle['millage_service']['pickup_hours'], "pickup_minutes" => $vehicle['millage_service']['pickup_minutes']];
                   // if($vehicle['is_hourly']){
                    $vehicle['hourly_fare_detail'] = $this->calculateMilageFareV2($reservationObj, $vehicle['hourly_service'], 'hourly', $isDepartureFlight);
                    $vehicle['hourly_fare_detail']['departure_time_limit'] = ["pickup_hours" => $vehicle['hourly_service']['pickup_hours'], "pickup_minutes" => $vehicle['hourly_service']['pickup_minutes']];
                    $vehicle['hourly_fare_detail']['min_booking_hours'] = $vehicle['hourly_service']['min_booking_hours'] ?? 0;
                    $vehicle['hourly_fare_detail']['pricing'] = $vehicle['hourly_service']['pricing'];
                   // }
    
                    unset($vehicle['millage_service']);
                    unset($vehicle['hourly_service']);
                    unset($vehicle['zip_code_services']);
                    $vehicle['ride_type'] = ($request['service_type_id']==2)?'hourly': 'mileage';
                    $vehicles[] = $vehicle;
                }
            }

            return response()->json($vehicles, 200);
        } catch (\Exception $exception) {
            \Log::error('Error occurred: ' . $exception);
            return response()->json(['error' => $exception->getMessage()], 500);
        }

    }

    public function getFareDetails($reservation, $vehicle){

    }
    private function calculateMilageFareV2($reservation, $vehiclePriceSetting, $sType, $isDepartureFlight){

        $distance = $reservation['distance'];
        $hours = round($reservation['drop_off_hours']);
        $base_fare = 0;

        $totalTravellers = collect($reservation['travellers'])->sum('count');
        // Calculate the total count excluding objects where id = 1
        $totalCountExceptId1 = collect($reservation['travellers'])->reject(function ($item) {
            return $item['id'] === 1;
        })->sum('count');

        if ($sType === 'hourly') {
            $sTypeIndexForLoop = 'hourly';
            $hourOrDistance = $hours;
        } else {
            $sTypeIndexForLoop = 'millage';
            $hourOrDistance = $distance;
        }

        $minuetsForDepartureTimeLimit =  ($vehiclePriceSetting['pickup_hours']*60)+ $vehiclePriceSetting['pickup_minutes'];


        $request = new Request(['pricing' => $vehiclePriceSetting['pricing'], 'ride_type' =>$sType, 'hourOrDistance' => $hourOrDistance]);

        $price = $this->calculatePricingV2($request);
        $reservation_fare = ["base_fare" => round($price)];


        $additional_fare=[];
        foreach ($vehiclePriceSetting['additional_'. $sTypeIndexForLoop.'_charges'] as $additionalCharges) {
            // Addtional Stop Charges
            if( isset($additionalCharges['name']) && isset($additionalCharges['price']) )
            if($additionalCharges['id'] === 3){ // Additional Stops
                if(count($reservation['additional_stops'])){
                    $tempAmount = $this->getAdditionalChargesAmount($price, $additionalCharges);
                    $additional_fare[] = ["id" => $additionalCharges['id'], "name" => $additionalCharges['name'], "amount" => $tempAmount * count($reservation['additional_stops'])];
                }

            }elseif($additionalCharges['id'] === 9){// Additional Passengers
                $tempAmount = $this->getAdditionalChargesAmount($price, $additionalCharges);
                $additionalPassengers = ($totalTravellers - 1);
                $additional_fare[] = ["id" => $additionalCharges['id'], "name" => "" . $additionalPassengers . "-" .$additionalCharges['name'], "amount" => $additionalPassengers* $tempAmount];
            }else{
                $tempAmount = $this->getAdditionalChargesAmount($price, $additionalCharges);
                $additional_fare[] = ["id" => $additionalCharges['id'],"name" => $additionalCharges['name'], "amount" => $tempAmount ];
            }

        }

        $reservation_fareDiscount=[];
        foreach ($vehiclePriceSetting['traveller_types_charges'] as $travellerTypeDiscount) {

            if($travellerTypeDiscount['id'] != 1){
                $count = array_column(array_filter($reservation['travellers'], fn ($traveller) => $traveller['id'] === $travellerTypeDiscount['id']), 'count')[0] ?? null;
                if ($count !== null && $count > 0 && isset($travellerTypeDiscount['price'])) {
                    //$tempAmount = $this->getAdditionalChargesAmount($price, $travellerTypeDiscount);
                    $reservation_fareDiscount[] = ["id" => $travellerTypeDiscount['id'], "name" => ($count) . ' ' .  $travellerTypeDiscount['name'], "amount" => ($count) * $travellerTypeDiscount['price']];
                }
            }
        }
        $timeBaseCharges=[];
        foreach ($vehiclePriceSetting['timely_' . $sTypeIndexForLoop . '_charges'] as $timeBaseCharge) {

            if(isset($timeBaseCharge['price'])){
                $pickupDateTime = Carbon::parse($reservation['pickup_date'] . ' ' . $reservation['pickup_time']);
                if($isDepartureFlight && !$reservation['customer_picked_date_time']){
                    $pickupDateTime =  Carbon::parse($reservation['flight_info']['flight_date'] . ' ' . $reservation['flight_info']['flight_time'])->subMinutes($minuetsForDepartureTimeLimit);
                }
                $strPickupDateDate = $pickupDateTime->format('Y-m-d');
                //$pickupDateTime =  $pickupDateTime->format('Y-m-d h:i:s A');
    
                $timeIn = Carbon::parse($strPickupDateDate . ' ' . $timeBaseCharge['time_in']);
                $timeOut = Carbon::parse($strPickupDateDate . ' ' . $timeBaseCharge['time_out']);
                if($pickupDateTime->greaterThan($timeOut)){
                    $timeOut->addDay();
                }else{
                    $timeOut->subDay();
                }
                
                if($pickupDateTime->between($timeIn, $timeOut)){
                    $tempAmount = $this->getAdditionalChargesAmount($price, $timeBaseCharge);
                    $timeBaseCharges[] = [
                        "time_check" =>  $timeBaseCharge['time_in'] . ' - ' . $timeBaseCharge['time_out'], "amount" => $tempAmount];;
                }
                // $timeBaseCharges[] = [
                //     "time_check" =>  $pickupDateTime->format('Y-m-d h:i:s A') . ' = ' . ' - ' . $timeIn->format('Y-m-d h:i:s A') . ' - ' . $timeOut->format('Y-m-d h:i:s A'),
                //     "amount" => 10
                // ];;
            }
        }
        $reservation_fare['timely_charges'] = $timeBaseCharges;
        $reservation_fare['additional_charges'] = $additional_fare;
        $reservation_fare['discounts'] = $reservation_fareDiscount;

        //$reservation_fare[]['total_discounts'] = collect($reservation_fareDiscount)->sum('amount');

        return $reservation_fare;

    }

    public function calculatePricingV2(Request $request){
        $base_fare = 0;

        if ($request->ride_type === 'hourly') {
            $sTypeIndexForPrice = 'hours';
        } else {
            $sTypeIndexForPrice = 'millage';
        }

        foreach ($request->pricing as $pricing) {

            if ($pricing['condition'] == 'upto') {
                $uptoPrice = $pricing['price'];
                $uptoDistanceHour = $pricing[$sTypeIndexForPrice];
                if ($request->hourOrDistance) {
                    $base_fare =  $uptoPrice;
                }
            }
            if ($pricing['condition'] == 'between') {

                if ($request->hourOrDistance >= $pricing[$sTypeIndexForPrice] && $request->hourOrDistance >= $pricing[$sTypeIndexForPrice . '2']) {
                    $base_fare =  $base_fare + ($pricing[$sTypeIndexForPrice . '2'] - ($pricing[$sTypeIndexForPrice]-1)) * $pricing['price'];
                }
            }

            if ($pricing['condition'] == 'greater_than') {
                if ($request->hourOrDistance > $pricing[$sTypeIndexForPrice]) {
                    $base_fare =  $base_fare + ($request->hourOrDistance - $pricing[$sTypeIndexForPrice])  * $pricing['price'];
                }
            }
        }
        return $base_fare;
    }

    public function verifyReservationTimeLimit(Request $request){

        //$request = new Request(['city_id' => $city->id, 'service_type_id' => $request['service_type_id']]);
        //$returnData = $this->getReservationCity($request);
        $city = json_decode($this->getReservationCity($request)->content(), true);

        $cityServiceSettings = CitiesServicesSettings::select('id', 'city_id', 'service_id', 'services')
        ->where('city_id', $city['id'])
            ->where('service_id', $request->service_type_id)
            ->first();
        if(isset($cityServiceSettings->services)){

        $hours =  $cityServiceSettings->services['reservation_hours'];
        $minutes =  $cityServiceSettings->services['reservation_minutes'];
        $totalMinutes = ($hours * 60) + $minutes;

        $pickUpDateTime = Carbon::parse($request->reservation_date . ' ' . $request->reservation_time);
        $currentDateTime = Carbon::now();
        //$currentDateTime->setTimezone('America/Chicago');

        $minutesDifference = $currentDateTime->diffInMinutes($pickUpDateTime, false);
        if($minutesDifference > $totalMinutes || $totalMinutes == 0){
            $verfied = true;
            $message = 'Reservation is in time limit';
        }else{
            $verfied = false;
            $message = 'Your pickup date time must be greater than [' . $request->reservation_date . ' ' . $request->reservation_time.']';
        }

        $timely_charges = [];$priceSetting = null;$fare=[];$vehiclePriceSetting=[];
        if(isset($request->check_timely_charges)){
                $reservationInfo = $request->check_timely_charges['reservation'];
                $reservationInfo['pickup_date'] = $request->reservation_date;
                $reservationInfo['pickup_time'] = $request->reservation_time;
                 $selected_vehicle = $reservationInfo['selected_vehicle'];
                 $collection = collect($cityServiceSettings->services['services']);
                 $vehiclePriceSetting = $collection->first(function ($item) use ($selected_vehicle){
                     return isset($selected_vehicle['id']) && $item['id'] === $selected_vehicle['id'];
                 });
                 
                 if ($vehiclePriceSetting && isset($selected_vehicle['ride_type'])) {
                     $sType = $selected_vehicle['ride_type']=== 'mileage'? 'millage':'hourly';
                     $priceSetting = ($selected_vehicle['ride_type'] === 'mileage')? $vehiclePriceSetting['millage_service']: $vehiclePriceSetting['hourly_service'];
                     $isDepartureFlight = false;
                     $fare = $this->calculateMilageFareV2($reservationInfo, $priceSetting, $sType, $isDepartureFlight);
                     $timely_charges = $fare['timely_charges'];
                 }
        }

        return response()->json(
                [
                    "verified"=> $verfied,
                    "message"=>$message,
                    "differenceInMinutes"=> $minutesDifference,
                    "CurrentDateTime" => $currentDateTime->format('Y-m-d h:i:s A'),
                    "PickupDateTime" => $pickUpDateTime->format('Y-m-d h:i:s A'),
                    "limitInMinutes" => $totalMinutes,
                    "reservationCity" => $city,
                    "tz" => $currentDateTime->timezone,
                    "timely_charges" => $timely_charges
                ]
            , 200);
        }else{
             return response()->json(
                [
                    "verified"=> '',
                    "message"=>'No Service available',
                    "reservationCity" => $city
                ]
            , 200);

        }
    }
    private function getAdditionalChargesAmount($total, $objAdditionalCharge){

        if(isset($objAdditionalCharge['is_percentage']) && $objAdditionalCharge['is_percentage']){
            return round($total / 100 * $objAdditionalCharge['price']);
        } else {
            return $objAdditionalCharge['price'];
        }

    }

    public function getReservationCity(Request $request)
    {
        try {
             if($request['service_type_id'] == 1 && $request['flight_type'] === 'arrival'){
                $cityName = $request['dropoff_location']['city'];
                $stateName = $request['dropoff_location']['state'];
            }else{
                $cityName = $request['pickup_location']['city'];
                $stateName = $request['pickup_location']['state'];
            }

            $city = $this->getStateCityByName($stateName, $cityName);
            return response()->json($city, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

}
