<?php

namespace App\Http\Controllers\Admin\ScheduleServices;

use stdClass;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Models\Admin\Airline;
use App\Models\Admin\Vehicle;
use App\Models\Admin\OtherCharges;
use App\Http\Controllers\Controller;
use App\Models\Admin\TravellerTypes;
use App\Models\Admin\ScheduleService;
use App\Models\Admin\FlightDestination;
use App\Models\Admin\TimelyAdditionalCharges;

class ScheduleServicesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.managements.schedule-services.index');
    }

    public function iframeScheduleReservation()
    {
        return view('frontend.iframes.scheduleReservation');
    }


    public function scheduleReservationView($customer = null, $customerType = null)
    {
        // dd(Auth::id());
        return view('frontend.scheduleReservation.schedule-reservations', [
            'customer' => $customer,
        ]);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $schedule_service = new ScheduleService();
            $timings = $request->data['timings'];
            $filteredTimings = array_map(function ($timing) {
                $timing['additional_stops'] = array_filter($timing['additional_stops'], function ($stop) {
                    return !empty($stop['location']);
                });
                return $timing;
            }, $timings);

            $vehicle_capacity = Vehicle::select('id', 'passengers_capacity')->where('id', $request->data['vehicle_type_id'])->pluck('passengers_capacity')->first();

            $schedule_service->city_id = $request->city_id;
            $schedule_service->vehicle_type_id = $request->data['vehicle_type_id'];
            $schedule_service->shuttle_name = $request->data['shuttle_name'];

            //$vehicle_capacity got from the vehicles table
            $schedule_service->vehicle_capacity = $vehicle_capacity;

            $schedule_service->carry_bags_capacity = $request->data['carry_bags_capacity'];
            $schedule_service->check_in_bags_capacity = $request->data['check_in_bags_capacity'];
            $schedule_service->is_home_pickup = $request->data['is_home_pickup'];
            $schedule_service->is_home_drop_off = $request->data['is_home_drop_off'];
            $schedule_service->home_pickup_charges = $request->data['home_pickup_charges'];
            $schedule_service->home_drop_off_charges = $request->data['home_drop_off_charges'];
            //$schedule_service->pick_up_time = $request->data['pick_up_time'];
            //$schedule_service->drop_off_time = $request->data['drop_off_time'];

            $schedule_service->reservation_hours = $request->data['reservation_hours'];
            $schedule_service->reservation_minutes = $request->data['reservation_minutes'];
            $schedule_service->cancel_hours = $request->data['cancel_hours'];
            $schedule_service->cancel_minute = $request->data['cancel_minute'];
            //$schedule_service->pickup_hours = $request->data['pickup_hours'];
            //$schedule_service->pickup_minutes = $request->data['pickup_minutes'];

            $schedule_service->pick_up_location = $request->data['pick_up_location'];
            $schedule_service->drop_off_location = $request->data['drop_off_location'];
            $schedule_service->timings = $filteredTimings;

            $schedule_service->additional_millage_charges = $request->data['additional_millage_charges'];
            $schedule_service->timely_millage_charges = $request->data['timely_millage_charges'];

            $schedule_service->charges = $request->data['charges'];

            $schedule_service->price_per_person = $request->data['price_per_person'];
            $schedule_service->distance = $request->data['distance'];
            $schedule_service->time_duration_hours = $request->data['time_duration_hours'];
            $schedule_service->time_duration_text = $request->data['time_duration_text'];

            // dd($schedule_service);
            $schedule_service->save();

            return response()->json(['message' => 'Schedule Service saved successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $schedule_service = ScheduleService::findOrFail($id);
            $schedule_service->timings = collect($schedule_service->timings)
                ->sortBy(function ($timing) {
                    return strtotime($timing['departure_time']);
                })
                ->values()
                ->all();

            return response()->json($schedule_service);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $schedule_service = ScheduleService::findOrFail($id);
            $timings = $request->data['timings'];
            $filteredTimings = array_map(function ($timing) {
                $timing['additional_stops'] = array_filter($timing['additional_stops'], function ($stop) {
                    return !empty($stop['location']);
                });
                return $timing;
            }, $timings);
            $vehicle_capacity = Vehicle::select('id', 'passengers_capacity')->where('id', $request->data['vehicle_type_id'])->pluck('passengers_capacity')->first();

            $schedule_service->vehicle_type_id = $request->data['vehicle_type_id'];
            $schedule_service->shuttle_name = $request->data['shuttle_name'];

            //$vehicle_capacity got from the vehicles table
            $schedule_service->vehicle_capacity = $vehicle_capacity;

            $schedule_service->carry_bags_capacity = $request->data['carry_bags_capacity'];
            $schedule_service->check_in_bags_capacity = $request->data['check_in_bags_capacity'];
            $schedule_service->is_home_pickup = $request->data['is_home_pickup'];
            $schedule_service->is_home_drop_off = $request->data['is_home_drop_off'];
            $schedule_service->home_pickup_charges = $request->data['home_pickup_charges'];
            $schedule_service->home_drop_off_charges = $request->data['home_drop_off_charges'];

            $schedule_service->reservation_hours = $request->data['reservation_hours'];
            $schedule_service->reservation_minutes = $request->data['reservation_minutes'];
            $schedule_service->cancel_hours = $request->data['cancel_hours'];
            $schedule_service->cancel_minute = $request->data['cancel_minute'];

            $schedule_service->home_drop_off_hours = $request->data['home_drop_off_hours'];
            $schedule_service->home_drop_off_minutes = $request->data['home_drop_off_minutes'];
            $schedule_service->home_pickup_hours = $request->data['home_pickup_hours'];
            $schedule_service->home_pickup_minutes = $request->data['home_pickup_minutes'];

            $schedule_service->pick_up_location = $request->data['pick_up_location'];
            $schedule_service->drop_off_location = $request->data['drop_off_location'];
            $schedule_service->timings = $filteredTimings;

            $schedule_service->additional_millage_charges = $request->data['additional_millage_charges'];
            $schedule_service->timely_millage_charges = $request->data['timely_millage_charges'];


            $schedule_service->charges = $request->data['charges'];

            $schedule_service->price_per_person = $request->data['price_per_person'];
            $schedule_service->distance = $request->data['distance'];
            $schedule_service->time_duration_hours = $request->data['time_duration_hours'];
            $schedule_service->time_duration_text = $request->data['time_duration_text'];

            $schedule_service->save();

            return response()->json(['message' => 'Schedule Service updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $scheduleService = ScheduleService::findOrFail($id);
        $scheduleService->delete();

        return response()->json(['message' => 'Schedule Service deleted successfully'], 200);
    }

    public function scheduleServiceList()
    {
        try {
            $schedule_services = ScheduleService::get();

            return response()->json($schedule_services);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getData()
    {
        try {
            $schedule_services = ScheduleService::with('vehicle')->get();

            // Sort 'timings' within each 'vehicle' by 'departure_time'
            $schedule_services->each(function ($service) {
                if ($service && is_array($service->timings)) {
                    $service->timings = collect($service->timings)
                        ->sortBy(function ($timing) {
                            return strtotime($timing['departure_time']);
                        })
                        ->values()
                        ->all();
                }
            });

            return response()->json($schedule_services);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }


    public function getCityData($cityId)
    {
        // dd($cityId);
        try {
            $schedule_services = ScheduleService::where('city_id', $cityId)->with('vehicle')->get();

            $schedule_services->each(function ($service) {
                if ($service && is_array($service->timings)) {
                    $service->timings = collect($service->timings)
                        ->sortBy(function ($timing) {
                            return strtotime($timing['departure_time']);
                        })
                        ->values()
                        ->all();
                }
            });
            return response()->json($schedule_services);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getFormData()
    {
        try {
            $obj = new stdClass();

            $obj->allScheduleVehicles = Vehicle::where('is_schedule', 1)->get();
            //$obj->allAirports = Airport::where('is_active', 1)->get();
            $obj->allAdditionalCharges = OtherCharges::select('id', 'name', 'operator', 'is_percentage')->where('is_active', 1)->get()->map(function ($item) {
                $item->price = ''; // Default price value
                return $item;
            });
            $obj->allTimelyCharges = TimelyAdditionalCharges::select('id', 'time_in', 'time_out', 'price', 'operator', 'is_percentage')->where('is_active', 1)->get()->map(function ($item) {
                $item->price = ''; // Default price value
                return $item;
            });
            $obj->allTravellerTypes = TravellerTypes::select('id', 'name', 'count')->where('id', '!=', 1)->where('is_active', 1)->orderBy('name', 'ASC')->get()->map(function ($item) {
                $item->price = ''; // Default price value
                return $item;
            });

            return response()->json($obj);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getClientSideData()
    {
        // dd($rideType);
        try {
            $obj = new stdClass();

            $obj->allScheduleServices = ScheduleService::select('id', 'pickup_address', 'drop_off_address')->where('is_active', 1)->get();

            $obj->allVehicles = Vehicle::select('id', 'vehicles_type')->where('is_active', 1)->get();
            $obj->allOtherCharges = OtherCharges::select('id', 'name', 'operator')->where('is_active', 1)->get();
            $obj->allTimelyCharges = TimelyAdditionalCharges::select('id', 'time_in', 'time_out', 'operator')->where('is_active', 1)->get();

            return response()->json($obj);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getScheduleClientSideData($rideType)
    {
        // dd($rideType);
        try {
            $obj = new stdClass();

            if ($rideType == 'city') {
                $obj->allScheduleServices = ScheduleService::select('id', 'pickup_address', 'drop_off_address')
                    ->where('ride_type', 'city')
                    ->where('is_active', 1)
                    ->get();
            } else if ($rideType == 'to_airport') {
                $obj->allScheduleServices = ScheduleService::select('id', 'pickup_address', 'drop_off_address')
                    ->where('ride_type', 'airport')
                    ->where('airport_ride_type', $rideType)
                    ->where('is_active', 1)
                    ->get();
            } else if ($rideType == 'from_airport') {
                $obj->allScheduleServices = ScheduleService::select('id', 'pickup_address', 'drop_off_address')
                    ->where('ride_type', 'airport')
                    ->where('airport_ride_type', $rideType)
                    ->where('is_active', 1)
                    ->get();
            }
            $obj->allVehicles = Vehicle::select('id', 'vehicles_type')->where('is_active', 1)->get();
            $obj->allAirlines = Airline::select('id', 'airline_name')->where('is_active', 1)->get();
            $obj->allFlightDestinations = FlightDestination::select('id', 'name', 'code')->where('is_active', 1)->get();
            // $obj->allOtherCharges = OtherCharges::select('id', 'name', 'operator')->where('is_active', 1)->get();
            // $obj->allTimelyCharges = TimelyAdditionalCharges::select('id', 'time_in', 'time_out', 'operator')->where('is_active', 1)->get();

            return response()->json($obj);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateIsActive(Request $request, $id)
    {
        try {
            ScheduleService::whereId($id)->update([
                'is_active' => $request->status,
            ]);

            return response()->json(['message' => 'Schedule Service status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getSearchedScheduleServices(Request $request)
    {
        // dd($request->all());
        $services = ScheduleService::with(['vehicle', 'city:id,name,is_active'])
            ->where(function ($query) use ($request) {
                $query->where('pick_up_location->description', $request->pickupAddress['description']);
            })
            ->get();

        $filteredServices = [];

        foreach ($services as $service) {
            $timings = $service->timings;
            // Check if any timing entry has the reservation day as true
            if (!$service->vehicle || $service->vehicle->passengers_capacity < $request->travellers) {
                continue;
            }

            $validTimings = [];
            foreach ($timings as $timing) {
                if (!empty($timing[$request->reservation_day])) {
                    $departureTime = Carbon::parse($request->reservation_date . ' ' . $timing['departure_time']);
                    $currentTime = Carbon::now();

                    // Check if the departure time is in the future
                    if ($departureTime->greaterThan($currentTime)) {
                        $validTimings[] = $timing;
                    }
                }
            }

            // Sort valid timings by departure time
            usort($validTimings, function ($a, $b) use ($request) {
                $timeA = Carbon::parse($request->reservation_date . ' ' . $a['departure_time']);
                $timeB = Carbon::parse($request->reservation_date . ' ' . $b['departure_time']);
                return $timeA->greaterThan($timeB);
            });

            if (!empty($validTimings)) {
                // Select the earliest timing
                foreach ($validTimings as $validTiming) {
                    # code...
                    $departureTime = Carbon::parse($request->reservation_date . ' ' . $validTiming['departure_time']);
                    $currentTime = Carbon::now();

                    $hours = $service->reservation_hours;
                    $minutes = $service->reservation_minutes;
                    $totalMinutes = ($hours * 60) + $minutes;

                    $minutesDifference = $currentTime->diffInMinutes($departureTime, false);

                    if (($minutesDifference > $totalMinutes || $totalMinutes == 0) || $request->is_admin) {
                        // Check if the drop-off location matches directly
                        if ($service->drop_off_location['description'] == $request->dropOffAddress['description']) {
                            $service->timings = $validTimings; // Attach only the matching timing
                            $filteredServices[] = $service;
                            break; // Move to the next service
                        }

                        // If the drop-off location doesn't match directly, check the stops
                        // if (isset($earliestTiming['additional_stops']) && is_array($earliestTiming['additional_stops'])) {
                        //     foreach ($earliestTiming['additional_stops'] as $stop) {
                        //         if ($stop['address'] === $request->dropOffAddress) {
                        //             $service->timings = [$earliestTiming]; // Attach only the matching timing
                        //             $filteredServices[] = $service;
                        //             break; // Break out of both loops
                        //         }
                        //     }
                        // }
                    }
                }
            }
        }
        return response()->json($filteredServices);
    }

    public function getCitiesStates()
    {
        $pickupServices = ScheduleService::select('pick_up_location->description as description')
            ->distinct()
            ->get();

        $dropOffServices = ScheduleService::select('drop_off_location->description as description')
            ->distinct()
            ->get();

        return response()->json(['pickUpServicesAddress' => $pickupServices, 'dropOffServicesAddress' => $dropOffServices], 200);
    }
    //for adding additional Stops in pickupAddress
    // public function getCitiesStates(){
    //     $pickupServices =  ScheduleService::select('pick_up_location->city as city','pick_up_location->state as state','timings')
    //         ->get();
    //         $pickUpAddresses=[];
    //         foreach($pickupServices as $service){
    //             if (!empty($service->city) && !empty($service->state)) {
    //                 $pickUpAddresses[] = [
    //                     'city' => $service->city,
    //                     'state' => $service->state
    //                 ];
    //             }
    //             $timings = $service->timings;
    //             foreach($timings as $timing){
    //             if (isset($timing['additional_stops']) && is_array($timing['additional_stops'])) {
    //                     foreach ($timing['additional_stops'] as $stop) {
    //                         if (isset($stop['location']['city']) && isset($stop['location']['state'])) {
    //                             $pickUpAddresses[] = [
    //                                 'city' => $stop['location']['city'],
    //                                 'state' => $stop['location']['state']
    //                             ];
    //                         }
    //                     }
    //                 }
    //             }
    //         }
    //         $uniquePickUpAddresses = array_map("unserialize", array_unique(array_map("serialize", $pickUpAddresses)));

    //     $dropOffServices =  ScheduleService::select('drop_off_location->city as city','drop_off_location->state  as state')
    //         ->get();

    //     // dd($services);
    //     return response()->json(['pickUpServicesAddress' => $uniquePickUpAddresses,'dropOffServicesAddress' => $dropOffServices], 200);
    // }
    public function removePrevious()
    {
        ScheduleService::truncate();

        return response()->json(["Removed successfully"]);
    }

    public function updateCharges()
    {

        $scheduleService = ScheduleService::with('city:id,name')->get();
        return response()->json(["Updated successfully", "service" => $scheduleService]);
    }


    private function getAdditionalChargesAmount($total, $objAdditionalCharge)
    {

        if ($objAdditionalCharge['is_percentage'] && isset($objAdditionalCharge['is_percentage'])) {
            return round($total / 100 * $objAdditionalCharge['price']);
        } else {
            return $objAdditionalCharge['price'];
        }
    }

    public function calculateFare(Request $request)
    {
        $reservation = $request->reservation;
        $filterData = $request->filterData;
        $travellerArray = $request->travellerArray;
        $timing = $request->timing;
        $additionalPassengers = ($filterData['travellers'] - 1);

        $additional_fare = [];
        $additionalChargesArray = $reservation['charges']['additional_charges'];
        foreach ($additionalChargesArray as $additionalCharges) {

            if (isset($additionalCharges['name']) && isset($additionalCharges['price']))
                if ($additionalCharges['id'] === 3) { // Additional Stops
                    // Additional Stop Charges
                    if (count($timing['additional_stops'])) {
                        $price = $additionalCharges['price'];
                        $tempAmount = $this->getAdditionalChargesAmount($price, $additionalCharges);
                        $additional_fare[] = ["id" => $additionalCharges['id'], "name" => $additionalCharges['name'], "amount" => $tempAmount * count($timing['additional_stops'])];
                    }
                } elseif ($additionalCharges['id'] === 9) { // Additional Passengers
                    $price = $additionalCharges['price'];
                    $tempAmount = $this->getAdditionalChargesAmount($price, $additionalCharges);


                    $additional_fare[] = ["id" => $additionalCharges['id'], "name" => "" . $additionalPassengers . "-" . $additionalCharges['name'], "amount" => $additionalPassengers * $tempAmount];
                } else {
                    $price = $additionalCharges['price'];
                    $tempAmount = $this->getAdditionalChargesAmount($price, $additionalCharges);
                    $additional_fare[] = ["id" => $additionalCharges['id'], "name" => $additionalCharges['name'], "amount" => $tempAmount];
                }
        }

        $baseFare = $reservation['price_per_person'] * ($additionalPassengers ? 1 : $filterData['travellers']);

        $reservation_fareDiscount = [];
        $travellerTypeCharges = $reservation['charges']['traveller_types_charges'];

        foreach ($travellerTypeCharges as $travellerTypeDiscount) {

            if ($travellerTypeDiscount['id'] != 1) {
                $count = array_column(array_filter($travellerArray, fn($traveller) => $traveller['id'] === $travellerTypeDiscount['id']), 'count')[0] ?? null;
                if ($count !== null && $count > 0 && isset($travellerTypeDiscount['price'])) {


                    $reservation_fareDiscount[] = ["id" => $travellerTypeDiscount['id'], "name" => ($count) . ' ' .  $travellerTypeDiscount['name'], "amount" => ($count) * $travellerTypeDiscount['price']];
                }
            }
        }
        $timeBaseCharges = [];
        $timeBaseChargesArray = $reservation['charges']['timely_charges'];
        foreach ($timeBaseChargesArray as $timeBaseCharge) {
            $pickupDateTime = Carbon::parse($filterData['reservation_date'] . ' ' . $timing['departure_time']);

            $strPickupDateDate = $pickupDateTime->format('Y-m-d');
            $pickupDateTime =  $pickupDateTime->format('Y-m-d h:i:s A');

            $timeIn = Carbon::parse($strPickupDateDate . ' ' . $timeBaseCharge['time_in'])->format('Y-m-d h:i:s A');
            $timeOut = Carbon::parse($strPickupDateDate . ' ' . $timeBaseCharge['time_out'])->format('Y-m-d h:i:s A');
            $difference = Carbon::parse($timeBaseCharge['time_in'])->diffInMinutes(Carbon::parse($timeBaseCharge['time_out']), false);
            if ($difference < 0) {
                $timeOut = Carbon::parse($strPickupDateDate . ' ' . $timeBaseCharge['time_out'])->addDay()->format('Y-m-d h:i:s A');
            }

            if (strtotime($pickupDateTime) >= strtotime($timeIn)  && strtotime($pickupDateTime) <= strtotime($timeOut) && $timeBaseCharge['price']) {
                $tempAmount = $this->getAdditionalChargesAmount($price, $timeBaseCharge);
                $timeBaseCharges[] = [
                    "time_check" =>  $timeBaseCharge['time_in'] . ' - ' . $timeBaseCharge['time_out'],
                    "amount" => $tempAmount
                ];;
            }
        }


        $reservation_fare['timely_charges'] = $timeBaseCharges;
        $reservation_fare['additional_charges'] = $additional_fare;
        $reservation_fare['discounts'] = $reservation_fareDiscount;

        // for calculating the prices
        // Calculate the total of timely charges
        $totalTimelyCharges = array_reduce($reservation_fare['timely_charges'], function ($carry, $item) {
            return $carry + $item['amount'];
        }, 0);

        // Calculate the total of additional charges
        $totalAdditionalCharges = array_reduce($reservation_fare['additional_charges'], function ($carry, $item) {
            return $carry + $item['amount'];
        }, 0);

        // Calculate the total of discounts
        $totalDiscounts = array_reduce($reservation_fare['discounts'], function ($carry, $item) {
            return $carry + $item['amount'];
        }, 0);

        $totalAmount = $totalTimelyCharges + $totalAdditionalCharges - $totalDiscounts + $baseFare;
        $reservation_fare['base_fare'] = $baseFare;
        $reservation_fare['total_amount'] = $totalAmount;

        return response()->json($reservation_fare);
    }
}
