<?php

namespace App\Http\Controllers\Admin\Reservations;

use stdClass;
use Google\Client;
use Google_Client;
use App\Mail\SendEmail;
use Google\Service\Gmail;
use Google_Service_Gmail;
use App\Models\Admin\Coupon;
use App\Models\Admin\Driver;
use Illuminate\Http\Request;
use App\Models\Admin\Airport;
use App\Models\Admin\Vehicle;
use App\Models\Admin\Customer;
use Illuminate\Support\Carbon;
use App\Mail\NewUserWelcomeMail;
use App\Models\Admin\Reservation;
use Google\Service\Gmail\Message;
use Google_Service_Gmail_Message;
use Illuminate\Support\Facades\DB;
use PHPMailer\PHPMailer\PHPMailer;
use App\Models\Admin\GuestCustomer;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\View;
use Google\Service\ServiceManagement\Service;

class ReservationsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.reservations.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, $customerId, $customerType, $isRoundTrip)
    {
        // dd($request->all(), $customerId, $customerType);
        try {
            DB::beginTransaction();
            // Common reservation fields
            $reservation_obj = new Reservation();

            if(!$isRoundTrip){
                $reservationData = $request->reservation_data;
            }
            else if($isRoundTrip){
                $reservationData = $request->round_trip_reservation_data;
            }

            // dd($reservationData);

            $reservation_obj->user_id = Auth::id() ? Auth::id() : null;
            $reservation_obj->city_id = $reservationData['city_id'];
            $reservation_obj->service_type_id = $reservationData['service_type_id'];
            $reservation_obj->ip_address = $request->ip();
            $reservation_obj->customer_id = $customerId;
            $reservation_obj->customer_type = $customerType;

            // dd($reservation_obj);
            // $reservation_obj->customer_type = $request->customer_information['customer_type'];

            if ($reservationData['service_type_id'] !== 4) {
                $reservation_obj->vehicle_type_id = $reservationData['selected_service']['id'];
                $reservation_obj->departure_pick_up_date = $reservationData['departure_pick_up_date'];
                $reservation_obj->departure_pick_up_time = $reservationData['departure_pick_up_time'];
                $reservation_obj->pick_up_date = $reservationData['pick_up_date'];
                $reservation_obj->pick_up_time = $reservationData['pick_up_time'];
                $reservation_obj->travellers = $reservationData['travellers'];
                $reservation_obj->luggage = $reservationData['luggage'];
                $reservation_obj->pick_up_location = $reservationData['pick_up_location'];
                $reservation_obj->drop_off_location = $reservationData['drop_off_location'];
                $reservation_obj->ride_type = $reservationData['selected_service']['ride_type'];
            }

            // dd($reservation_obj);

            // Travellers types if exist (Not for Schedule service)
            $reservation_obj->travellers_types = $reservationData['travellers_types'] !== [] ? $reservationData['travellers_types'] : null;
            $reservation_obj->selected_airline = $reservationData['selected_airline'] !== [] ? $reservationData['selected_airline'] : null;
            $reservation_obj->selected_flight_destination = $reservationData['selected_flight_destination'] !== [] ? $reservationData['selected_flight_destination'] : null;
            $reservation_obj->flight_number = $reservationData['flight_number'] !== [] ? $reservationData['flight_number'] : null;

            //Airport ride for airport services
            $reservation_obj->airport_ride = $reservationData['airport_ride'] ? $reservationData['airport_ride'] : null;

            //Additional stops, distances and time values if exist
            $reservation_obj->additional_stops = count($reservationData['additional_stops']) > 0 ? $reservationData['additional_stops'] : null;
            $reservation_obj->distance = $reservationData['distance'] ? $reservationData['distance'] : null;
            $reservation_obj->time_duration_text = $reservationData['time_duration_text'] ? $reservationData['time_duration_text'] : null;
            $reservation_obj->vehicles_count = $reservationData['vehicles_count'] ? $reservationData['vehicles_count'] : null;

            // Number of Hours for 'Airport(hourly)' and 'Hourly' Services
            $reservation_obj->drop_off_hours = $reservationData['drop_off_hours'] !== '' ? $reservationData['drop_off_hours'] : null;

            //For Airport hourly  service only
            if($reservationData['service_type_id'] != 4 && $reservationData['service_type_id'] == 1){
                if($reservationData['selected_service']['ride_type'] == 'hourly'){
                    $reservation_obj->drop_off_hours = $reservationData['selected_service']['drop_off_hours'];
                }
            }

            //If service is not scheduled
            if ($reservationData['service_type_id'] !== 4) {

                $reservation_obj->price = $request->total_fare;

                if ($reservationData['selected_service']['ride_type'] == 'millage') {
                    // If service selected for millage ride type
                    $reservation_obj->additional_millage_charges = $reservationData['selected_service']['millage_service']['additional_millage_charges'];
                    $reservation_obj->timely_millage_charges = $reservationData['selected_service']['millage_service']['timely_millage_charges'];
                    $reservation_obj->traveller_types_charges = $reservationData['selected_service']['millage_service']['traveller_types_charges'];
                    // $reservation_obj->price = $reservationData['selected_service']['millage_service']['est_with_add_fare'];
                }

                else if ($reservationData['selected_service']['ride_type'] == 'hourly') {
                    // If service selected for hourly ride type
                    $reservation_obj->additional_millage_charges = $reservationData['selected_service']['hourly_service']['additional_hourly_charges'];
                    $reservation_obj->timely_millage_charges = $reservationData['selected_service']['hourly_service']['timely_hourly_charges'];
                    $reservation_obj->traveller_types_charges = $reservationData['selected_service']['hourly_service']['traveller_types_charges'];
                    // $reservation_obj->price = $reservationData['selected_service']['hourly_service']['est_with_add_fare'];
                }
            }

            //If service is scheduled
            if($reservationData['service_type_id'] == 4){
                $this->makeScheduleReservations($reservation_obj, $reservationData, $request->schedule_service);
            }

            $reservation_obj->status = 'new_reservation';

            $reservation_obj->save();

            DB::commit();

            return $reservation_obj; // Return the created reservation object

        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function makeScheduleReservations($reservation_obj, $reservation_data, $schedule_data){

        $reservation_obj->shuttle_name = $schedule_data['shuttle_name'];
        $reservation_obj->schedule_service_type = $schedule_data['schedule_service_type'];
        $reservation_obj->vehicle_type_id = $schedule_data['vehicle_type_id'];
        $reservation_obj->pick_up_time = $schedule_data['pick_up_time'];
        $reservation_obj->drop_off_time = $schedule_data['drop_off_time'];

        $reservation_obj->passengers = $schedule_data['scheduleServiceAdditionInformation']['travellers'];
        $reservation_obj->carry_bags = $schedule_data['scheduleServiceAdditionInformation']['carry_bags_capacity'];
        $reservation_obj->check_in_bags = $schedule_data['scheduleServiceAdditionInformation']['check_in_bags_capacity'];

        if($schedule_data['schedule_service_type'] == 'city'){
            $reservation_obj->pick_up_location = $schedule_data['pickup_location']['address'];
            $reservation_obj->drop_off_location = $schedule_data['drop_off_location']['address'];
        }
        else if($schedule_data['schedule_service_type'] == 'airport'){
            $reservation_obj->pick_up_location = $reservation_data['pick_up_location']['address'];
            $reservation_obj->drop_off_location = $reservation_data['drop_off_location']['address'];
        }

        if (isset($schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_location']) && isset($schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_location']['address'])) {
            $reservation_obj->home_pick_up_location = $schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_location']['address'];
        }
        if (isset($schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_location']) && isset($schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_location']['address'])) {
            $reservation_obj->home_drop_off_location = $schedule_data['scheduleServiceAdditionInformation']['schedule_drop_off_location']['address'];
        }

        if($schedule_data['schedule_service_type'] == 'airport' && $schedule_data['airport_ride'] == 'to_airport'){
            if (isset($schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address']) && isset($schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address']['address'])) {
                $reservation_obj->home_pick_up_location = $schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address'];
            }
        }
        if($schedule_data['schedule_service_type'] == 'airport' && $schedule_data['airport_ride'] == 'from_airport'){
            if (isset($schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address']) && isset($schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address']['address'])) {
                $reservation_obj->home_drop_off_location = $schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address'] !== '' ? $schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address'] : '';
            }
        }

        $reservation_obj->estimated_miles = $schedule_data['distance'] ? $schedule_data['distance'] : null;
        $reservation_obj->estimated_time = $schedule_data['time_duration_text'] ? $schedule_data['time_duration_text'] : null;

        $reservation_obj->additional_millage_charges = $schedule_data['additional_millage_charges'];
        $reservation_obj->additional_timely_charges = $schedule_data['timely_millage_charges'];
        $reservation_obj->price = $schedule_data['fare_with_add_charges'];
    }

    public function getReservationData()
    {
        try {
            $obj = new stdClass();

            $data = Reservation::latest()->first();

            $obj->data = $data;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getRegisteredCustomer(Request $request)
    {
        try {

            dd($request->all());

            $obj = new stdClass();

            $password = bcrypt($request->password);

            $customer = Customer::where('email', $request->email)->where('password', $password)->first();

            dd($customer);

            $cc_expiry = $customer->cc_expiry;
            if (!empty($cc_expiry)) {
                $cc_expiry_arr = explode('-', $cc_expiry); // Split the cc_expiry string into an array

                $cc_expiry_month = $cc_expiry_arr[0];
                $cc_expiry_year = $cc_expiry_arr[1];

                $customer->cc_expiry_month = $cc_expiry_month;
                $customer->cc_expiry_year = $cc_expiry_year;
            }

            $customer->password = '';

            $obj->customer = $customer;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getAllReservations()
    {
        try {
            $obj = new stdClass();
            $obj->data = [];

            $reservations = Reservation::all();

            foreach ($reservations as $reservation) {
                if ($reservation->customer_type == 'guest') {
                    $reservation->guestCustomer = GuestCustomer::find($reservation->customer_id);
                } elseif ($reservation->customer_type == 'registered') {
                    $reservation->customer = Customer::find($reservation->customer_id);
                }

                $obj->data[] = $reservation;
            }

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getTodayReservations()
    {
        try {
            $obj = new stdClass();

            $data = Reservation::whereDate('pick_up_date', '=', Carbon::today()->toDateString())->get();

            $obj->data = $data;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getTomorrowReservations()
    {
        try {
            $obj = new stdClass();

            $data = Reservation::whereDate('pick_up_date', '=', Carbon::tomorrow()->toDateString())->get();

            $obj->data = $data;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getDateRangeReservations(Request $request)
    {
        // dd($request->all());
        try {
            $obj = new stdClass();

            $data = Reservation::whereDate('created_at', '>=', $request->start_date)
                    ->whereDate('updated_at', '<=', $request->ending_date)
                    ->get();

            $obj->data = $data;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }


    public function getAllReservationInfo()
    {
        try {
            $obj = new stdClass();

            $vehicles = Vehicle::select('id', 'vehicles_type')->get();
            $drivers = Driver::select('id', 'first_name', 'last_name')->get();

            $obj->vehicles = $vehicles;
            $obj->drivers = $drivers;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function saveReservationWithUser(Request $request)
    {
        try {
            DB::beginTransaction();

            $existingCustomer = Customer::where('mobile_number', $request->customer_information['mobile_number'])
                ->orWhere('phone_number', $request->customer_information['phone_number'])
                ->orWhere('email', $request->customer_information['email'])
                ->first();

            $obj = new stdClass();

            if ($existingCustomer) {
                // Customer already exists, update the existing record
                $obj->customer_obj = $existingCustomer;
            } else {
                // Customer does not exist, create a new record
                $obj->customer_obj = new Customer();
            }

            $obj->customer_obj->first_name = $request->customer_information['first_name'];
            $obj->customer_obj->last_name = $request->customer_information['last_name'];
            $obj->customer_obj->phone_number = $request->customer_information['phone_number'];
            $obj->customer_obj->mobile_number = $request->customer_information['mobile_number'];
            $obj->customer_obj->email = $request->customer_information['email'];
            $obj->customer_obj->status = 'Registered Customer';

            if(isset($request->customer_information['password'])){
                $obj->customer_obj->password = bcrypt($request->customer_information['password']);
                $obj->customer_obj->readable_password = $request->customer_information['password'];
            }

            $obj->customer_obj->customer_type = $request->customer_information['customer_type'];
            $obj->customer_obj->card_type = $request->customer_information['card_type'];
            $obj->customer_obj->cc_number = $request->customer_information['cc_number'];
            $obj->customer_obj->csv_code = $request->customer_information['csv_code'];
            $obj->customer_obj->billing_zip_code = $request->customer_information['billing_zip_code'];
            $obj->customer_obj->card_holder_name = $request->customer_information['card_holder_name'];

            // Credit card expiration date format making
            $cc_expiry_month = $request->customer_information['cc_expiry_month'];
            $cc_expiry_year = $request->customer_information['cc_expiry_year'];

            $obj->customer_obj->cc_expiry = $cc_expiry_month . '-' . $cc_expiry_year;

            $obj->customer_obj->save();

            if ($request->is_round_trip) {
                // For round trip reservations

                // Create first reservation
                $obj->firstReservation = $this->store($request, $obj->customer_obj->id, 'registered', false);

                // Create second reservation
                $obj->secondReservation = $this->store($request, $obj->customer_obj->id, 'registered', true);


                // Update round_trip column
                $obj->firstReservation['round_trip'] = $obj->secondReservation['id'];
                $obj->secondReservation['round_trip'] = $obj->firstReservation['id'];

                $obj->firstReservation->save();
                $obj->secondReservation->save();

                return response()->json($obj, 200);
            }
            else{
                //create single reservation
                $obj->singleReservation = $this->store($request, $obj->customer_obj->id, 'registered', false);

                return response()->json($obj,200);
            }

            DB::commit();

            // return response()->json(['message' => 'Reservation created successfully'], 201);
        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function saveReservationWithGuestUser(Request $request)
    {
        try {
            dd($request->all());
            DB::beginTransaction();

            $guest_customer = new GuestCustomer();

            $guest_customer->first_name = $request->customer_information['first_name'];
            $guest_customer->last_name = $request->customer_information['last_name'];
            $guest_customer->phone_number = $request->customer_information['phone_number'];
            $guest_customer->mobile_number = $request->customer_information['mobile_number'];
            $guest_customer->email = $request->customer_information['email'];
            $guest_customer->status = 'Guest Customer';

            $guest_customer->customer_type = $request->customer_information['customer_type'];
            $guest_customer->card_type = $request->customer_information['card_type'];
            $guest_customer->cc_number = $request->customer_information['cc_number'];
            $guest_customer->csv_code = $request->customer_information['csv_code'];
            $guest_customer->billing_zip_code = $request->customer_information['billing_zip_code'];
            $guest_customer->card_holder_name = $request->customer_information['card_holder_name'];

            // Credit card expiration date format making
            $cc_expiry_month = $request->customer_information['cc_expiry_month'];
            $cc_expiry_year = $request->customer_information['cc_expiry_year'];

            $guest_customer->cc_expiry = $cc_expiry_month . '-' . $cc_expiry_year;

            $guest_customer->save();

            if ($request->is_round_trip) {
                // For round trip reservations

                //create first reservation
                $firstReservation = $this->store($request, $guest_customer->id, 'guest', false);

                //create second reservation
                $secondReservation = $this->store($request, $guest_customer->id, 'guest', true);

                // Update round_trip column
                $firstReservation['round_trip'] = $secondReservation['id'];
                $secondReservation['round_trip'] = $firstReservation['id'];

                $firstReservation->save();
                $secondReservation->save();

                return response()->json([$firstReservation, $secondReservation], 200);
            }
            else {
                //create single reservation
                $singleReservation = $this->store($request, $guest_customer->id, 'guest', false);

                return response()->json($singleReservation, 200);
            }

            DB::commit();

            // return response()->json(['message' => 'Reservation created successfully'], 201);

        } catch (\Exception $exception) {
            DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function saveCustomerNotes(Request $request)
    {
        try {

            if($request->customer_type == 'Registered'){
                $customer_obj = Customer::findOrFail($request->customer_id);
                $customer_obj->notes = $request->notes;
            }

            if($request->customer_type == 'Guest'){
                $customer_obj = GuestCustomer::findOrFail($request->customer_id);
                $customer_obj->notes = $request->notes;
            }

            $customer_obj->save();

            $reservations = Reservation::where('customer_type', $request->customer_type)
                ->where('customer_id', $request->customer_id)
                ->get();
            foreach ($reservations as $reservation) {
                $reservation->customer_notes = $request->notes;
                $reservation->save();
            }

            // return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function updateDriverInfo(Request $request)
    {
        try {
            $reservation_obj = Reservation::findOrFail($request->reservation_id);

            $reservation_obj->driver_id = $request->driver_id;

            $reservation_obj->save();

            return response()->json(['message' => 'Driver assigned successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getAllAirportData()
    {
        try {
            $obj = new stdClass();
            $obj->allAirports = Airport::select('id', 'name', 'airport_location')->where('is_active', 1)->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function updateReservationStatus($reservationId, $reservationStatus = null)
    {
        try {
            $reservation_obj = Reservation::findOrFail($reservationId);

            $reservation_obj->status = $reservationStatus ? $reservationStatus : null;

            $reservation_obj->save();

            return response()->json(['message' => 'Reservation status saved successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }


    // public function sendEmail(Request $request)
    // {

    //     dd($request->all());

    //     $email = $request->input('email');
    //     $message = $request->input('message');

    //     // Send email
    //     Mail::to($email)->send(new NewUserWelcomeMail($message, $email));

    //     $email = new SendEmail();
    //     Mail::send($email);

    //     return response()->json(['message' => 'Email sent successfully!']);
    // }

    public function checkCouponValidation(Request $request){
        // dd($request->all());

        $vehicleTypeId = $request->input('vehicle_type_id');

        $coupon = Coupon::select('id', 'coupon_type', 'coupon_price')
                ->where('coupon_code', $request->input('coupon_code'))
                ->where('city_id', $request->input('city_id'))
                ->where('service_id', $request->input('service_type_id')) //Add where clause fro checking service type e.g Airport, Hourly etc
                ->whereJsonContains('vehicle_make_ids', $vehicleTypeId) // Add whereJsonContains clause for vehicle type
                ->where('expiry_date', '>=', $request->input('pick_up_date')) // Add whereDate clause to check expiry date with pickup date
                ->where('is_active', 1)
                ->first();

                return response()->json($coupon, 200);

            // dd($coupon);
    }


    public function sendEmail(Request $request)
    {
        // Create a new instance of Google_Client
        $client = new Google_Client();
        $client->setApplicationName('Your Application Name');
        $client->setScopes([
            Google_Service_Gmail::GMAIL_SEND,
            Google_Service_Gmail::GMAIL_READONLY
        ]);
        $client->setAuthConfig('F:\\EconomyShuttle\\credentials.json');
        $client->setAccessType('offline');
        $client->setPrompt('select_account consent');

        // Authenticate with Google
        $accessToken = $client->fetchAccessTokenWithAuthCode($request->code);
        $client->setAccessToken($accessToken);

        // Create a new instance of the Gmail API client
        $service = new Google_Service_Gmail($client);

        // Construct the message
        $to = 'info.alihassan@gmail.com';
        $subject = 'Test email';
        $messageText = 'Test body email';
        $message = new Google_Service_Gmail_Message();
        $message->setRaw(base64_encode(
            "To: $to\r\n" .
            "Subject: $subject\r\n\r\n" .
            "$messageText"
        ));

        // Send the message
        $service->users_messages->send('me', $message);

        return 'Email sent successfully!';
    }



    public function loginRequest(Request $request)
    {

        try {
            // mail function
            // sendAuthEmail($request->email);

            // Mail::to($request->email)->send(new LoginMail($emailData));
            // Mail::mailer('sendmail')->to($request->email)->send(new LoginMail($emailData));

            // $mail = new PHPMailer();

            // $mail->setfrom('alihassan2745@gmail.com', 'Farhan Raza');
            // $mail->addAddress('info.alihassan@gmail.com');

            // $mail->isHTML(true);
            // $mail->Subject = "subject";
            // $mail->Body = "email content goes here";


            $view = View::make('admin.reservations.index');
            $content = $view->render();

            $headers = "From: Ali Hassan <alihassan.development@gmail.com>\r\n";
            $headers .= "Reply-To: Ali Hassan <alihassan.development@gmail.com>\r\n";
            $headers .= "MIME-Version: 1.0\r\n";
            $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";

            mail('info.alihassan@gmail.com', 'My Subject', $content, $headers);

            return  response()->json(['message' => 'Email sent please check your inbox'], 200);

        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function myMethod()
    {
        $client = new Client();
        $client->setClientId('619307746157-b08oin9gl9gnej458e1jd9dod0nrncka.apps.googleusercontent.com');
        $client->setClientSecret('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');
        $client->setRedirectUri('http://localhost:8000/admin/google/callback');
        $client->setAccessType('offline');
        $client->setApprovalPrompt('force');
        $client->setScopes([
            'https://www.googleapis.com/auth/gmail.compose',
            'https://www.googleapis.com/auth/gmail.readonly',
            'https://www.googleapis.com/auth/gmail.send',
        ]);



        // Use the $client object to make API requests
        // ...
    }
}

