<?php

namespace App\Http\Controllers\Admin\Reservations;

use stdClass;

use Carbon\Carbon;
use Google\Client;
use Google_Client;
use App\Mail\SendEmail;
use App\Mail\MailHandler;
use Google\Service\Gmail;
use Google_Service_Gmail;
use App\Models\Admin\Site;
use App\Models\Admin\User;
use Illuminate\Support\Str;
use App\Models\Admin\Coupon;
use App\Models\Admin\Driver;
use Illuminate\Http\Request;
use App\Models\Admin\Airline;
use App\Models\Admin\Airport;
use App\Models\Admin\PayType;
use App\Models\Admin\Vehicle;
use App\Models\Admin\Customer;
use App\Models\Admin\Employee;
use App\Models\Admin\UserGroup;
use App\Mail\NewUserWelcomeMail;
use App\Models\Admin\ActivityLog;
use App\Models\Admin\BlockDriver;
use App\Models\Admin\Reservation;
use Google\Service\Gmail\Message;
use Google_Service_Gmail_Message;
use Illuminate\Support\Facades\DB;
use PHPMailer\PHPMailer\PHPMailer;
use App\Models\Admin\DirectAccount;
use App\Models\Admin\GuestCustomer;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\View;
use App\Mail\ReservationConfirmation;
use App\Models\Admin\FlightDestination;
use Illuminate\Support\Facades\Validator;
use Google\Service\ServiceManagement\Service;
use App\Http\Controllers\Email\EmailSentController;
use App\Services\EmailService;

class ReservationsController extends Controller
{
    protected $emailService;

    public function __construct(EmailService $emailService)
    {
        $this->emailService = $emailService;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.reservations.index');
    }

    public function fareQuoteView($customer = null, $customerType = null)
    {
        // dd(Auth::id());
        return view('frontend.reservations.fareQoute', [
            'customer' => $customer,
            'customer_type' => $customerType,
            'fareQuote' => true
        ]);
    }

    public function reservationIndex($customer = null, $customerType = null)
    {
        // dd(Auth::id());
        return view('frontend.reservations.reservations', [
            'customer' => $customer,
            'customer_type' => $customerType,
            'fareQuote' => false
        ]);
    }

    public function iframeReservation()
    {
        return view('frontend.iframes.reservation', [
            'fareQuote' => false
        ]);
    }

    public function iframeFareQuoteView()
    {
        return view('frontend.iframes.reservation', [
            'fareQuote' => true
        ]);
    }
    public function iframeCustomerView()
    {
        return view('frontend.iframes.customer');
    }
    public function iframeFindReservationView()
    {
        return view('frontend.iframes.findReservation');
    }

    public function verifyDomain()
    {
        $url = request()->input('url');
        $cleanedUrl = Str::replaceFirst('www.', '', $url);
        $site = Site::where('site_url', $cleanedUrl)->where('is_active',1)->first();
        if ($site) {
            // $token = $site->createToken('API Token for Site having code  --->>> ' . $site->code, ['reservation', 'customers'])->accessToken;
            return response()->json(['allowed' => true,'site_id' => $site->id]);
        } else {
            return response()->json(['allowed' => false]);
        }
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    /**
     * @DISCARD
     * this function is not going to be used in future.
     * */
    public function store(Request $request, $customerId, $customerType, $payTypeId, $isRoundTrip)
    {
        try {
            // Common reservation fields
            // var_dump($isRoundTrip);
            $reservation_obj = new Reservation();
            // dd($isRoundTrip);
            if (!$isRoundTrip) {
                $reservationData = $request->reservation_data;
            } else if ($isRoundTrip) {
                $reservationData = $request->round_trip_reservation_data;
                // dd($reservationData);
            }

            // dd($reservationData['customer_notes']);

            $reservation_obj->user_id = Auth::id();
            $reservation_obj->city_id = $reservationData['city_id'];
            $reservation_obj->service_type_id = $reservationData['service_type_id'];
            $reservation_obj->customer_notes = $reservationData['customer_notes'];
            $reservation_obj->ip_address = $request->ip();
            $reservation_obj->customer_id = $customerId;
            $reservation_obj->customer_type = $customerType;
            $reservation_obj->site_id = $request->site_id ? $request->site_id : 1;

            if ($reservationData['service_type_id'] !== 4) {
                $reservation_obj->vehicle_type_id = $reservationData['selected_service']['id'];
                $reservation_obj->departure_pick_up_date = $reservationData['departure_pick_up_date'];
                $reservation_obj->departure_pick_up_time = $reservationData['departure_pick_up_time'];
                $reservation_obj->pick_up_date = $reservationData['pick_up_date'];
                $reservation_obj->pick_up_time = $reservationData['pick_up_time'];
                $reservation_obj->travellers = $reservationData['travellers'];
                $reservation_obj->luggage = $reservationData['luggage'];
                $reservation_obj->pick_up_location = $reservationData['pick_up_location'];
                $reservation_obj->drop_off_location = $reservationData['drop_off_location'];
                $reservation_obj->ride_type = $reservationData['selected_service']['ride_type'];
            }

            // Travellers types if exist (Not for Schedule service)
            $reservation_obj->travellers_types = $reservationData['travellers_types'] !== [] ? $reservationData['travellers_types'] : null;
            $reservation_obj->selected_airline = $reservationData['selected_airline'] !== [] ? $reservationData['selected_airline'] : null;
            $reservation_obj->selected_flight_destination = $reservationData['selected_flight_destination'] !== [] ? $reservationData['selected_flight_destination'] : null;
            $reservation_obj->flight_number = $reservationData['flight_number'] !== [] ? $reservationData['flight_number'] : null;

            //Airport ride for airport services
            $reservation_obj->airport_ride = $reservationData['airport_ride'] ? $reservationData['airport_ride'] : null;

            //Additional stops, distances and time values if exist
            $reservation_obj->additional_stops = count($reservationData['additional_stops']) > 0 ? $reservationData['additional_stops'] : null;

            $reservation_obj->distance = $reservationData['distance'] ? $reservationData['distance'] : null;
            $reservation_obj->time_duration_text = $reservationData['time_duration_text'] ? $reservationData['time_duration_text'] : null;
            // $reservation_obj->time_duration_hours = $reservationData['time_duration_hours'] ? $reservationData['time_duration_hours'] : null;

            $reservation_obj->vehicles_count = $reservationData['vehicles_count'] ? $reservationData['vehicles_count'] : null;

            // Number of Hours for 'Airport(hourly)' and 'Hourly' Services
            $reservation_obj->drop_off_hours = $reservationData['drop_off_hours'] !== '' ? $reservationData['drop_off_hours'] : null;

            //For Airport hourly  service only
            if ($reservationData['service_type_id'] != 4 && $reservationData['service_type_id'] == 1 && $reservationData['selected_service']) {
                if ($reservationData['selected_service']['ride_type'] == 'hourly') {
                    $reservation_obj->drop_off_hours = $reservationData['selected_service']['drop_off_hours'];
                }
            }

            if ($reservationData['service_type_id'] !== 4 && $reservationData['selected_service']) {

                if ($isRoundTrip) {

                    $reservation_obj->admin_discount = $request->round_admin_discount;
                    $reservation_obj->driver_gratuity = $request->round_driver_gratuity;
                    $reservation_obj->is_on_call = $request->is_round_on_call;
                    $reservation_obj->on_call_charges = $request->on_call_charges;
                } else if (!$isRoundTrip) {

                    $reservation_obj->admin_discount = $request->admin_discount;
                    $reservation_obj->driver_gratuity = $request->driver_gratuity;
                    $reservation_obj->is_on_call = $request->is_on_call;
                    $reservation_obj->on_call_charges = $request->on_call_charges;
                }

                if ($reservationData['selected_service']['ride_type'] == 'millage') {
                    // If service selected for millage ride type
                    $reservation_obj->additional_millage_charges = $reservationData['selected_service']['millage_service']['additional_millage_charges'];
                    $reservation_obj->timely_millage_charges = $reservationData['selected_service']['millage_service']['timely_millage_charges'];
                    $reservation_obj->traveller_types_charges = $reservationData['selected_service']['millage_service']['traveller_types_charges'];
                    // $reservation_obj->price = $reservationData['selected_service']['millage_service']['est_with_add_fare'];
                } else if ($reservationData['selected_service']['ride_type'] == 'hourly') {
                    // If service selected for hourly ride type
                    $reservation_obj->additional_millage_charges = $reservationData['selected_service']['hourly_service']['additional_hourly_charges'];
                    $reservation_obj->timely_millage_charges = $reservationData['selected_service']['hourly_service']['timely_hourly_charges'];
                    $reservation_obj->traveller_types_charges = $reservationData['selected_service']['hourly_service']['traveller_types_charges'];
                    // $reservation_obj->price = $reservationData['selected_service']['hourly_service']['est_with_add_fare'];
                }
            }

            if ($reservationData['service_type_id'] == 4) {
                if (!$isRoundTrip) {
                    $this->makeScheduleReservations($reservation_obj, $request->schedule_service);
                } else {
                    $this->makeScheduleReservations($reservation_obj, $request->round_schedule_service);
                }
            }

            $reservation_obj->pay_type_id = $payTypeId;
            $reservation_obj->status = 'new_reservation';

            $reservation_obj->save();

            return $reservation_obj; // Return the created reservation object

        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function makeScheduleReservations($reservation_obj, $schedule_data)
    {

        // dd($schedule_data);

        $reservation_obj->shuttle_name = $schedule_data['shuttle_name'];
        $reservation_obj->schedule_service_type = $schedule_data['ride_type'];
        $reservation_obj->vehicle_type_id = $schedule_data['vehicle_type_id'];
        $reservation_obj->departure_pick_up_date = $schedule_data['departure_pick_up_date'] ? $schedule_data['departure_pick_up_date'] : null;
        $reservation_obj->departure_pick_up_time = $schedule_data['departure_pick_up_time'] ? $schedule_data['departure_pick_up_time'] : null;
        $reservation_obj->pick_up_date = $schedule_data['pick_up_date'] ?? null;

        $reservation_obj->pick_up_time = $schedule_data['pick_up_time'] ? $schedule_data['pick_up_time'] : null;
        $reservation_obj->drop_off_time = $schedule_data['drop_off_time'];

        $reservation_obj->travellers = $schedule_data['scheduleServiceAdditionInformation']['travellers'];
        $reservation_obj->luggage = $schedule_data['scheduleServiceAdditionInformation']['carry_bags_capacity'];
        $reservation_obj->check_in_bags = $schedule_data['scheduleServiceAdditionInformation']['check_in_bags_capacity'];
        $reservation_obj->pick_up_location = $schedule_data['pick_up_location'];
        $reservation_obj->drop_off_location = $schedule_data['drop_off_location'];
        $reservation_obj->selected_airline = $schedule_data['selected_airline'] ? $schedule_data['selected_airline'] : null;
        $reservation_obj->selected_flight_destination = $schedule_data['selected_flight_destination'] ? $schedule_data['selected_flight_destination'] : null;
        $reservation_obj->flight_number = $schedule_data['flight_number'] ? $schedule_data['flight_number'] : null;

        if (isset($schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_location']) && isset($schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_location']['address'])) {
            $reservation_obj->home_pick_up_location = $schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_location']['address'];
        }
        if (isset($schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_location']) && isset($schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_location']['address'])) {
            $reservation_obj->home_drop_off_location = $schedule_data['scheduleServiceAdditionInformation']['schedule_drop_off_location']['address'];
        }

        if ($schedule_data['ride_type'] == 'airport' && $schedule_data['airport_ride_type'] == 'to_airport') {
            $reservation_obj->airport_ride = $schedule_data['airport_ride_type'];
            if (isset($schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address']) && isset($schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address']['address'])) {
                $reservation_obj->home_pick_up_location = $schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address'];
            }
        }
        if ($schedule_data['ride_type'] == 'airport' && $schedule_data['airport_ride_type'] == 'from_airport') {
            $reservation_obj->airport_ride = $schedule_data['airport_ride_type'];
            if (isset($schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address']) && isset($schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address']['address'])) {
                $reservation_obj->home_drop_off_location = $schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address'] !== '' ? $schedule_data['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address'] : '';
            }
        }

        $reservation_obj->vehicle_capacity = $schedule_data['vehicle_capacity'] ? $schedule_data['vehicle_capacity'] : null;
        $reservation_obj->distance = $schedule_data['distance'] ? $schedule_data['distance'] : null;
        $reservation_obj->time_duration_text = $schedule_data['time_duration_text'] ? $schedule_data['time_duration_text'] : null;
        $reservation_obj->additional_millage_charges = $schedule_data['additional_millage_charges'];
        $reservation_obj->timely_millage_charges = $schedule_data['timely_millage_charges'];
        $reservation_obj->price = $schedule_data['fare_with_add_charges'];
        $reservation_obj->fare_per_person = $schedule_data['fare_per_person'];
        $reservation_obj->fare_with_add_charges = $schedule_data['fare_with_add_charges'];

        // dd($reservation_obj);
    }

    public function getReservationData()
    {
        try {
            $obj = new stdClass();

            $data = Reservation::latest()->first();

            $obj->data = $data;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getRegisteredCustomer(Request $request)
    {
        try {

            $obj = new stdClass();

            $customer = Customer::where('email', $request->email)->first();

            if ($customer && Hash::check($request->password, $customer->password)) {
                $cc_expiry = $customer->cc_expiry;
                if (!empty($cc_expiry)) {
                    $cc_expiry_arr = explode('-', $cc_expiry); // Split the cc_expiry string into an array

                    $cc_expiry_month = $cc_expiry_arr[0];
                    $cc_expiry_year = $cc_expiry_arr[1];

                    $customer->cc_expiry_month = $cc_expiry_month;
                    $customer->cc_expiry_year = $cc_expiry_year;
                }
            } else {
                $customer = null;
            }

            $customer ? $customer->password = '' : null;

            $obj->customer = $customer;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }


    public static function searchReservations(Request $request)
    {
        // dd($request->all());
        try {
            $search_type = $request->input('search_type');
            $query = Reservation::with('Customer');
            if($search_type == 'created'){
                $query->whereDate('created_at', '>=', $request->start_date);
                $query->whereDate('created_at', '<=', $request->ending_date);
            }else{

                if (!empty($request->start_date)) $query->whereDate('pick_up_date', '>=', $request->start_date);
                if (!empty($request->ending_date)) $query->whereDate('pick_up_date', '<=', $request->ending_date);
                if (!empty($request->customer_id)) $query->where('customer_id', '=', $request->customer_id);
                if (!empty($request->driver_id)) $query->where('driver_id', '=', $request->driver_id);
            }

            switch ($search_type) {
                case 'reservation_no':
                    $query->where('id', $request->reservation_number);
                    break;
                case 'today_made_reservations':
                    $query->whereDate('created_at', '=', Carbon::today()->toDateString())->where('status', '!=', 'Cancelled');
                    break;
                case 'today_reservations':
                    $query->whereDate('pick_up_date', '=', Carbon::today()->toDateString())->where('status', '!=', 'Cancelled');
                    break;
                case 'tomorrow_reservations':
                    $query->whereDate('pick_up_date', '=', Carbon::tomorrow()->toDateString())->where('status', '!=', 'Cancelled');
                    break;
                case 'driver_today_pickups':
                    $query->whereDate('pick_up_date', '=', Carbon::today()->toDateString());
                    break;
                case 'driver_tomorrow_pickups':
                    $query->whereDate('pick_up_date', '=', Carbon::tomorrow()->toDateString());
                    break;
                case 'new_reservation':
                    $query->where('status', '=', 'new_reservation');
                    break;
                case 'departures':
                    $query->where('service_type_id', '=', 1)->where('airport_ride', '=', 'to_airport');
                    break;
                case 'departures_completed':
                    $query->where('service_type_id', '=', 1)->where('airport_ride', '=', 'to_airport')->where('driver_status', '=', 'Completed');
                    break;
                case 'arrivals':
                    $query->where('service_type_id', '=', 1)->where('airport_ride', '=', 'from_airport');
                    break;
                case 'arrivals_completed':
                    $query->where('service_type_id', '=', 1)->where('airport_ride', '=', 'from_airport')->where('driver_status', '=', 'Completed');
                    break;
                case 'cancelled':
                    $query->where('status', '=', 'Cancelled');
                    break;

                case 'completed':
                    $query->where('driver_status', '=', 'Completed');
                    break;
                case 'p_to_p':
                    $query->where('service_type_id', '=', 3);
                    break;
                case 'p_to_p_completed':
                    $query->where('service_type_id', '=', 3)->where('driver_status', '=', 'Completed');
                    break;
                case 'cash_completed':
                    $query->where('status', '=', 'Cash Completed');
                    break;
                case 'no_show':
                    $query->where('status', '=', 'No Show');
                    break;
                case 'no_run':
                    $query->where('status', '=', 'No Run');
                    break;
                case 'payment_type':
                    $query->where('pay_type_id', '=', $request->payment_method); // Replace 'payment_type' with the actual column name
                    break;
                case 'company_id':
                    $query->where('site_id', '=', $request->company_name); // Replace 'company_id' with the actual column name
                    break;
                default:
            }

            // if($search_type !== 'cancelled' && $search_type !== 'all_reservation'){
            //     $query->where('status', '!=', 'Cancelled');
            // }

            if ($search_type === 'today_made_reservations')
                $reservations = $query->orderBy('id', 'ASC')->get();
            else
                $reservations = $query->orderBy('pick_up_date', 'ASC')->orderBy('pick_up_time', 'ASC')->get();

            return response()->json($reservations, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getAllReservationInfo()
    {
        try {
            $obj = new stdClass();

            $vehicles = Vehicle::select('id', 'vehicles_type')->get();
            $drivers = Driver::select('id', 'first_name', 'last_name', 'cell_phone', 'email')->where('is_active', 1)->where('is_duty_status_active', 1)->get();

            $obj->vehicles = $vehicles;
            $obj->drivers = $drivers;

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function saveReservationWithUser(Request $request)
    {
        try {

            $existingCustomer = Customer::where('mobile_number', $request->customer_information['mobile_number'])
                ->orWhere('phone_number', $request->customer_information['phone_number'])
                ->orWhere('email', $request->customer_information['email'])
                ->first();

            if ($existingCustomer) {
                // Customer already exists, update the existing record
                $customer_obj = $existingCustomer;

                $customerAttributes = [
                    'card_type', 'cc_number', 'cc_expiry', 'csv_code',
                    'cc_status', 'billing_zip_code', 'card_holder_name', 'billing_address', 'billing_phone_number', 'site_id', 'pay_type_id', 'cheque_number'
                ];

                foreach ($customerAttributes as $attribute) {
                    if ($customer_obj->$attribute !== $request->customer_information[$attribute]) {
                        $customer_obj->$attribute = $request->customer_information[$attribute];
                    }
                }

                if ($request->customer_information['pay_type_id'] == 3) {
                    $customer_obj->card_type = $request->customer_information['card_type'];
                    $customer_obj->cc_number = $request->customer_information['cc_number'];
                    $customer_obj->csv_code = $request->customer_information['csv_code'];
                    $customer_obj->billing_zip_code = $request->customer_information['billing_zip_code'];
                    $customer_obj->card_holder_name = $request->customer_information['card_holder_name'];

                    // Credit card expiration date format making
                    $cc_expiry_month = $request->customer_information['cc_expiry_month'];
                    $cc_expiry_year = $request->customer_information['cc_expiry_year'];

                    $customer_obj->cc_expiry = $cc_expiry_month . '-' . $cc_expiry_year;
                } else if ($request->customer_information['pay_type_id'] == 4) {
                    $customer_obj->direct_account_id = $request->customer_information['direct_account_id'];
                } else if ($request->customer_information['pay_type_id'] == 2) {
                    $customer_obj->cheque_number = $request->customer_information['cheque_number'];
                }

                $customer_obj->save();
            } else {
                // Customer does not exist, create a new record
                $customer_obj = new Customer();
            }

            $customer_obj->pay_type_id = $request->customer_information['pay_type_id'];
            $customer_obj->first_name = $request->customer_information['first_name'];
            $customer_obj->last_name = $request->customer_information['last_name'];
            $customer_obj->phone_number = $request->customer_information['phone_number'];
            $customer_obj->mobile_number = $request->customer_information['mobile_number'];
            $customer_obj->email = $request->customer_information['email'];
            $customer_obj->status = 'Registered Customer';

            if (isset($request->customer_information['password'])) {
                $customer_obj->password = bcrypt($request->customer_information['password']);
                $customer_obj->readable_password = $request->customer_information['password'];
            }

            $customer_obj->customer_type = 'registered';
            $customer_obj->is_address_same = $request->customer_information['is_address_same'] ?? $request->customer_information['is_address_same'];

            if ($request->customer_information['pay_type_id'] == 3) {
                $customer_obj->card_type = $request->customer_information['card_type'];
                $customer_obj->cc_number = $request->customer_information['cc_number'];
                $customer_obj->csv_code = $request->customer_information['csv_code'];
                $customer_obj->billing_zip_code = $request->customer_information['billing_zip_code'];
                $customer_obj->card_holder_name = $request->customer_information['card_holder_name'];

                // Credit card expiration date format making
                $cc_expiry_month = $request->customer_information['cc_expiry_month'];
                $cc_expiry_year = $request->customer_information['cc_expiry_year'];

                $customer_obj->cc_expiry = $cc_expiry_month . '-' . $cc_expiry_year;
            } else if ($request->customer_information['pay_type_id'] == 4) {
                $customer_obj->direct_account_id = $request->customer_information['direct_account_id'];
            } else if ($request->customer_information['pay_type_id'] == 2) {
                $customer_obj->cheque_number = $request->customer_information['cheque_number'];
            }

            $customer_obj->is_important_info = $request->customer_information['is_important_info'] ? $request->customer_information['is_important_info'] : 0;
            $customer_obj->is_discount_promotion = $request->customer_information['is_discount_promotion'] ? $request->customer_information['is_discount_promotion'] : 0;



            $customer_obj->save();

            if ($request->is_round_trip) {
                // For round trip reservations

                // Create first reservation
                $firstReservation = $this->store($request, $customer_obj->id, 'registered', $request->customer_information['pay_type_id'], false);
                // Create second reservation
                $secondReservation = $this->store($request, $customer_obj->id, 'registered', $request->customer_information['pay_type_id'], true);

                // Update Round Trip ID
                Reservation::where('id', $firstReservation['id'])
                    ->update(['round_trip' => $secondReservation['id']]);

                Reservation::where('id', $secondReservation['id'])
                    ->update(['round_trip' => $firstReservation['id']]);


                return response()->json([$firstReservation, $secondReservation, $customer_obj], 200);
            } else if ($request->is_schedule_round_trip) {
                // For schedule round trip reservations

                // Create first reservation
                $firstReservation = $this->store($request, $customer_obj->id, 'registered', $request->customer_information['pay_type_id'], false);

                // Create second reservation
                $secondReservation = $this->store($request, $customer_obj->id, 'registered', $request->customer_information['pay_type_id'], true);

                // Update Round Trip ID
                Reservation::where('id', $firstReservation['id'])
                    ->update(['round_trip' => $secondReservation['id']]);

                Reservation::where('id', $secondReservation['id'])
                    ->update(['round_trip' => $firstReservation['id']]);


                return response()->json([$firstReservation, $secondReservation, $customer_obj], 200);
            } else {
                //create single reservation
                $singleReservation = $this->store($request, $customer_obj->id, 'registered', $request->customer_information['pay_type_id'], false);

                unset($singleReservation['customer_notes']);

                return response()->json([$singleReservation, $customer_obj], 200);
            }
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function saveReservationWithGuestUser(Request $request)
    {
        try {
            // dd($request->all());
            $existingGuestCustomer = GuestCustomer::where('mobile_number', $request->customer_information['mobile_number'])
                ->orWhere('phone_number', $request->customer_information['phone_number'])
                ->orWhere('email', $request->customer_information['email'])
                ->first();
            if ($existingGuestCustomer) {

                $guest_customer = $existingGuestCustomer;
            } else {
                // Customer does not exist, create a new record
                $guest_customer = new GuestCustomer();
            }

            $guest_customer->first_name = $request->customer_information['first_name'];
            $guest_customer->last_name = $request->customer_information['last_name'];
            $guest_customer->phone_number = $request->customer_information['phone_number'];
            $guest_customer->mobile_number = $request->customer_information['mobile_number'];
            $guest_customer->email = $request->customer_information['email'];
            $guest_customer->status = 'Guest Customer';
            $guest_customer->address = $request->pick_up_address;

            $guest_customer->customer_type = 'guest';
            $guest_customer->is_address_same = $request->customer_information['is_address_same']  ?? $request->customer_information['is_address_same'];
            $guest_customer->pay_type_id = $request->customer_information['pay_type_id'];

            if ($request->customer_information['pay_type_id'] == 3) {

                $guest_customer->card_type = $request->customer_information['card_type'];
                $guest_customer->cc_number = $request->customer_information['cc_number'];
                $guest_customer->csv_code = $request->customer_information['csv_code'];
                $guest_customer->billing_zip_code = $request->customer_information['billing_zip_code'];
                $guest_customer->card_holder_name = $request->customer_information['card_holder_name'];

                // Credit card expiration date format making
                $cc_expiry_month = $request->customer_information['cc_expiry_month'];
                $cc_expiry_year = $request->customer_information['cc_expiry_year'];

                $guest_customer->cc_expiry = $cc_expiry_month . '-' . $cc_expiry_year;
            }
            if ($request->customer_information['pay_type_id'] == 2) {

                $guest_customer->cheque_number = $request->customer_information['cheque_number'];
            }

            // dd($guest_customer);
            $guest_customer->save();
            $payTypeId = $request->customer_information['pay_type_id'];


            if ($request->is_round_trip) {
                // For round trip reservations

                // Create first reservation
                $firstReservation = $this->store($request, $guest_customer->id, 'Guest', $payTypeId, false);
                // Create second reservation
                $secondReservation = $this->store($request, $guest_customer->id, 'Guest', $payTypeId, true);

                // Update Round Trip ID
                Reservation::where('id', $firstReservation['id'])
                    ->update(['round_trip' => $secondReservation['id']]);

                Reservation::where('id', $secondReservation['id'])
                    ->update(['round_trip' => $firstReservation['id']]);

                return response()->json([$firstReservation, $secondReservation, $guest_customer], 200);
            } else if ($request->is_schedule_round_trip) {
                // For schedule round trip reservations

                // Create first reservation
                $firstReservation = $this->store($request, $guest_customer->id, 'Guest', $payTypeId, false);
                // Create second reservation
                $secondReservation = $this->store($request, $guest_customer->id, 'Guest', $payTypeId, true);

                Reservation::where('id', $firstReservation['id'])
                    ->update(['round_trip' => $secondReservation['id']]);

                Reservation::where('id', $secondReservation['id'])
                    ->update(['round_trip' => $firstReservation['id']]);

                return response()->json([$firstReservation, $secondReservation, $guest_customer], 200);
            } else {
                //create single reservation
                $singleReservation = $this->store($request, $guest_customer->id, 'Guest', $payTypeId, false);
                unset($singleReservation['customer_notes']);

                return response()->json([$singleReservation, $guest_customer], 200);
            }
            // DB::commit();
        } catch (\Exception $exception) {
            // DB::rollback();
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function saveCustomerNotes(Request $request)
    {
        try {
            if ($request->customer_type == 'Registered' || $request->customer_type == 'registered') {
                $customer_obj = Customer::findOrFail($request->customer_id);
                $customer_obj->notes = $request->notes;
            }

            if ($request->customer_type == 'Guest' || $request->customer_type == 'guest') {
                $customer_obj = GuestCustomer::findOrFail($request->customer_id);
                $customer_obj->notes = $request->notes;
            }

            $customer_obj->save();

            return response()->json(['message' => 'Notes added successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function updateDriverInfo(Request $request)
    {
        try {
            $blocked_driver = BlockDriver::where('driver_id', $request->driver_id)
                ->where('customer_id', $request->customer_id)
                ->where('blocked', 1)
                ->first();

            if (!isset($blocked_driver)) {
                $reservation_obj = Reservation::findOrFail($request->reservation_id);

                $reservation_obj->driver_id = $request->driver_id?$request->driver_id:null;
                $reservation_obj->driver_status = null;

                $reservation_obj->is_driver_email_sent = null;

                $reservation_obj->save();

                //emailDriver($request->driver_id, $request->reservation);

                return response()->json(['message' => 'Driver assigned successfully'], 201);
            } else {
                return response()->json('Driver Blocked for this Customer');
            }
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getAllAirportData()
    {
        try {
            $obj = new stdClass();
            $obj->allAirports = Airport::select('id', 'name', 'airport_location')
                ->where('is_active', 1)
                ->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function findReservationPage(){
        return view('frontend.Find-Reservation.index');
    }
    public function findReservation(Request $request)
    {
        try {
            // Validation
            $validator = Validator::make($request->all(), [
                'confirm_number' => 'required|numeric',
            ]);

            if ($validator->fails()) {
                return response()->json(['error' => $validator->errors()], 422);
            }

            // Extract variables
            $confirmNumber = $request->confirm_number;
            $lastName = $request->last_name;
            $mobileNumber = $request->mobile_number;
            $billingZipCode = $request->billing_zip_code;

            $customerId = null;

            // Determine which customer ID to use based on available information
            if ($lastName) {
                $customerId = Customer::where('last_name', $lastName)->pluck('id')->first();
            } elseif ($mobileNumber) {
                $customerId = Customer::where('phone_number', $mobileNumber)
                    ->orWhere('mobile_number', $mobileNumber)
                    ->pluck('id')
                    ->first();
            } elseif ($billingZipCode) {
                $customerId = Customer::where('billing_zip_code', $billingZipCode)->pluck('id')->first();
            }

            // Find reservation
            $reservation = null;
            if ($customerId) {
                $reservation = Reservation::where('id', $confirmNumber)
                    ->with('customer')
                    ->where('customer_id', $customerId)
                    ->latest('created_at')
                    ->first();
            }

            return response()->json($reservation, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }


    public function updateReservationStatus($reservationId, $reservationStatus = null)
    {
        try {
            // dd(Request()->all());
            $reservation_obj = Reservation::findOrFail($reservationId);

            $reservation_obj->status = $reservationStatus ? $reservationStatus : null;

            $reservation_obj->save();

            return response()->json(['message' => 'Reservation status saved successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function updateCCStatus($customerId, $customerType)
    {
        try {
            if ($customerType == 'Registered' || $customerType == 'registered') {
                $customer_obj = Customer::findOrFail($customerId);

                if ($customer_obj->cc_status) {
                    $customer_obj->cc_status = null;
                } else {
                    $customer_obj->cc_status = 'decline';
                }
            }

            if ($customerType == 'Guest' || $customerType == 'guest') {
                $customer_obj = GuestCustomer::findOrFail($customerId);
                if ($customer_obj->cc_status) {
                    $customer_obj->cc_status = null;
                } else {
                    $customer_obj->cc_status = 'decline';
                }
            }

            $customer_obj->save();

            return response()->json(['message' => 'Credit Card status update successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateReservation(Request $request)
    {
        try {
            // dd($request->is_on_call, $request->driver_gratuity, $request->admin_discount);

            $driverGratuity = floatval($request->driver_gratuity);
            // dd($request->reservation['customer']['mobile_number']);

            if ($request->reservation['customer_type'] == 'registered') {
                $existingCustomer = Customer::where('mobile_number', $request->reservation['customer']['mobile_number'])
                    ->orWhere('phone_number', $request->reservation['customer']['phone_number'])
                    ->orWhere('email', $request->reservation['customer']['email'])
                    ->orWhere('id', $request->reservation['customer_id'])
                    ->first();
            } else if ($request->reservation['customer_type'] == 'Guest') {
                $existingCustomer = GuestCustomer::where('mobile_number', $request->reservation['customer']['mobile_number'])
                    ->orWhere('phone_number', $request->reservation['customer']['phone_number'])
                    ->orWhere('email', $request->reservation['customer']['email'])
                    ->orWhere('id', $request->reservation['customer_id'])
                    ->first();
            }

            // dd($existingCustomer);

            if ($existingCustomer) {
                // Customer already exists, update the existing record
                $customer_obj = $existingCustomer;
                $customerAttributes = [
                    'card_type', 'cc_number', 'cc_expiry', 'csv_code',
                    'cc_status', 'billing_zip_code', 'card_holder_name', 'billing_address', 'billing_phone_number', 'site_id', 'pay_type_id', 'cheque_number'
                ];

                foreach ($customerAttributes as $attribute) {
                    if ($customer_obj->$attribute !== $request->reservation['customer'][$attribute]) {
                        $customer_obj->$attribute = $request->reservation['customer'][$attribute];
                    }
                }

                if ($request->reservation['customer']['pay_type_id'] == 3) {
                    $customer_obj->card_type = $request->reservation['customer']['card_type'];
                    $customer_obj->cc_number = $request->reservation['customer']['cc_number'];
                    $customer_obj->csv_code = $request->reservation['customer']['csv_code'];
                    $customer_obj->billing_zip_code = $request->reservation['customer']['billing_zip_code'];
                    $customer_obj->card_holder_name = $request->reservation['customer']['card_holder_name'];

                    // Credit card expiration date format making
                    $cc_expiry_month = $request->reservation['customer']['cc_expiry_month'];
                    $cc_expiry_year = $request->reservation['customer']['cc_expiry_year'];

                    $customer_obj->cc_expiry = $cc_expiry_month . '-' . $cc_expiry_year;
                } else if ($request->reservation['customer']['pay_type_id'] == 4) {
                    $customer_obj->direct_account_id = $request->reservation['customer']['direct_account_id'];
                } else if ($request->reservation['customer']['pay_type_id'] == 2) {
                    $customer_obj->cheque_number = $request->reservation['customer']['cheque_number'];
                }

                $customer_obj->pay_type_id = $request->reservation['customer']['pay_type_id'];
                $customer_obj->first_name = $request->reservation['customer']['first_name'];
                $customer_obj->last_name = $request->reservation['customer']['last_name'];
                $customer_obj->phone_number = $request->reservation['customer']['phone_number'];
                $customer_obj->mobile_number = $request->reservation['customer']['mobile_number'];
                $customer_obj->email = $request->reservation['customer']['email'];



                $customer_obj->save();

                // dd($customer_obj);
            }

            // dd('here');
            $pickUpDateTime = Carbon::parse($request->reservation['pick_up_date'] . ' ' . $request->reservation['pick_up_time']);
            $currentDateTime = Carbon::now();

            // Calculate the difference in hours between the pick-up date/time and current date/time
            $hoursDifference = $currentDateTime->diffInHours($pickUpDateTime);

            if ($hoursDifference > 12 || $request->is_admin) {
                // Less than 12 hours left for the reservation
                $reservation = Reservation::findOrFail($request->reservation['id']);
                // dd($reservation);
                $dataToUpdate = [
                    'airport_ride' => $request->reservation['airport_ride'],
                    'departure_pick_up_date' => $request->reservation['departure_pick_up_date'],
                    'departure_pick_up_time' => $request->reservation['departure_pick_up_time'],
                    'distance' => $request->reservation['distance'],
                    'drop_off_location' => $request->reservation['drop_off_location'],
                    'flight_number' => $request->reservation['flight_number'],
                    'home_drop_off_location' => $request->reservation['home_drop_off_location'],
                    'home_pick_up_location' => $request->reservation['home_pick_up_location'],
                    'luggage' => $request->reservation['luggage'],
                    'pick_up_date' => $request->reservation['pick_up_date'],
                    'pick_up_location' => $request->reservation['pick_up_location'],
                    'pick_up_time' => $request->reservation['pick_up_time'],

                    'ride_type' => $request->reservation['ride_type'],
                    'round_trip' => $request->reservation['round_trip'],
                    'selected_airline' => $request->reservation['selected_airline'],
                    'selected_flight_destination' => $request->reservation['selected_flight_destination'],
                    'service_type_id' => $request->reservation['service_type_id'],
                    'time_duration_text' => $request->reservation['time_duration_text'],
                    'additional_stops' => $request->reservation['additional_stops'],
                    'travellers' => $request->reservation['travellers'],
                    'travellers_types' => $request->reservation['travellers_types'],
                    'vehicle_type_id' => $request->reservation['vehicle_type_id'],
                    'vehicles_count' => $request->reservation['vehicles_count'],
                    'drop_off_hours' => $request->reservation['drop_off_hours'],
                    'customer_notes' => $request->reservation['customer_notes'],
                    'pay_type_id' => $request->reservation['customer']['pay_type_id'],
                    'admin_discount' => $request->admin_discount,
                    'driver_gratuity' => $driverGratuity,
                    'is_on_call' => $request->is_on_call,
                ];

                if ($request->reservation['service_type_id'] !== 4 && isset($request->reservation['selected_service'])) {
                    if ($request->reservation['selected_service']['ride_type'] == 'millage') {
                        // If service selected for millage ride type
                        $dataToUpdate['ride_type'] = $request->reservation['selected_service']['ride_type'];
                    } else if ($request->reservation['selected_service']['ride_type'] == 'hourly') {
                        // If service selected for hourly ride type
                        $dataToUpdate['ride_type'] = $request->reservation['selected_service']['ride_type'];
                    } else {
                        return response()->json(['message' => 'Invalid ride type provided'], 400);
                    }
                }

                Reservation::where('id', $request->reservation['id'])->update($dataToUpdate);
                return response()->json(['message' => 'Reservation updated successfully'], 201);
            } else {
                // More than or equal to 12 hours left for the reservation
                return response()->json(['message' => 'Reservation Cannot be updated now'], 403);
            }
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function updateScheduleReservation(Request $request)
    {
        try {
            // dd($request->all(), $request->form_data);

            // if(isset($request->reservation['pick_up_date'])){
            //     $pickUpDateTime = Carbon::parse($request->reservation['pick_up_date'] . ' ' . $request->reservation['pick_up_time']);
            //     $currentDateTime = Carbon::now();
            // }
            // else
            if (isset($request->form_data['pick_up_date'])) {
                $pickUpDateTime = Carbon::parse($request->form_data['pick_up_date'] . ' ' . $request->reservation['pick_up_time']);
                $currentDateTime = Carbon::now();
            }
            if (isset($request->form_data['departure_pick_up_date'])) {
                $pickUpDateTime = Carbon::parse($request->form_data['departure_pick_up_date'] . ' ' . $request->reservation['departure_pick_up_time']);
                $currentDateTime = Carbon::now();
            }

            // Calculate the difference in hours between the pick-up date/time and current date/time
            $hoursDifference = $currentDateTime->diffInHours($pickUpDateTime);

            if ($hoursDifference > 12 || $request->is_admin) {
                // Less than 12 hours left for the reservation
                $reservation_obj = Reservation::findOrFail($request->reservation['id']);

                // dd($request->new_selected_service['shuttle_name']);

                $reservation_obj->shuttle_name = isset($request->new_selected_service['shuttle_name']) ? $request->new_selected_service['shuttle_name'] : $reservation_obj->shuttle_name;
                // $reservation_obj->schedule_service_type = $request->reservation['schedule_service_type'];
                // $reservation_obj->vehicle_type_id = $request->reservation['vehicle_type_id'];
                $reservation_obj->departure_pick_up_date = $request->form_data['departure_pick_up_date'] ?? null;
                $reservation_obj->departure_pick_up_time = $request->form_data['departure_pick_up_time'] ?? null;
                $reservation_obj->pick_up_date = $request->form_data['pick_up_date'];

                // dd($reservation_obj);

                $reservation_obj->pick_up_time = $request->form_data['home_pick_up_time'];
                $reservation_obj->drop_off_time = $request->reservation['drop_off_time'];

                $reservation_obj->travellers = $request->reservation['travellers'];
                $reservation_obj->luggage = $request->reservation['luggage'];
                $reservation_obj->check_in_bags = $request->reservation['check_in_bags'];
                $reservation_obj->pick_up_location = isset($request->new_selected_service['pick_up_location']) ? $request->new_selected_service['pick_up_location'] : $reservation_obj->pick_up_location;
                $reservation_obj->drop_off_location = isset($request->new_selected_service['drop_off_location']) ? $request->new_selected_service['drop_off_location'] : $reservation_obj->drop_off_location;
                $reservation_obj->selected_airline = $request->reservation['selected_airline'] ? $request->reservation['selected_airline'] : null;
                $reservation_obj->selected_flight_destination = $request->reservation['selected_flight_destination'] ? $request->reservation['selected_flight_destination'] : null;
                $reservation_obj->flight_number = $request->reservation['flight_number'] ? $request->reservation['flight_number'] : null;

                // dd($reservation_obj);

                if (isset($request->reservation['scheduleServiceAdditionInformation']['schedule_pick_up_location']) && isset($request->reservation['scheduleServiceAdditionInformation']['schedule_pick_up_location']['address'])) {
                    $reservation_obj->home_pick_up_location = $request->reservation['scheduleServiceAdditionInformation']['schedule_pick_up_location']['address'];
                }
                if (isset($request->reservation['scheduleServiceAdditionInformation']['schedule_pick_up_location']) && isset($request->reservation['scheduleServiceAdditionInformation']['schedule_pick_up_location']['address'])) {
                    $reservation_obj->home_drop_off_location = $request->reservation['scheduleServiceAdditionInformation']['schedule_drop_off_location']['address'];
                }

                if ($request->reservation['ride_type'] == 'airport' && $request->reservation['airport_ride_type'] == 'to_airport') {
                    $reservation_obj->airport_ride = $request->reservation['airport_ride_type'];
                    if (isset($request->reservation['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address']) && isset($request->reservation['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address']['address'])) {
                        $reservation_obj->home_pick_up_location = $request->reservation['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address'];
                    }
                }
                if ($request->reservation['ride_type'] == 'airport' && $request->reservation['airport_ride_type'] == 'from_airport') {
                    $reservation_obj->airport_ride = $request->reservation['airport_ride_type'];
                    if (isset($request->reservation['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address']) && isset($request->reservation['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address']['address'])) {
                        $reservation_obj->home_drop_off_location = $request->reservation['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address'] !== '' ? $request->reservation['scheduleServiceAdditionInformation']['schedule_pick_up_or_drop_off_location']['address'] : '';
                    }
                }

                $reservation_obj->vehicle_capacity = $request->reservation['vehicle_capacity'] ? $request->reservation['vehicle_capacity'] : null;

                $reservation_obj->distance = $request->reservation['distance'] ? $request->reservation['distance'] : null;
                $reservation_obj->time_duration_text = $request->reservation['time_duration_text'] ? $request->reservation['time_duration_text'] : null;
                // $reservation_obj->time_duration_hours = $request->reservation['time_duration_hours'] ? $request->reservation['time_duration_hours'] : null;

                $reservation_obj->additional_millage_charges = $request->reservation['additional_millage_charges'];
                $reservation_obj->timely_millage_charges = $request->reservation['timely_millage_charges'];

                // dd($reservation_obj);

                $reservation_obj->save();

                return response()->json(['message' => 'Reservation updated successfully'], 201);
            } else {
                // More than or equal to 12 hours left for the reservation
                return response()->json(['message' => 'Reservation Cannot be updated now'], 403);
            }
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function updateCustomer(Request $request)
    {

        try {
            $customer = Customer::find($request->customer_data['id']);

            $customer->first_name = $request->customer_data['first_name'];
            $customer->last_name = $request->customer_data['last_name'];
            $customer->phone_number = $request->customer_data['phone_number'];
            $customer->mobile_number = $request->customer_data['mobile_number'];
            $customer->email = $request->customer_data['email'];
            $customer->card_type = $request->customer_data['card_type'];
            $customer->cc_number = $request->customer_data['cc_number'];
            $customer->cc_expiry = $request->customer_data['cc_expiry'];
            $customer->csv_code = $request->customer_data['csv_code'];
            $customer->billing_zip_code = $request->customer_data['billing_zip_code'];
            $customer->card_holder_name = $request->customer_data['card_holder_name'];
            // $customer->billing_address = $request->customer_data['billing_address']['address'] ? $request->customer_data['billing_address']['address'] : null;
            $customer->billing_phone_number = $request->customer_data['billing_phone_number'];

            $customer->save();

            return response()->json(['message' => 'Customer update successfully'], 201);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function blockDriver(Request $request)
    {

        $blocked_driver = BlockDriver::where('customer_id', $request->customer_id)
            ->where('driver_id', $request->driver_id)
            ->first();

        if (!isset($blocked_driver)) {
            $block_driver = new BlockDriver();

            $block_driver->user_id = Auth::id();
            $block_driver->customer_id = $request->customer_id;
            $block_driver->driver_id = $request->driver_id;
            $block_driver->reservation_id = $request->reservation_id;
            $block_driver->reason = $request->reason;

            $block_driver->save();

            return response()->json(['message' => 'Driver Blocked successfully'], 201);
        } else if (isset($blocked_driver) && $blocked_driver->is_active === 0) {
            $blocked_driver->is_active = 1;
            $blocked_driver->save();
            return response()->json(['message' => 'Driver Blocked successfully'], 201);
        } else {
            return response()->json(['message' => 'Driver already Blocked for this Customer'], 201);
        }
    }

    public function blockedDriversIndex()
    {

        //Group By driver ID
        // $blockedDrivers = DB::table('blocked_drivers as bd')
        // ->select(
        //     DB::raw("GROUP_CONCAT(CONCAT(c.first_name, ' ', c.last_name, ' (', bd.reservation_id, ')') SEPARATOR ', ') AS customer_names"),
        //     DB::raw("CONCAT(d.first_name, ' ', d.last_name) AS driver_names"),
        //     DB::raw("GROUP_CONCAT(bd.reason SEPARATOR ', ') AS reasons"),
        //     'bd.blocked',
        //     'bd.id'

        // )
        // ->join('customers as c', 'bd.customer_id', '=', 'c.id')
        // ->join('drivers as d', 'bd.driver_id', '=', 'd.id')
        // ->groupBy('bd.driver_id')
        // ->get();

        $blockedDrivers = BlockDriver::with('customers:id,first_name,last_name,cc_number', 'drivers:id,first_name,last_name')->orderBy('updated_at', 'DESC')->get();

        return view('admin.blocked-drivers.index', [
            'blockedDrivers' => $blockedDrivers
        ]);
    }

    public function getFormData()
    {
        $obj = new stdClass();

        $obj->allDrivers = Driver::select('id', 'category_id', 'first_name', 'last_name')->get();
        $obj->allCustomers = Customer::select('id', 'first_name', 'last_name')->get();

        return response()->json($obj, 200);
    }

    public function updateIsActive(Request $request, $id)
    {
        try {

            // dd($blockedDriverStatus,$blockCustomer);
            BlockDriver::whereId($id)->update([
                'blocked' => $request->status
            ]);

            // Fetch the BlockDriver record
            // $blockedDriverStatus = BlockDriver::where('id', $id)->select('id', 'customer_id', 'blocked')->first();

            // // If the record exists
            // if ($blockedDriverStatus) {
            //     // Get all BlockDriver records with the same customer_id
            //     $blockCustomers = BlockDriver::whereIn('customer_id', explode(',', $blockedDriverStatus->customer_id))->get();

            //     // Update the status for each matching record
            //     foreach ($blockCustomers as $blockCustomer) {
            //         $blockCustomer->blocked = $request->status; // Set the new status here
            //         $blockCustomer->save();
            //     }
            // }

            return response()->json(['message' => 'Blocked Driver Status updated successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function checkCouponValidation(Request $request)
    {
        $vehicleTypeId = $request->input('vehicle_type_id');

        $coupon = Coupon::select('id', 'coupon_type', 'coupon_price')
            ->where('coupon_code', $request->input('coupon_code'))
            ->where('city_id', $request->input('city_id'))
            ->where('service_id', $request->input('service_type_id')) //Add where clause fro checking service type e.g Airport, Hourly etc
            ->whereJsonContains('vehicle_make_ids', $vehicleTypeId) // Add whereJsonContains clause for vehicle type
            ->where('expiry_date', '>=', $request->input('pick_up_date')) // Add whereDate clause to check expiry date with pickup date
            ->where('is_active', 1)
            ->first();

        return response()->json($coupon, 200);
    }

    public function getData()
    {
        try {
            $obj = new stdClass();

            $obj->pay_types = PayType::select('id', 'name')
                ->where('is_active', 1)
                ->get();

            $obj->direct_accounts = DirectAccount::select('id', 'account_number', 'account_name')
                ->where('is_active', 1)
                ->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function editFlightInformation($id, Request $request)
    {

        // dd($request->all());
        try {
            $previousReservation = Reservation::where('id', $id)
                ->select('id', 'selected_airline', 'flight_number', 'selected_flight_destination', 'site_id', 'customer_id')
                ->first();
            // dd($previousReservation);
            $reservation = Reservation::findOrFail($id);
            $reservation->selected_airline = $request->airline;
            $reservation->flight_number = $request->flight_number;
            $reservation->selected_flight_destination = $request->flight_destination;

            // dd($reservation);
            $reservation->save();
            $updatedReservation = Reservation::where('id', $id)
                ->select('id', 'selected_airline', 'flight_number', 'selected_flight_destination', 'customer_id')
                ->first();

            emailFlightInfo($request->driver_id, $request->customer_id, $request->customer_type, $previousReservation, $updatedReservation);
            return response()->json(['message' => 'Edit Flight Information Successfully']);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function editFlightDateTimeInformation($id, Request $request)
    {

        // dd($request->all());
        try {
            $previousReservation = Reservation::where('id', $id)
                ->select('id', 'pick_up_time', 'pick_up_date', 'site_id', 'customer_id')
                ->first();
            $reservation = Reservation::findOrFail($id);
            $reservation->pick_up_time = $request->pick_up_time;
            $reservation->pick_up_date = $request->pick_up_date;
            $reservation->departure_pick_up_date = $request->departure_pick_up_date;
            $reservation->departure_pick_up_time = $request->departure_pick_up_time;

            // dd($reservation);
            $reservation->save();
            $updatedReservation = Reservation::where('id', $id)
                ->select('id', 'pick_up_time', 'pick_up_date', 'customer_id')
                ->first();
            emailFlightTime($request->driver_id, $request->customer_id, $request->customer_type, $previousReservation, $updatedReservation);

            return response()->json(['message' => 'Edit Flight Date Or Time Successfully']);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getEditFlightInformation()
    {
        try {
            $obj = new stdClass();
            $obj->allAirlines = Airline::select('id', 'airline_name')->where('is_active', 1)->get();
            $obj->allFlightDestinations = FlightDestination::select('id', 'name', 'code')->where('is_active', 1)->get();
            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function getAllSites()
    {
        try {
            $allSites = Site::select('id', 'code', 'site_name')->where('is_active', 1)->get();
            // dd($obj);
            return response()->json($allSites, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function updateDriverStatus(Request $request)
    {

        // dd($request->all());
        try {
            $reservation = Reservation::findOrFail($request->reservation_id);
            $reservation->driver_status = $request->driver_status;
            $reservation->save();
            return response()->json(['message' => 'Updated Driver Status'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
    public function cancelReservationStatus(Request $request)
    {

        try {
            $reservation = Reservation::findOrFail($request->reservation_id);

            $reservation->status = 'Cancelled';

            if ($request->cancel_reason == 'other') {
                $reservation->cancellation_reason = $request->other_cancel_reason;
            } else {
                $reservation->cancellation_reason = $request->cancel_reason;
            }
            $reservation->save();

            $this->sendCancelEmail($request->reservation_id);

            if($request->cancel_round_trip) {
                $reservationRoundTrip = Reservation::findOrFail($request->cancel_round_trip);
                $reservationRoundTrip->status = 'Cancelled';
                $reservationRoundTrip->cancellation_reason = $reservation->cancellation_reason;
                $reservationRoundTrip->save();
                $this->sendCancelEmail($request->cancel_round_trip);

            }


            return response()->json(['message' => 'Updated Reservation Status'],200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function sendCancelEmail($reservation_id){

        $reservation = Reservation::with('customer')->findOrFail($reservation_id);

        $pickupDateTime = Carbon::parse($reservation->pick_up_date . ' ' . $reservation->pick_up_time)->format('m/d/Y h:i A');
        $departurePickupDateTime = Carbon::parse($reservation->departure_pick_up_date . ' ' . $reservation->departure_pick_up_time)->format('m/d/Y h:i A');

        // dd($request->all());
        $mail_message_customer = '<html>
                                    <head>
                                </head>
                                <body>
                                    <h2>Reservation # ' . $reservation->id . ' Cancelled</h2>
                                    <table>
                                        <tr><th style="text-align:left;">Pickup Date & Time: </th><td>' . $pickupDateTime . '</td></tr>
                                        <tr><th style="text-align:left;">Pax Details: </th><td>' . collect($reservation->travellers_types)->sum('count') . '</td></tr>
                                    </table>
                                    </body>
                                </html>';



        if ($reservation->service_type_id == 1 && $reservation->airport_ride == 'to_airport') {
            $resv_type = "Departure";
        } elseif ($reservation->service_type_id == 1 && $reservation->airport_ride == 'from_airport') {
            $resv_type  = "Arrival";
        } else {
            $resv_type  = "Around Town";
        }

        if ($reservation->driver_id) {

            $driver             =    Driver::with('cellPhoneProvider')->findOrFail($reservation->driver_id);
            $driver_name        =    $driver->first_name . " " . $driver->last_name;
            $smsText = "Cancelled Reservation #" . $reservation->id . " " . $resv_type . ": ";
            //$smsText .= 'Pax#' . collect($reservation->travellers_types)->sum('count') . " ";
            $smsText .= 'Reason ' . $reservation->cancellation_reason;
            //$smsText .= '$' .  $reservation->total_fare . ' (' . $reservation->customer->mobile_number . ')' . " ";

            Mail::to($driver->email)->send(new MailHandler(
                $smsText,
                "Reservation #" . $reservation->id . " Cancelled!"
            ));
        }

        Mail::to($reservation->customer->email)->send(new MailHandler(
            $mail_message_customer,
            "Reservation #" . $reservation->id . " Cancelled!"
        ));
        return true;
    }

    public function getActivityLog($item_id)
    {
        try {
            $obj = new stdClass();

            $latestActivity = ActivityLog::where('item_id', $item_id)
                ->orderBy('id', 'desc')
                ->value('activity');

            $activityQuery = ActivityLog::where('item_id', $item_id);
            $userQuery = $activityQuery->clone()->where('role_id', '<>', 2)->select('user_id')->distinct();
            $driverQuery = $activityQuery->clone()->where('role_id', 2)->select('user_id')->distinct();
            $customerQuery = $activityQuery->clone()->whereNull('role_id')->select('customer_id')->distinct();

            if ($latestActivity == 'reset') {
                $activityQuery->whereIn('activity', ['reset', 'created', 'email']);
            } else {
                $activityQuery->where('activity', '!=', 'reset');
            }

            $obj->activity = $activityQuery->orderBy('id', 'desc')->get();
            $userIds = $userQuery->pluck('user_id');
            $driverIds = $driverQuery->pluck('user_id');
            $customerIds = $customerQuery->pluck('customer_id');

            $obj->user = $userIds->isNotEmpty()
                ? Employee::whereIn('user_id', $userIds)->select('id', 'user_id', 'first_name', 'last_name')->get()
                : null;
            $obj->driver = $driverIds->isNotEmpty()
                ? Driver::whereIn('id', $driverIds)->select('id', 'user_id', 'first_name', 'last_name')->get()
                : null;
            $obj->customer = $customerIds->isNotEmpty()
                ? Customer::whereIn('id', $customerIds)->select('id', 'first_name', 'last_name', 'cc_number')->get()
                : null;
            $obj->roles = UserGroup::where('id', '!=', 2)->select('id', 'name')->get();

            return response()->json($obj, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }


    public function giveDiscount(Request $request)
    {
        // dd($request->all());
        try {
            $reservation = Reservation::findOrFail($request->reservation_id);
            if(!$reservation->admin_discount){
                $reservation->total_fare -= $request->admin_discount;
            }
            else{
                $totalFare = $reservation->admin_discount + $reservation->total_fare;
                $reservation->total_fare = $totalFare - $request->admin_discount;
            }
            $reservation->admin_discount = $request->admin_discount;

            $reservation->save();

            return response()->json(['message' => 'Discount is given !'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function resetReservation(Request $request)
    {
        try {
            $reservationId = $request->reservation_id;

            // Check if the latest activity against the item_id is already a reset
            $latestActivity = ActivityLog::where('item_id', $reservationId)
                ->orderBy('id', 'desc')
                ->value('activity');
            // dd($latestActivity);
            if ($latestActivity === 'reset' || $latestActivity === 'created') {
                return response()->json(['message' => 'Reservation has already been reset'], 200);
            }
            // Retrieve all relevant activity logs for the reservation
            $activityLogs = ActivityLog::where('item_id', $reservationId)
                ->whereNotNull('activity_detail')
                ->where('undo', '!=', 0)
                ->orderBy('id', 'desc')
                ->get();
            // Find the reservation
            // dd($activityLogs);
            $reservation = Reservation::find($reservationId);

            if (!$reservation) {
                return response()->json(['error' => 'Reservation not found'], 404);
            }

            // Reset reservation attributes based on activity logs
            foreach ($activityLogs as $activityLog) {
                $activityDetail = json_decode($activityLog->activity_detail, true);
                if (isset($activityDetail['round_trip']) && $activityDetail['round_trip']['before'] === null) {
                    continue; // Skip this iteration and move to the next one
                }
                foreach ($activityDetail as $attribute => $values) {
                    if ($values['before'] !== null) {
                        if ($attribute === 'customer_notes') {
                            // Reset 'customer_notes' in the Reservation table
                            $reservation->$attribute = $values['before'];
                            $reservation->save();

                            // Reset 'notes' in the Customer table based on customer type
                            if ($reservation->customer_type === 'Registered' || $reservation->customer_type === 'registered') {
                                $customer = Customer::find($reservation->customer_id);
                                if ($customer) {
                                    $customer->notes = null;
                                    $customer->save();
                                }
                            }
                        } else {
                            $reservation->$attribute = $values['before'];
                        }
                    } else {
                        // Check if the value is null and assign null explicitly
                        if ($values['before'] === null) {
                            $reservation->$attribute = null;
                        }
                    }
                }
            }

            // Log the reset activity
            $description = 'Reservation reset to initial state.';

            $currentRoute = URL::current();
            $user = Auth::user();
            $containsDriver = strpos($currentRoute, 'driver') !== false && strpos($currentRoute, 'admin') === false;
            $containsCustomer = strpos($currentRoute, 'with-user') !== false;
            //determineRoleId global function for role_id
            $roleId = determineRoleId($containsDriver, $containsCustomer, $user);
            ActivityLog::create([
                'user_id' => $user->id,
                'role_id' => $roleId,
                'ip_address' => request()->ip(),
                'company_id' => $reservation->site_id,
                'item_id' => $reservation->id,
                'table_name' => 'reservations',
                'activity' => 'reset',
                'activity_detail' => $activityLog->activity_detail, // Store the reset reservation data
                'route' => $currentRoute,
                'activity_description' => $description,
                'undo' => config('app.enums.UNDO_NA')

            ]);

            $reservation->undo =  config('app.enums.UNDO_TRUE');
            $reservation->save();

            return response()->json(['message' => 'Reservation reset successfully','reservation' => $reservation], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }


    public function undoLastReservation(Request $request)
    {
        try {

            $reservationId = $request->reservation_id;

            // Retrieve the specific activity log by ID
            $activityLog = ActivityLog::where('item_id', $reservationId)->where('undo', 1)->orderBy('id', 'desc')->first();

            // dd($activityLog);

            if (!$activityLog) {
                return response()->json(['message' => 'Reservation is on initial state'], 201);
            }
            if ($activityLog->activity == 'created' || $activityLog->activity == 'reset') {
                return response()->json(['message' => 'Unable to undo'], 201);
            }

            // Find the reservation
            $reservation = Reservation::find($reservationId);

            if (!$reservation) {
                return response()->json(['error' => 'Reservation not found'], 404);
            }

            // Extract activity details from the activity log
            $activityDetail = json_decode($activityLog->activity_detail, true);

            foreach ($activityDetail as $attribute => $values) {
                if ($attribute !== 'updated_at') {
                    if ($values['before'] !== null) {
                        if ($attribute === 'customer_notes') {
                            // Reset 'customer_notes' in the Reservation table
                            $reservation->$attribute = $values['before'];
                            $reservation->save();

                            // Reset 'notes' in the Customer table based on customer type
                            if ($reservation->customer_type === 'Registered' || $reservation->customer_type === 'registered') {
                                $customer = Customer::find($reservation->customer_id);
                                if ($customer) {
                                    $customer->notes = null;
                                    $customer->save();
                                }
                            } else if ($reservation->customer_type === 'Guest' || $reservation->customer_type === 'guest') {
                                $guestCustomer = GuestCustomer::find($reservation->customer_id);
                                if ($guestCustomer) {
                                    $guestCustomer->notes = null;
                                    $guestCustomer->save();
                                }
                            }
                        } else {
                            $reservation->$attribute = $values['before'];
                        }
                    } else {
                        $reservation->$attribute = null;
                    }
                }
            }


            $activityLog->undo =  config('app.enums.UNDO_FALSE');
            $activityLog->save();
            $reservation->undo = config('app.enums.UNDO_NA');
            $reservation->save();

            $objReservation = Reservation::with('customer')->where('id', $reservationId)->first();

            return response()->json(['reservation' => $objReservation, 'message' => 'Reservation undo successfully'], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function checkCCNumber(Request $request)
    {
        if ($request->cc_number) {
            $guestCustomer = GuestCustomer::where('cc_number', $request->cc_number)
                ->select('cc_status')
                ->first();


            $Customer = Customer::where('cc_number', $request->cc_number)
                ->select('cc_status')
                ->first();

            if ($guestCustomer) {
                if ($guestCustomer->cc_status === 'decline' || $guestCustomer->cc_status === null) {
                    return response()->json(['isAvailable' => 'no']);
                } else {
                    return response()->json(['isAvailable' => 'yes']);
                }
            } else if ($Customer) {
                if ($Customer->cc_status === 'decline' || $Customer->cc_status === null) {
                    return response()->json(['isAvailable' => 'no']);
                } else {
                    return response()->json(['isAvailable' => 'yes']);
                }
            } else {
                return response()->json(['isAvailable' => 'yes']);
            }
        } else {
            return response()->json(['isAvailable' => 'empty']);
        }
    }

    /*  Save Reservation [Writer: Iftikhar Ali]     */
    private function save($reservationData, $service_settings, $customer, $site_id, $ipAddress)
    {
        try {
            // dd($reservationData,$service_settings, $customer, $site_id, $ipAddress);
            // Common reservation fields
            // var_dump($isRoundTrip);
            if ($reservationData['id']) {
                $reservation_obj = Reservation::findOrFail($reservationData['id']);
            } else {
                $reservation_obj = new Reservation();
            }
            // dd($reservationData['customer_notes']);

            $reservation_obj->user_id = request()->segment(1) == 'api' ? Null : Auth::id();
            // $reservation_obj->user_id =  0;
            $reservation_obj->city_id = $reservationData['reservationCity']['id'];
            $reservation_obj->service_type_id = $service_settings['service_type_id'];
            $reservation_obj->customer_notes = $service_settings['customer_notes'];
            $reservation_obj->ip_address = $ipAddress;
            $reservation_obj->customer_id = $customer['id'];
            $reservation_obj->customer_type = $customer['customer_type'];
            $reservation_obj->pay_type_id = $customer['pay_type_id'];
            $reservation_obj->site_id = $site_id ? $site_id : 1;

            //Changes made by Awais for storing schedule Reservation
            $reservation_obj->vehicle_type_id = $reservationData['selected_vehicle']['id'];
            $reservation_obj->ride_type = $reservationData['selected_vehicle']['ride_type'];
            $reservation_obj->pick_up_date = $reservationData['pickup_date'];
            $reservation_obj->pick_up_time = $reservationData['pickup_time'];
            $reservation_obj->travellers = collect($reservationData['travellers'])->sum('count'); // travellers count
            $reservation_obj->luggage = $reservationData['luggage'];
            $reservation_obj->pick_up_location = $reservationData['pickup_location'];
            $reservation_obj->drop_off_location = $reservationData['dropoff_location'];
            //End OF Changes

            if ($service_settings['service_type_id'] !== 4) {
                $reservation_obj->departure_pick_up_date = $reservationData['flight_info']['flight_date'];
                $reservation_obj->departure_pick_up_time = $reservationData['flight_info']['flight_time'];
            }

            // Travellers types if exist (Not for Schedule service)
            $reservation_obj->travellers_types = $reservationData['travellers'];
            if ($service_settings['service_type_id'] === 1) {
                $reservation_obj->selected_airline = $reservationData['flight_info']['flight_airline'];
                $reservation_obj->selected_flight_destination = $reservationData['flight_info']['flight_destination'];
                $reservation_obj->flight_number = $reservationData['flight_info']['flight_number'];

                //Airport ride for airport services
                $reservation_obj->airport_ride = $reservationData['flight_info']['flight_type'] === 'arrival' ? 'from_airport' : 'to_airport';
            }

            //Additional stops, distances and time values if exist
            $reservation_obj->additional_stops = count($reservationData['additional_stops']) > 0 ? $reservationData['additional_stops'] : null;

            $reservation_obj->distance = $reservationData['distance'] ? $reservationData['distance'] : null;
            $reservation_obj->time_duration_text = $reservationData['time_duration_text'] ? $reservationData['time_duration_text'] : null;
            $reservation_obj->time_duration_hours = $reservationData['time_duration_hours'] ? $reservationData['time_duration_hours'] : null;

            //$reservation_obj->vehicles_count = $reservationData['vehicles_count'] ? $reservationData['vehicles_count'] : null;

            // Number of Hours for 'Airport(hourly)' and 'Hourly' Services
            $reservation_obj->drop_off_hours = $reservationData['drop_off_hours'] !== '' ? $reservationData['drop_off_hours'] : null;

            //For Airport hourly  service only
            if ($service_settings['service_type_id'] != 4 && $service_settings['service_type_id'] == 1 && $reservationData['selected_vehicle']) {
                if ($reservationData['selected_vehicle']['ride_type'] == 'hourly') {
                    $reservation_obj->drop_off_hours = $reservationData['drop_off_hours'];
                }
            }
            $reservation_obj->coupon = $reservationData['coupon'];
            $reservation_obj->admin_discount = $reservationData['admin_discount'];
            $reservation_obj->driver_gratuity = $reservationData['driver_gratuity'];
            $reservation_obj->is_on_call = $reservationData['is_on_call'] ? $reservationData['is_on_call'] : 0;
            //$reservation_obj->on_call_charges = $request->on_call_charges;
            $reservation_obj->selected_vehicle = $reservationData['selected_vehicle'] ? $reservationData['selected_vehicle'] : null;
            if ($service_settings['service_type_id'] !== 4 && $reservationData['selected_vehicle']) {

                //if ($reservationData['selected_vehicle']['ride_type'] === 'mileage') {
                // If service selected for millage ride type
                $reservation_obj->additional_millage_charges = $reservationData['selected_vehicle']['milage_fare_detail']['additional_charges'];
                $reservation_obj->milage_fare_detail = $reservationData['selected_vehicle']['milage_fare_detail'];
                // } else if ($reservationData['selected_vehicle']['ride_type'] === 'hourly') {
                // If service selected for hourly ride type
                $reservation_obj->additional_millage_charges = $reservationData['selected_vehicle']['hourly_fare_detail']['additional_charges'];
                $reservation_obj->hourly_fare_detail = $reservationData['selected_vehicle']['hourly_fare_detail'];
                // }
            }
            //for storing charges of schedule Service
            if($service_settings['service_type_id'] === 4){
                $reservation_obj->schedule_fare_detail=$reservationData['selected_vehicle']['schedule_fare_detail'];
                $reservation_obj->check_in_bags = $reservationData['check_in_bags'];
            }
            //end

            //$reservation_obj->pay_type_id = $payTypeId;
            $reservation_obj->total_fare = $reservationData['total_fare'];
            $reservation_obj->status = 'new_reservation';
            // dd($reservation_obj);
            $reservation_obj->save();

            return $reservation_obj; // Return the created reservation object

        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function saveReservation(Request $request)
    {
        $cc_info = null;
        $direct_account = null;
        $cash = null;
        $newReservations = [];
        try {
            $customer_address = $customer_address = $request['booking']['reservation']['pickup_location'];
            if ($request['booking']['service_settings']['service_type_id'] === 1 && $request['booking']['reservation']['flight_info']['flight_type'] === 'arrival') {
                $customer_address = $request['booking']['reservation']['dropoff_location'];
            }
            $requestCustomer = new Request([
                'customer' => $request['booking']['customer'],
                'payment_info' => $request['booking']['payment_info'],
                'address' => $customer_address
            ]);
            $customer = json_decode($this->reservationCustomerHandler($requestCustomer)->content(), true);
            if (isset($customer['error'])) {
                return response()->json(['error' => $customer['error']], 400);
            }
            $reservation = $this->save(
                $request['booking']['reservation'],
                $request['booking']['service_settings'],
                $customer,
                $request->site_id,
                $request->ip()
            );
            
            if ($reservation instanceof \Illuminate\Http\JsonResponse) {
                return $reservation; // Return error response
            }
            
            //$newReservations[] = ["id" => $reservation->id];
            //$email = new EmailSentController();
            //$emailSent = $email->sendReservationConfirmation('hiqusolution@gmail.com', 'GoKcQuickSilver', "Thank you for choosing GoKcQuickSilver Reservation Confirmation");

            if ($request['booking']['reservation']['id'] === 0) $newReservations[] = ["id" => $reservation->id];
            else $newReservations[] = ["id" => $request['booking']['reservation']['id']];

            if ($request['booking']['service_settings']['is_round_trip']) {
                $reservation2 = $this->save(
                    $request['booking']['reservation_2'],
                    $request['booking']['service_settings'],
                    $customer,
                    $request->site_id,
                    $request->ip()
                );
                
                if ($reservation2 instanceof \Illuminate\Http\JsonResponse) {
                    return $reservation2; // Return error response
                }

                $newReservations[] = ["id" => $reservation2->id];

                $resObj = Reservation::findOrFail($reservation->id);
                $resObj2 = Reservation::findOrFail($reservation2->id);
                $resObj2->round_trip = $resObj->id;
                $resObj->round_trip = $resObj2->id;

                $resObj2->save();
                $resObj->save();
            }

            // Return response immediately to frontend
            $response = response()->json($newReservations, 200);

            // Send email asynchronously after response
            try {
                $email = $request['booking']['customer']['email'];
                $reservationIds =  $request['booking']['service_settings']['is_round_trip']
                ? [$newReservations[0]['id'], $newReservations[1]['id']]
                : [$newReservations[0]['id']];
                $subject = $request['booking']['service_settings']['is_edit'] ? 'Changes Made to the Reservation '. implode(' ,', $reservationIds) .'' : 'Reservation Confirmation !';
                
                // Create the mailable and queue it asynchronously
                $mailable = new ReservationConfirmation($request['booking'], $subject,$reservationIds,'emails.reservation_template');
                
                // Use queue method to send email asynchronously - this won't block the response
                $this->emailService->queueEmail($email, $mailable);
                
                // Store log for successful queue (regardless of actual email delivery)
                $this->emailService->storeLog(true, $reservationIds, $subject, $request['booking']['customer']['id']);
            } catch (\Exception $emailException) {
                // Log email error but don't affect the main response
                Log::error('Email queuing failed: ' . $emailException->getMessage());
            }

            return $response;
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function sendEmail($request){
        // $reservationIds = (array)$request->reservation_id;
        $email=$request['booking']['customer']['email'];
        $subject =  'Reservation Confirmation !';
        // $subject = $request->is_edit ? 'Changes Made to the Reservation '. implode(' ,', $reservationIds) .'' : 'Reservation Confirmation !';

        $bladeFile = 'emails.reservation_template';
        try {
            Mail::to($email)->queue(new ReservationConfirmation($request['booking'], $subject, [], $bladeFile));
            return true; // Email sent successfully
        } catch (\Exception $exception) {
            Log::error($expception->getMessage());
            return false; // Email failed to send
        }
    }
    public function reservationCustomerHandler(Request $request)
    {
        try {
            $reqCustomer = $request['customer'];
            $customer = null;
            if ($reqCustomer['id']) {
                $customer = Customer::findOrFail($reqCustomer['id']);
            } else {
                $customer = Customer::where('mobile_number', $reqCustomer['mobile_number'])
                    ->where('first_name', $reqCustomer['first_name'])
                    ->where('last_name', $reqCustomer['last_name'])
                    ->first();
            }

            if (!$customer) {
                $customer = new Customer();
                $customer->first_name = $reqCustomer['first_name'];
                $customer->last_name = $reqCustomer['last_name'];
                $customer->phone_number = $reqCustomer['phone_number'];
                $customer->mobile_number = $reqCustomer['mobile_number'];
                $customer->email = $reqCustomer['email'];
                $customer->customer_type = isset($reqCustomer['customer_type']) ? $reqCustomer['customer_type'] : 'guest';
                $customer->status = 'Guest Customer';
            }

            if (isset($customer)) {
                $customer->first_name = $reqCustomer['first_name'];
                $customer->last_name = $reqCustomer['last_name'];
                $customer->phone_number = $reqCustomer['phone_number'];
                $customer->mobile_number = $reqCustomer['mobile_number'];
                $customer->email = $reqCustomer['email'];
                $customer->address = $request['address'];
                $customer->pay_type_id = $request['payment_info']['payment_type'];
                
                // Only process credit card info if payment type is 3 (credit card) and cc_info is provided
                if ($request['payment_info']['payment_type'] === 3 && 
                    isset($request['payment_info']['cc_info']) && 
                    !$request['payment_info']['use_existing_cc']) {
                    
                    $cc_info = $request['payment_info']['cc_info'];
                    
                    // Check if all required CC fields exist before assigning
                    if (isset($cc_info['card_type'])) $customer->card_type = $cc_info['card_type'];
                    if (isset($cc_info['cc_number'])) $customer->cc_number = $cc_info['cc_number'];
                    if (isset($cc_info['csv_code'])) $customer->csv_code = $cc_info['csv_code'];
                    if (isset($cc_info['billing_zip_code'])) $customer->billing_zip_code = $cc_info['billing_zip_code'];
                    if (isset($cc_info['card_holder_name'])) $customer->card_holder_name = $cc_info['card_holder_name'];
                    if (isset($cc_info['billing_address'])) $customer->billing_address = $cc_info['billing_address'];
                    if (isset($cc_info['is_address_same'])) $customer->is_address_same = $cc_info['is_address_same'];
                    if (isset($cc_info['billing_phone_number'])) $customer->billing_phone_number = $cc_info['billing_phone_number'];
                    
                    // Credit card expiration date format making
                    if (isset($cc_info['cc_expiry_month']) && isset($cc_info['cc_expiry_year'])) {
                        $cc_expiry_month = $cc_info['cc_expiry_month'];
                        $cc_expiry_year = $cc_info['cc_expiry_year'];
                        $customer->cc_expiry = $cc_expiry_month . '-' . $cc_expiry_year;
                    }
                } else if ($request['payment_info']['payment_type'] === 4 && isset($request['payment_info']['direct_account']['account_id'])) {
                    $customer->direct_account_id = $request['payment_info']['direct_account']['account_id'];
                }
                
                $customer->customer_type = isset($customer['password']) ? 'Registered' : 'guest';
                $customer->save();
            }
            
            if ($customer) {
                return response()->json($customer, 200);
            } else {
                return response()->json(['error' => 'Customer[' . $reqCustomer['id'] . '] not Found'], 400);
            }
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
