<?php

namespace App\Http\Controllers\Admin\Reports\Sales;

use Illuminate\Http\Request;
use App\Models\Admin\Customer;
use App\Models\Admin\Services;
use App\Models\Admin\Reservation;
use App\Models\Admin\GuestCustomer;
use App\Http\Controllers\Controller;

class SalesController extends Controller
{
    public function index()
    {
        return view('admin.reports.sales.index');
    }
    public function getFilterData(Request $request)
    {
        $selectedService = $request->input('selectedServiceId');
        $fromDate = $request->input('fromDate');
        $toDate = $request->input('toDate');
        $serviceMapping = [
            'departure' => 1,
            'arrival' => 1,
            'hourly' => 2,
            'point_to_point' => 3,
            'schedule_departure' => 4,
            'schedule_arrival' => 4,
            'schedule_city' => 4,
        ];

        $selectedServiceId = $serviceMapping[$selectedService] ?? null;
        $query = Reservation::query();
        if (!is_null($selectedServiceId)) {
            switch ($selectedServiceId) {
                case 1:
                    if ($selectedService === 'departure') {
                        $query->where('service_type_id', 1)
                        ->where('airport_ride', 'to_airport');
                    } elseif ($selectedService === 'arrival') {
                        $query->where('service_type_id', 1)
                        ->where('airport_ride', 'from_airport');
                    }
                    break;
                case 2:
                    $query->where('service_type_id', 2);
                    break;
                case 3:
                    $query->where('service_type_id', 3);
                    break;
                case 4:
                    $query->where('service_type_id', 4);
                    if ($selectedService === 'schedule_departure') {
                        $query->where('airport_ride', 'to_airport');
                    } elseif ($selectedService === 'schedule_arrival') {
                        $query->where('airport_ride', 'from_airport');
                    } elseif ($selectedService === 'schedule_city') {
                        $query->whereNull('airport_ride');
                    }
                    break;
                default:
                    // No specific conditions
                    break;
            }
        }
        if (!empty($fromDate) && !empty($toDate)) {
            $filteredReservations = $query->select('id', 'customer_type', 'customer_id')->whereDate('created_at', '>=', request('fromDate'))
            ->whereDate('created_at', '<=', request('toDate'))->get();
        }

        $filteredReservations = $query->where('driver_status', 'completed')->select('id', 'customer_type', 'customer_id', 'total_fare', 'pay_type_id')->get();

        foreach ($filteredReservations as $reservation) {
            // Populate the pay_type attribute based on pay_type_id
            // dd($reservation->pay_type_id);
            switch ($reservation->pay_type_id) {
                case 1:
                    $reservation->pay_type = 'Cash';
                    break;
                case 2:
                    $reservation->pay_type = 'Cheque';
                    break;
                case 3:
                    $reservation->pay_type = 'Credit Card';
                    break;
                case 4:
                    $reservation->pay_type = 'Direct Account';
                    break;
                default:
                    $reservation->pay_type = 'Unknown';
                    break;
            }
        }

        foreach ($filteredReservations as $reservation) {
            $Customer = Customer::where('id', $reservation->customer_id)->first();
            $reservation->full_name = $Customer ? $Customer->first_name . ' ' . $Customer->last_name : 'Customer not found';
        }


        return response()->json($filteredReservations);
    }
}
