<?php

namespace App\Http\Controllers\Admin\Reports\Expense;

use Illuminate\Http\Request;
use App\Models\Admin\UserGroup;
use App\Models\Admin\ExpensesHead;
use App\Http\Controllers\Controller;
use App\Models\Admin\ExpenseDetails;

class ExpenseReportController extends Controller
{
    public function index()
    {
        return view('admin.reports.expense-report.index');
    }

    public function getExpenseData(Request $request)
    {
        try {
            $expenseId = $request->input('selectedExpenseId');
            $fromDate = $request->input('fromDate');
            $toDate = $request->input('toDate');
            if ($expenseId === 'all') {
                $expense_details_data = ExpenseDetails::select('amount', 'expense_date', 'user_group_id', 'expense_id')->whereDate('expense_date', '>=', $fromDate)
                    ->whereDate('expense_date', '<=', $toDate)->get();
            } else {
                $expense_details_data = ExpenseDetails::where('expense_id', $expenseId)->select('amount', 'expense_date', 'user_group_id', 'expense_id')->whereDate('expense_date', '>=', $fromDate)
                    ->whereDate('expense_date', '<=', $toDate)->get();
            }
            return response()->json($expense_details_data, 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function getData()
    {
        try {
            $expenses = ExpensesHead::select('id', 'name')->get();
            $user_groups = UserGroup::select('id', 'name')->get();

            return response()->json(['expenses' => $expenses, 'user_groups' => $user_groups], 200);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }
}
