<?php

namespace App\Http\Controllers\Admin\Reports;

use App\Models\Admin\Driver;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Admin\Reservation;

class DriverReportController extends Controller
{
    public function index(){
        $drivers = Driver::select('id','first_name','last_name')->orderBy('first_name', 'ASC')->get();
        return view('admin.reports.driver-summary.index',[
                    'drivers' => $drivers
                ]);
    }

    public function getFilteredData(Request $request)
    {
        $fromDate = $request->query('fromDate');
        $toDate = $request->query('toDate');
        $selectedDriver = $request->query('selectedDriver');

        $reservationsQuery = Reservation::join('drivers', 'reservations.driver_id', '=', 'drivers.id')
            ->whereNotNull('driver_id')
            ->whereDate('reservations.updated_at', '>=', $fromDate)
            ->whereDate('reservations.updated_at', '<=', $toDate)
            ->select('driver_id', 'driver_status')
            ->selectRaw('COUNT(CASE WHEN driver_status = "Completed" THEN 1 END) as completed_count')
            ->selectRaw('COUNT(CASE WHEN driver_status = "Cancel" THEN 1 END) as cancel_count')
            ->selectRaw('COUNT(CASE WHEN driver_status = "No Show" THEN 1 END) as no_show_count')
            ->selectRaw('COUNT(CASE WHEN driver_status = "No Run" THEN 1 END) as no_run_count')
            ->selectRaw('SUM(CASE WHEN driver_status = "Completed" THEN distance ELSE 0 END) as total_mileage')
            ->selectRaw('SUM(CASE WHEN driver_status = "Completed" THEN TIMESTAMPDIFF(HOUR, ride_started_time, ride_completed_time) ELSE 0 END) as total_hours')
            ->selectRaw('SUM(CASE WHEN driver_status = "Completed" THEN total_fare ELSE 0 END) as total_amount')
            ->selectRaw('SUM(
                CASE
                    WHEN driver_status = "Completed" AND drivers.category_id != 1
                    THEN total_fare * (drivers.salary / 100)
                    ELSE 0
                END
            ) as commission_amount')
            ->groupBy('driver_id')
            ->with(['driver:id,first_name,last_name,category_id,salary', 'driver.category:id,category_name']);

        // Check if a specific driver is selected
        if ($selectedDriver !== 'all') {
            $reservationsQuery->where('driver_id', $selectedDriver);
        }

        $reservations = $reservationsQuery->orderBy('first_name', 'ASC')->get();

        return response()->json($reservations, 200);
    }

}
